package com.github.suninvr.virtualadditions.fluid;

import com.github.suninvr.virtualadditions.registry.*;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_5955;

public abstract class AcidFluid extends class_3609 {
    @Override
    public class_3611 method_15750() {
        return VAFluids.FLOWING_ACID;
    }

    @Override
    public class_3611 method_15751() {
        return VAFluids.ACID;
    }

    @Override
    public boolean method_15780(class_3611 fluid) {
        return fluid == method_15751() || fluid == method_15750() || fluid == class_3612.field_15910 || fluid == class_3612.field_15909;
    }

    @Override
    protected boolean method_15737(class_3218 serverWorld) {
        return false;
    }

    @Override
    protected void method_15730(class_1936 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        class_2248.method_9610(state, world, pos, blockEntity);
    }

    @Override
    protected boolean method_15795() {
        return true;
    }

    @Override
    protected void method_15792(class_3218 serverWorld, class_2338 pos, class_3610 state, class_5819 random) {
        if (state.method_15761() > 6 && serverWorld.method_8320(pos.method_10074()).method_27852(class_2246.field_10092)) {
            serverWorld.method_8501(pos, VABlocks.ACID_BLOCK.method_9564());
        }

        class_2338 offsetPos = pos.method_10093(class_2350.method_10162(random));
        class_2680 offsetState = serverWorld.method_8320(offsetPos);
        if (offsetState.method_26204() instanceof class_5955) {
            serverWorld.method_8501(offsetPos, class_5955.method_34735(offsetState).orElse(offsetState));
        }
    }

    public void method_15776(class_1937 world, class_2338 pos, class_3610 state, class_5819 random) {
        if (!state.method_15771() && !(Boolean)state.method_11654(field_15902)) {
            if (random.method_43048(64) == 0) {
                world.method_8486(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, class_3417.field_15237, class_3419.field_15245, random.method_43057() * 0.25F + 0.75F, random.method_43057() + 0.1F, true);
            }
        } else if ( world.method_8320(pos.method_10084()).method_26215()) {
            if (random.method_43048(200) == 0) {
                world.method_8486(pos.method_10263(), pos.method_10264(), pos.method_10260(), VASoundEvents.ACID_AMBIENT, class_3419.field_15245, 0.2F + random.method_43057() * 0.2F, 0.9F + random.method_43057() * 0.15F, true);
            } else if (random.method_43048(100) == 0) {
                world.method_8486(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, VASoundEvents.ACID_SIZZLE, class_3419.field_15245, 0.6F + random.method_43057() * 0.2F, 0.8F + random.method_43057() * 0.3F, true);
                world.method_8406(VAParticleTypes.ACID_SPLASH_EMITTER, pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
            }
        }

    }

    @Override
    protected int method_15733(class_4538 world) {
        return 7;
    }

    @Override
    protected int method_15739(class_4538 world) {
        return 1;
    }

    @Override
    public class_1792 method_15774() {
        return VAItems.ACID_BUCKET;
    }

    @Override
    protected boolean method_15777(class_3610 state, class_1922 world, class_2338 pos, class_3611 fluid, class_2350 direction) {
        return !state.method_15767(VAFluids.ACID_TAG);
    }

    @Override
    public Optional<class_3414> method_32359() {
        return Optional.of(VASoundEvents.BUCKET_FILL_ACID);
    }

    @Override
    public int method_15789(class_4538 world) {
        return 10;
    }

    @Override
    protected float method_15784() {
        return 100;
    }

    @Override
    protected class_2680 method_15790(class_3610 state) {
        return VABlocks.ACID.method_9564().method_11657(class_2741.field_12538, method_15741(state));
    }


    public static class Flowing extends AcidFluid {
        public Flowing() {
        }

        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(field_15900);
        }

        public int method_15779(class_3610 state) {
            return state.method_11654(field_15900);
        }

        public boolean method_15793(class_3610 state) {
            return false;
        }
    }

    public static class Still extends AcidFluid {
        public Still() {
        }

        public int method_15779(class_3610 state) {
            return 8;
        }

        public boolean method_15793(class_3610 state) {
            return true;
        }
    }
}
