package com.github.suninvr.virtualadditions.item;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.registry.VAItemTags;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9886;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;

public class GildType {
    public static final class_2960 GILDED_TOOL_BLOCK_INTERACTION_RANGE_MODIFIER_ID = VirtualAdditions.idOf("gilded_tool_block_interaction_range");
    public static final class_2960 GILDED_TOOL_ENTITY_INTERACTION_RANGE_MODIFIER_ID = VirtualAdditions.idOf("gilded_tool_entity_interaction_range");
    private final ArrayList<Modifier> modifiers = new ArrayList<>();
    private final class_2960 id;
    private final int color;
    private class_6862<class_1792> tag;
    private class_6862<class_1792> axesTag;
    private class_6862<class_1792> hoesTag;
    private class_6862<class_1792> pickaxesTag;
    private class_6862<class_1792> shovelsTag;
    private class_6862<class_1792> swordsTag;
    private class_6862<class_1792> halberdsTag;

    public record Modifier(class_2960 id, ModifierType type, float value, BiFunction<Float, Float, Float> function, ModifierType.ToolType... appliesTo){

        public float apply(float f) {
            return this.function.apply(f, this.value);
        }

        public int apply(int i) {
            return Math.round(this.function.apply((float) i, this.value));
        }

        public float apply(float f, class_1792 baseItem) {
            return this.shouldApplyToTool(baseItem) ? this.apply(f) : f;
        }

        public int apply(int i, class_1792 baseItem) {
            return this.shouldApplyToTool(baseItem) ? this.apply(i) : i;
        }

        public boolean shouldApplyToTool(class_1792 item) {
            if (this.appliesTo.length == 0) return true;
            for (ModifierType.ToolType type : this.appliesTo) {
                if (type.matches(item)) return true;
            }
            return false;
        }

        public boolean shouldBeAppended() {
            return this.type.shouldBeAppended();
        }

        public boolean modifiesAttribute(class_6880<class_1320> attribute) {
            return this.type.getAttributeType() != null && this.type.getAttributeType().equals(attribute);
        }
    }

    /**
     * Constructor for gild types. Each gild type has a set of modifiers to apply to the base tool's attributes.
     * For extended functionality, some methods are provided for interacting with the world.
     *
     * @param id The identifier used by this gild
     * @param color The color of the gild type's tooltip
     * @param modifiers The attribute modifiers to apply to tools using this gild
     */
    public GildType(class_2960 id, int color, Modifier... modifiers) {
        this.id = id;
        this.color = color;
        this.modifiers.addAll(Arrays.asList(modifiers));
    }

    /**
     * Gets whether the gild should play effects or interact with the world after breaking a specific block.
     *
     * @return <code>true</code> if the gild type is effective, <code>false</code> if it is not effective.
     *
     * @param world the world in which the block was broken
     * @param pos the position of the block that was broken
     * @param player the player that broke the block
     * @param state the state of the broken block
     * @param tool the tool used to break the block
     *
     * **/
    public boolean isGildEffective(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_1799 tool) {
        return tool.method_7951(state);
    }

    /**
     * Plays effects in the world after a tool with this gild type breaks a block.
     *
     * @param world the world in which the block was broken
     * @param pos the position of the block that was broken
     * @param tool the tool used to break the block
     * **/
    public void emitBlockBreakingEffects(class_1937 world, class_1657 player, class_2338 pos, class_1799 tool) {}

    /**
     * Affects the world after a tool with this gild type breaks a block.
     *
     * @return <code>true</code> if the block should still break normally, <code>false</code> if it should not.
     *
     * @param world the world in which the block was broken
     * @param pos the position of the block that was broken
     * @param player the player that broke the block
     * @param state the state of the broken block
     * @param tool the tool used to break the block
     *
     * @implNote Returning false will disable <b><i>all effects</i></b> of breaking a block, such damaging the tool and increasing the player's relevant stats.
     *
     * **/
    public boolean onBlockBroken(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_1799 tool) {
        return true;
    }

    public boolean hasHitEffects() {
        return false;
    }

    public void applyEffectsOnHit(class_1937 world, class_1309 target, class_1309 attacker) {

    }

    /**
     * Modifies a given tool material with the modifications provided at the gild type's creation.
     *
     * @param baseMaterial the tool material to apply this gild type's modifications to
     * @return a new tool material with modifiers applied
     **/
    public final ModifiedToolMaterial getModifiedMaterial(class_9886 baseMaterial) {
        return new ModifiedToolMaterial(baseMaterial, this.modifiers);
    }

    public class_9285 createAttributeModifiers(class_1792 baseItem) {
        class_9285.class_9286 builder = class_9285.method_57480();

        class_9285.class_9286 builderCopy = builder;
        baseItem.method_57347().method_58694(class_9334.field_49636).comp_2393().forEach(entry -> {
            class_1322 modifier = entry.comp_2396();
            if (entry.comp_2395().equals(class_5134.field_23723) || entry.comp_2395().equals(class_5134.field_23721)) {
                double[] value = {modifier.comp_2449()};
                this.modifiers.forEach(gildModifier -> {
                    if (gildModifier.modifiesAttribute(entry.comp_2395()) && gildModifier.shouldApplyToTool(baseItem)) {
                        value[0] = gildModifier.apply((float) value[0]);
                    }
                });
                modifier = new class_1322(entry.comp_2396().comp_2447(), value[0], modifier.comp_2450());
            }
            builderCopy.method_57487(entry.comp_2395(), modifier, entry.comp_2397());
        });

        builder = this.appendAttributeModifiers(builderCopy, baseItem);
        return builder.method_57486();
    }

    public final class_9285.class_9286 appendAttributeModifiers(class_9285.class_9286 builder, class_1792 baseItem) {
        this.modifiers.forEach( modifier -> {
            if (!modifier.shouldBeAppended() || !modifier.shouldApplyToTool(baseItem)) return;
            class_6880<class_1320> attribute = modifier.type.getAttributeType();
            if (attribute != null) {
                builder.method_57487(attribute, new class_1322(modifier.id, modifier.value, class_1322.class_1323.field_6328), class_9274.field_49217);
            }
        });
        return builder;
    }

    public final String buildTooltipTranslationKey() {
        return "gild_type." + this.id.method_12836() + "." + this.id.method_12832();
    }

    /**
     * Gets the color of the gild type's tooltip text
     *
     * @return An integer representing the color
     */
    public int getColor() {
        return color;
    }

    /**
     * Gets the gild type's id
     *
     * @return the identifier of the gild type
     */
    public class_2960 getId() {
        return this.id;
    }

    /**
     * Determines if the gild type modifiers will modify the base material
     *
     * @return 'true' if the modifiers do modify the base material
     */
    private boolean shouldModifyBaseMaterial() {
        for (Modifier modifier : this.modifiers) {
            if (modifier.type.modifiesBaseMaterial) return true;
        }
        return false;
    }


    /**
     * Gets or creates a tag associated with this gild type
     */
    public class_6862<class_1792> getTag() {
        if (this.tag == null) {
            class_2960 id = this.id.method_48331("_gilded_tools");
            this.tag = class_6862.method_40092(class_7924.field_41197, id);
        }
        return this.tag;
    }
    
    public class_6862<class_1792> getAxesTag() {
        if (this.axesTag == null) {
            class_2960 id = this.id.method_48331("_gilded_axes");
            this.axesTag = class_6862.method_40092(class_7924.field_41197, id);
        }
        return this.axesTag;
    }

    public class_6862<class_1792> getHoesTag() {
        if (this.hoesTag == null) {
            class_2960 id = this.id.method_48331("_gilded_hoes");
            this.hoesTag = class_6862.method_40092(class_7924.field_41197, id);
        }
        return this.hoesTag;
    }

    public class_6862<class_1792> getPickaxesTag() {
        if (this.pickaxesTag == null) {
            class_2960 id = this.id.method_48331("_gilded_pickaxes");
            this.pickaxesTag = class_6862.method_40092(class_7924.field_41197, id);
        }
        return this.pickaxesTag;
    }

    public class_6862<class_1792> getShovelsTag() {
        if (this.shovelsTag == null) {
            class_2960 id = this.id.method_48331("_gilded_shovels");
            this.shovelsTag = class_6862.method_40092(class_7924.field_41197, id);
        }
        return this.shovelsTag;
    }

    public class_6862<class_1792> getSwordsTag() {
        if (this.swordsTag == null) {
            class_2960 id = this.id.method_48331("_gilded_swords");
            this.swordsTag = class_6862.method_40092(class_7924.field_41197, id);
        }
        return this.swordsTag;
    }

    public class_6862<class_1792> getHalberdsTag() {
        if (this.halberdsTag == null) {
            class_2960 id = this.id.method_48331("_gilded_halberds");
            this.halberdsTag = class_6862.method_40092(class_7924.field_41197, id);
        }
        return this.halberdsTag;
    }

    @Override
    public final boolean equals(Object obj) {
        return (obj instanceof GildType gildType && gildType.getId().equals(this.id)) || (obj instanceof class_2960 identifier && identifier.equals(this.id));
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    protected enum ModifierType {
        DURABILITY,
        MINING_SPEED,
        ATTACK_DAMAGE,
        ENCHANTABILITY,
        ATTACK_SPEED(false),
        BLOCK_INTERACTION_RANGE(false),
        ENTITY_INTERACTION_RANGE(false);

        protected enum ToolType {
            SWORD,
            SHOVEL,
            PICKAXE,
            AXE,
            HOE,
            HALBERD;

            public boolean matches(class_1792 item) {
                return switch (this) {
                    case SWORD -> class_7923.field_41178.method_10221(item).method_12832().contains("sword");
                    case SHOVEL -> item instanceof class_1821;
                    case PICKAXE -> class_7923.field_41178.method_10221(item).method_12832().contains("pickaxe");
                    case AXE -> item instanceof class_1743;
                    case HOE -> item instanceof class_1794;
                    case HALBERD -> class_7923.field_41178.method_10221(item).method_12832().contains("halberd");
                };
            }
        }

        private final boolean modifiesBaseMaterial;

        ModifierType(boolean modifiesBaseMaterial) {
            this.modifiesBaseMaterial = modifiesBaseMaterial;
        }

        @Nullable
        public class_6880<class_1320> getAttributeType() {
            return switch (this) {
                case BLOCK_INTERACTION_RANGE -> class_5134.field_47758;
                case ENTITY_INTERACTION_RANGE -> class_5134.field_47759;
                case ATTACK_SPEED -> class_5134.field_23723;
                case ATTACK_DAMAGE -> class_5134.field_23721;
                default -> null;
            };
        }

        public UUID getAttributeId() {
            return switch (this) {
                case BLOCK_INTERACTION_RANGE -> UUID.fromString("C39B0D39-EB64-45E9-A58E-52DA390DD1A2");
                case ENTITY_INTERACTION_RANGE -> UUID.fromString("D4786B0F-DF61-45D8-B77C-E5B55C4F4066");
                case ATTACK_SPEED -> UUID.fromString("68701EAF-5C43-42E8-95F0-BAA0E3E2438A");
                case ATTACK_DAMAGE -> UUID.fromString("F09A0E0B-32E7-407C-A4E6-17E9F5EB9C2B");
                default -> UUID.fromString("0-0-0-0-0");
            };
        }

        public boolean shouldBeAppended() {
            return !this.equals(ATTACK_SPEED) && !this.equals(ATTACK_DAMAGE);
        }

        ModifierType() {
            this.modifiesBaseMaterial = true;
        }
    }

    public static class ModifiedToolMaterial {
        private final class_9886 baseMaterial;
        private final class_6862<class_2248> inverseTag;
        private int itemDurability;
        private float miningSpeed;
        private float attackDamageBonus;
        private int enchantability;
        private float blockInteractionRange = 0.0f;
        private float entityInteractionRange = 0.0f;
        private float attackSpeed = 0.0f;
        private final class_6862<class_1792> repairItems;
        
        public ModifiedToolMaterial(class_9886 baseMaterial, List<Modifier> modifiers) {
            this.baseMaterial = baseMaterial;
            this.inverseTag = baseMaterial.comp_2930();
            this.itemDurability = baseMaterial.comp_2931();
            this.miningSpeed = baseMaterial.comp_2932();
            this.attackDamageBonus = baseMaterial.comp_2933();
            this.enchantability = baseMaterial.comp_2934();
            this.repairItems = baseMaterial.comp_2935();
            this.applyModifiers(modifiers);
        }

        private void applyModifiers(List<Modifier> modifiers) {
            modifiers.forEach(modifier -> {
                switch (modifier.type()) {
                    case DURABILITY -> itemDurability = modifier.apply(itemDurability);
                    case MINING_SPEED -> miningSpeed = modifier.apply(miningSpeed);
                    case ATTACK_DAMAGE -> attackDamageBonus = modifier.apply(attackDamageBonus);
                    case ENCHANTABILITY -> enchantability = modifier.apply(enchantability);
                    case BLOCK_INTERACTION_RANGE -> blockInteractionRange = modifier.apply(blockInteractionRange);
                    case ENTITY_INTERACTION_RANGE -> entityInteractionRange = modifier.apply(entityInteractionRange);
                    case ATTACK_SPEED -> attackSpeed = modifier.apply(attackSpeed);
                }
            });
        }

        public class_9886 asToolMaterial() {
            return new class_9886(this.inverseTag, this.itemDurability, this.miningSpeed, this.attackDamageBonus, this.enchantability, this.repairItems);
        }

        public class_9886 getBaseMaterial() {
            return baseMaterial;
        }

        private class_1792.class_1793 applyBaseSettings(class_1792.class_1793 settings) {
            return settings.method_7895(this.itemDurability).method_61647(this.repairItems).method_61649(this.enchantability);
        }

        public class_1792.class_1793 applyToolSettings(class_1792.class_1793 settings, class_6862<class_2248> effectiveBlocks, float attackDamage, float attackSpeed, boolean breaksShield) {
            class_7871<class_2248> registryEntryLookup = class_7923.method_62715(class_7923.field_41175);
            return this.applyBaseSettings(settings).method_57349(class_9334.field_50077, new class_9424(List.of(class_9424.class_9425.method_58427(registryEntryLookup.method_46735(baseMaterial.comp_2930())), class_9424.class_9425.method_58431(registryEntryLookup.method_46735(effectiveBlocks), this.miningSpeed)), 1.0F, 1, breaksShield)).method_57348(this.createToolAttributeModifiers(attackDamage, attackSpeed));
        }

        private class_9285 createToolAttributeModifiers(float attackDamage, float attackSpeed) {
            class_9285.class_9286 builder = class_9285.method_57480();
            builder.method_57487(class_5134.field_23721, new class_1322(class_1792.field_8006, attackDamage + this.attackDamageBonus, class_1322.class_1323.field_6328), class_9274.field_49217);
            builder.method_57487(class_5134.field_23723, new class_1322(class_1792.field_8001, attackSpeed + this.attackSpeed, class_1322.class_1323.field_6328), class_9274.field_49217);
            if (!(this.blockInteractionRange == 0)) builder.method_57487(class_5134.field_47758, new class_1322(GILDED_TOOL_BLOCK_INTERACTION_RANGE_MODIFIER_ID, this.blockInteractionRange, class_1322.class_1323.field_6328), class_9274.field_49217);
            if (!(this.entityInteractionRange == 0)) builder.method_57487(class_5134.field_47759, new class_1322(GILDED_TOOL_ENTITY_INTERACTION_RANGE_MODIFIER_ID, this.entityInteractionRange, class_1322.class_1323.field_6328), class_9274.field_49217);
            return builder.method_57486();
        }
    }
}
