package com.github.suninvr.virtualadditions.item;

import com.github.suninvr.virtualadditions.item.interfaces.GildedToolItem;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3481;
import net.minecraft.class_5244;
import net.minecraft.class_9886;
import net.minecraft.item.*;
import java.util.List;
import java.util.function.Consumer;

public class GildedAxeItem extends class_1792 implements GildedToolItem {
    private final GildType gildType;
    private final class_1792 baseItem;
    private static final class_2561 descriptionHeader = class_2561.method_43471("item.minecraft.smithing_template.upgrade").method_27692(class_124.field_1080);
    private final class_2561 descriptionText;

    public GildedAxeItem(GildType gildType, class_9886 baseMaterial, class_1743 baseItem, class_1793 settings) {
        super(
                GildedToolUtil.settingsOf(
                        gildType.getModifiedMaterial(baseMaterial).asToolMaterial()
                                .method_61663(
                                        settings,
                                        class_3481.field_33713,
                                        baseMaterial.comp_2933(),
                                        baseMaterial.comp_2932(),
                                        5.0F)
                        , baseItem, gildType));
        this.gildType = gildType;
        this.baseItem = baseItem;
        this.descriptionText = class_5244.method_48320().method_10852(class_2561.method_43471(this.gildType.buildTooltipTranslationKey()).method_10862(class_2583.field_24360.method_36139(this.gildType.getColor())));
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        return this.baseItem.method_7884(context);
    }

    @Override
    public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7970(2, attacker, class_1304.field_6173);
    }

    @Override
    public GildType getGildType() {
        return this.gildType;
    }

    @Override
    public void method_67187(class_1799 stack, class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        textConsumer.accept(descriptionHeader);
        textConsumer.accept(this.descriptionText);
        super.method_67187(stack, context, displayComponent, textConsumer, type);
    }

    @Override
    public class_1792 getBaseItem() {
        return baseItem;
    }
}
