package com.github.suninvr.virtualadditions.item;

import com.github.suninvr.virtualadditions.block.entity.MiniPortalBlockEntity;
import com.github.suninvr.virtualadditions.component.PortalCoreLocationComponent;
import com.github.suninvr.virtualadditions.registry.*;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

public class PortalCoreItem extends class_1792 {
    public PortalCoreItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        super.method_7888(stack, world, entity, slot);
        if (entity.field_6012 % 4 != 0) return;
        if (entity instanceof class_3222 player && (class_1304.field_6173.equals(slot) || class_1304.field_6171.equals(slot)) && stack.method_57826(VADataComponentTypes.PORTAL_CORE_LOCATION)) {
            stack.method_58694(VADataComponentTypes.PORTAL_CORE_LOCATION).pos().ifPresent(pos1 -> {
                class_243 centerPos = pos1.method_46558();
                world.method_14166(player, VAParticleTypes.INTERFERENCE, true, true, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), 1, 0.25F, 0.25F, 0.25F, 0.0);
            });
        }
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_2338 pos = context.method_8037().method_10093(context.method_8038());
        class_3414 sound = VASoundEvents.ITEM_PORTAL_CORE_USE;
        float pitch = 0.8F;
        if (!context.method_8045().method_8320(pos).method_26215() && !context.method_8045().method_8320(pos).method_27852(class_2246.field_10382)) return class_1269.field_5811;
        class_1799 stack = context.method_8041();
        if (stack.method_57826(VADataComponentTypes.PORTAL_CORE_LOCATION) && !context.method_8045().method_8608()) {
            boolean[] bl = {false};
            class_2338[] destPos = {null};
            stack.method_58694(VADataComponentTypes.PORTAL_CORE_LOCATION).pos().ifPresent(pos1 -> {
                destPos[0] = pos1;
                bl[0] = placePortalPair((class_3218) context.method_8045(), pos, pos1, context.method_8036());
            });
            if (bl[0] || pos.equals(destPos[0])) stack.method_57381(VADataComponentTypes.PORTAL_CORE_LOCATION);
            if (bl[0]) {
                sound = VASoundEvents.BLOCK_MINI_PORTAL_OPEN;
                pitch = 1.1F;
                stack.method_7934(1);
            } else {
                pitch = 0.2F;
            }
        } else {
            stack.method_57379(VADataComponentTypes.PORTAL_CORE_LOCATION, PortalCoreLocationComponent.of(pos));
        }
        context.method_8045().method_8396(null, context.method_8037(), sound, class_3419.field_15245, 1.0F, pitch);
        return class_1269.field_5812;
    }

    private boolean placePortalPair(class_3218 world, class_2338 pos1, class_2338 pos2, class_1657 player) {
        if (pos1.equals(pos2)) return false;
        int range = world.method_64395().method_8356(VAGameRules.MINI_PORTAL_MAX_CREATION_RANGE);
        if (!player.method_68878() && Math.sqrt(pos1.method_46558().method_1025(pos2.method_46558())) > range) return false;
        boolean bl1 = world.method_8320(pos1).method_26215() || world.method_8320(pos1).method_27852(class_2246.field_10382);
        boolean bl2 = world.method_8320(pos1).method_26215() || world.method_8320(pos1).method_27852(class_2246.field_10382);
        if (!bl1 || !bl2) return false;
        world.method_8501(pos1, VABlocks.MINI_PORTAL.method_9564().method_11657(class_2741.field_12508, world.method_8316(pos1).method_39360(class_3612.field_15910)));
        world.method_8501(pos2, VABlocks.MINI_PORTAL.method_9564().method_11657(class_2741.field_12508, world.method_8316(pos2).method_39360(class_3612.field_15910)));
        MiniPortalBlockEntity.setDestination(world, pos1, pos2);
        MiniPortalBlockEntity.setDestination(world, pos2, pos1);
        return true;
    }
}
