package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.item.GildType;
import com.github.suninvr.virtualadditions.item.GildTypes;
import com.github.suninvr.virtualadditions.item.interfaces.GildedToolItem;
import com.github.suninvr.virtualadditions.registry.VAEnchantmentTags;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_636;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_636.class)
public abstract class ClientPlayerInteractionManagerMixin {
    @Shadow
    private int blockBreakingCooldown;
    @Shadow public abstract class_1934 getCurrentGameMode();
    @Unique private class_2680 brokenState;
    @Unique private final class_310 client = class_310.method_1551();

    @Inject(method = "breakBlock", at = @At("HEAD"))
    private void virtualAdditions$setBrokenBlockState(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (client.field_1687 != null) this.brokenState = client.field_1687.method_8320(pos);
    }

    @WrapOperation(method = "updateBlockBreakingProgress", at = @At(value = "FIELD", target = "Lnet/minecraft/client/network/ClientPlayerInteractionManager;blockBreakingCooldown:I", opcode = Opcodes.PUTFIELD, ordinal = 2))
    private void virtualAdditions$changeBlockBreakingCooldown2(class_636 instance, int value, Operation<Void> original) {
        original.call(instance, value);
        value = virtualAdditions$getBlockBreakingCooldown(this.blockBreakingCooldown);
        this.blockBreakingCooldown = value;
    }

    @Unique
    int virtualAdditions$getBlockBreakingCooldown(int original) {
        int cooldown = original;
        if (client.field_1724 == null && !getCurrentGameMode().equals(class_1934.field_9220)) return 5;
        class_1799 heldStack = client.field_1724.method_6047();
        GildType gild = GildedToolItem.getGildType(heldStack);
        if (heldStack.method_7951(this.brokenState) && !gild.equals(GildTypes.SCULK)) {
            double d = Math.max(0, (client.field_1724.method_7351(this.brokenState) / 10.0) - 1);
            int y = (gild.equals(GildTypes.AMETHYST) ? 3 : 0) + (int) Math.floor(d);
            cooldown = Math.max(0, cooldown - y);
        }
        return cooldown;
    }
}
