package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import com.github.suninvr.virtualadditions.interfaces.DamageSourcesInterface;
import com.github.suninvr.virtualadditions.interfaces.EntityInterface;
import com.github.suninvr.virtualadditions.registry.VABlockTags;
import com.github.suninvr.virtualadditions.registry.VAFluids;
import com.github.suninvr.virtualadditions.registry.VAItemTags;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1275;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_5568;
import net.minecraft.class_6862;
import net.minecraft.class_8109;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Optional;

@Mixin(class_1297.class)
public abstract class EntityMixin implements class_1275, class_5568, class_2165, EntityInterface {

    @Shadow protected boolean firstUpdate;

    @Shadow protected Object2DoubleMap<class_6862<class_3611>> fluidHeight;

    @Shadow public abstract class_1937 getEntityWorld();

    @Shadow public abstract boolean updateMovementInFluid(class_6862<class_3611> tag, double speed);

    @Shadow public abstract class_8109 getDamageSources();
    @Shadow public abstract class_2338 method_24515();
    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    @Shadow public Optional<class_2338> supportingBlockPos;
    @Shadow public abstract boolean damage(class_3218 world, class_1282 source, float amount);
    @Shadow private class_1937 world;

    @Unique private int ticksInAcid;
    @Unique private long lastUsedMiniPortal;

    @Inject(method = "getPosWithYOffset", at = @At("RETURN"), locals = LocalCapture.CAPTURE_FAILHARD, cancellable = true)
    void virtualAdditions$getPosWithYOffsetForHedge(float offset, CallbackInfoReturnable<class_2338> cir) {
        if (this.supportingBlockPos.isPresent()) {
            class_2338 blockPos = this.supportingBlockPos.get();
            class_2680 blockState = this.getEntityWorld().method_8320(blockPos);
            if (blockState.method_26164(VABlockTags.HEDGES)) {
                cir.setReturnValue( blockPos );
            }
        }
    }

    @Inject(method = "baseTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/profiler/Profiler;pop()V", shift = At.Shift.BEFORE))
    void virtualAdditions$baseTickInAcid(CallbackInfo ci) {
        if(this.world instanceof class_3218 serverWorld && this.virtualAdditions$isInAcid() && (!( (class_1297)(Object)this instanceof class_1542 itemEntity) || !itemEntity.method_6983().method_31573(VAItemTags.ACID_RESISTANT))) {
            if (this.ticksInAcid >= 20) this.damage(serverWorld, ((DamageSourcesInterface)this.getDamageSources()).virtualAdditions$acid() , 4.0F);
            this.ticksInAcid = Math.min(this.ticksInAcid + 1, 20);
        } else {
            this.ticksInAcid = Math.max(this.ticksInAcid - 1, 0);
        }
    }

    @Inject(method = "updateWaterState", at = @At("RETURN"), cancellable = true)
    void virtualAdditions$updateAcidState(CallbackInfoReturnable<Boolean> cir) {
        boolean bl = this.updateMovementInFluid(VAFluids.ACID_TAG, 0);
        if (bl) cir.setReturnValue(true);
    }

    public boolean virtualAdditions$isInAcid() {
        return !this.firstUpdate && this.fluidHeight.getDouble(VAFluids.ACID_TAG) > 0.0;
    }

    public boolean virtualAdditions$hasUsedMiniPortalThisTick() {
        return this.world.method_8510() == this.lastUsedMiniPortal;
    }

    public void virtualAdditions$setUsedMiniPortal() {
        this.lastUsedMiniPortal = this.world.method_8510();
    }
}
