package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.item.HalberdItem;
import com.github.suninvr.virtualadditions.item.ProjectionSpyglassItem;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_11659;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_759.class)
public class HeldItemRendererMixin {
    @WrapOperation(method = "renderFirstPersonItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/AbstractClientPlayerEntity;isUsingSpyglass()Z"))
    boolean virtualAdditions$isUsingSpectralSpyglass(class_742 instance, Operation<Boolean> original) {
        return original.call(instance) || ProjectionSpyglassItem.isInUseBy(instance);
    }

    @WrapOperation(method = "getHandRenderType", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal = 0))
    private static boolean virtualAdditions$setHalberdRenderType(class_1799 instance, class_1792 item, Operation<Boolean> original) {
        return instance.method_7909() instanceof HalberdItem || original.call(instance, item);
    }

    @WrapOperation(method = "getUsingItemHandRenderType", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal = 0))
    private static boolean virtualAdditions$setUsingHalberdRenderType(class_1799 instance, class_1792 item, Operation<Boolean> original) {
        return instance.method_7909() instanceof HalberdItem || original.call(instance, item);
    }

    @Inject(method = "renderFirstPersonItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/item/HeldItemRenderer;applyEquipOffset(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/util/Arm;F)V", ordinal = 1))
    void virtualAdditions$applyHalberdOffset(class_742 player, float tickProgress, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_11659 orderedRenderCommandQueue, int light, CallbackInfo ci, @Local class_1306 arm) {
        if (player.method_6030().method_7909() instanceof HalberdItem) {
            int l = arm == class_1306.field_6183 ? 1 : -1;
            matrices.method_46416(0, 0.2F, 0);

            float fx = HalberdItem.getSwingReadiness(item, player, item.method_7935(player) - player.method_6048(), tickProgress);
            if (fx > 1.0F) {
                fx = 1.0F;
            }
            float efx = (float) Math.sin(Math.PI * (fx / 2))/2 + 0.5F;
            matrices.method_22907(class_7833.field_40716.rotationDegrees(l * (60 + -40 * efx)));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(l * (-5 * efx)));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(l * -18.05F + l*-60*efx));

            float m = (item.method_7935(player) - (player.method_6014() - tickProgress + 1.0F)) * fx;

            if (fx > 0.1F) {
                float gx = class_3532.method_15374((m - 0.1F) * 1.3F);
                float h = fx - 0.1F;
                float j = gx * h;
                matrices.method_46416(j * 0.0F, j * 0.004F, j * 0.0F);
            }

            matrices.method_22904(-0.3F * efx + 0.2, efx * 2.0F - 1.5F, 0.8F * efx - 0.7F);
            //matrices.scale(1.0F, 1.0F, 1.0F + efx * 0.2F);
        }
    }
}
