package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.block.RedstoneBridgeBlock;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2457.class)
public class RedstoneWireBlockMixin {

    @Inject(method = "connectsTo(Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/Direction;)Z", at = @At("HEAD"), cancellable = true)
    private static void virtualAdditions$connectsToRedstoneBridge(class_2680 state, class_2350 dir, CallbackInfoReturnable<Boolean> cir) {
        if (state.method_27852(VABlocks.REDSTONE_BRIDGE)) {
            class_2350 direction = state.method_11654(RedstoneBridgeBlock.FACING);
            cir.setReturnValue(direction == dir || direction.method_10153() == dir);
        }
    }
}
