package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VADyeColors;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2480.class)
public class ShulkerBoxBlockMixin {
    @Inject(method = "get", at = @At(value = "HEAD"), cancellable = true)
    private static void virtualAdditions$getCustomShulkerBox(class_1767 dyeColor, CallbackInfoReturnable<class_2248> cir) {
        if (dyeColor != null) {
            boolean bl = VirtualAdditions.areBlocksInitialized();
            if (dyeColor.equals(VADyeColors.CHARTREUSE)) cir.setReturnValue(bl ? VABlocks.CHARTREUSE_SHULKER_BOX : class_2246.field_10603);
            if (dyeColor.equals(VADyeColors.MAROON)) cir.setReturnValue(bl ? VABlocks.MAROON_SHULKER_BOX : class_2246.field_10603);
            if (dyeColor.equals(VADyeColors.INDIGO)) cir.setReturnValue(bl ? VABlocks.INDIGO_SHULKER_BOX : class_2246.field_10603);
            if (dyeColor.equals(VADyeColors.PLUM)) cir.setReturnValue(bl ? VABlocks.PLUM_SHULKER_BOX : class_2246.field_10603);
            if (dyeColor.equals(VADyeColors.VIRIDIAN)) cir.setReturnValue(bl ? VABlocks.VIRIDIAN_SHULKER_BOX : class_2246.field_10603);
            if (dyeColor.equals(VADyeColors.TAN)) cir.setReturnValue(bl ? VABlocks.TAN_SHULKER_BOX : class_2246.field_10603);
            if (dyeColor.equals(VADyeColors.SINOPIA)) cir.setReturnValue(bl ? VABlocks.SINOPIA_SHULKER_BOX : class_2246.field_10603);
            if (dyeColor.equals(VADyeColors.LILAC)) cir.setReturnValue(bl ? VABlocks.LILAC_SHULKER_BOX : class_2246.field_10603);
        }
    }
}
