package com.github.suninvr.virtualadditions.registry;

import com.github.suninvr.virtualadditions.worldgen.feature.*;
import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5142;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.registry.*;
import net.minecraft.world.gen.feature.*;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

@SuppressWarnings("SameParameterValue")
public class VAFeatures {
    public static class_3031<class_3111> LUMWASP_NEST_FEATURE;
    public static class_3031<class_3111> BALLOON_BULB_FEATURE;

    public static class Placed {
        public static final class_5321<class_6796> ORE_IOLITE;
        public static final class_5321<class_6796> ORE_PORPHYRY;
        public static final class_5321<class_6796> WASP_DEN_CEILING;
        public static final class_5321<class_6796> WASP_DEN_FLOOR;
        public static final class_5321<class_6796> GREENCAP_MUSHROOM;
        public static final class_5321<class_6796> LUMWASP_NEST;
        public static final class_5321<class_6796> ORE_ROCK_SALT;
        public static final class_5321<class_6796> ORE_ROCK_SALT_OCEANS;
        public static final class_5321<class_6796> ROCK_SALT_CEILING;
        public static final class_5321<class_6796> ROCK_SALT_FLOOR;
        public static final class_5321<class_6796> ORE_CALCITE;
        public static final class_5321<class_6796> ORE_HORNFELS;
        public static final class_5321<class_6796> ORE_BLUESCHIST;
        public static final class_5321<class_6796> ORE_SYENITE;
        public static final class_5321<class_6796> SOULBLOOM_TREES;
        public static final class_5321<class_6796> BONE_LITTER_SOUL_SAND_VALLEY;
        public static final class_5321<class_6796> SPRING_LOTUS_SWAMP;

        static {
            ORE_IOLITE = registerPlaced(idOf("ore_iolite"));
            ORE_PORPHYRY = registerPlaced(idOf("ore_porphyry"));
            WASP_DEN_CEILING = registerPlaced(idOf("wasp_den_ceiling"));
            WASP_DEN_FLOOR = registerPlaced(idOf("wasp_den_floor"));
            GREENCAP_MUSHROOM = registerPlaced(idOf("greencap_mushroom"));
            LUMWASP_NEST = registerPlaced(idOf("lumwasp_nest"));
            ORE_ROCK_SALT = registerPlaced(idOf("ore_rock_salt"));
            ORE_ROCK_SALT_OCEANS = registerPlaced(idOf("ore_rock_salt_oceans"));
            ROCK_SALT_CEILING = registerPlaced(idOf("rock_salt_ceiling"));
            ROCK_SALT_FLOOR = registerPlaced(idOf("rock_salt_floor"));
            ORE_CALCITE = registerPlaced(idOf("ore_calcite"));
            ORE_HORNFELS = registerPlaced(idOf("ore_hornfels"));
            ORE_BLUESCHIST = registerPlaced(idOf("ore_blueschist"));
            ORE_SYENITE = registerPlaced(idOf("ore_syenite"));
            SOULBLOOM_TREES = registerPlaced(idOf("soulbloom_trees"));
            BONE_LITTER_SOUL_SAND_VALLEY = registerPlaced(idOf("bone_litter_soul_sand_valley"));
            SPRING_LOTUS_SWAMP = registerPlaced(idOf("spring_lotus_swamp"));
        }
    }

    public static class Configured {
        public static final class_5321<class_2975<?, ?>> SOULBLOOM_TREE;
        public static final class_5321<class_2975<?, ?>> WITHERED_TREE;
        public static final class_5321<class_2975<?, ?>> NECROTIC_ROOTS_BONEMEAL;

        static {
            SOULBLOOM_TREE = registerConfigured(idOf("soulbloom_tree"));
            WITHERED_TREE = registerConfigured(idOf("withered_tree"));
            NECROTIC_ROOTS_BONEMEAL = registerConfigured(idOf("necrotic_roots_bonemeal"));
        }
    }

    public static void init(){
        BiomeModifications.addFeature(
                BiomeSelectors.foundInTheEnd().and( biomeSelectionContext -> !(biomeSelectionContext.getBiomeKey().equals(class_1972.field_9411)) ),
                class_2893.class_2895.field_13176,
                Placed.ORE_IOLITE
        );
        BiomeModifications.addFeature(
                BiomeSelectors.foundInOverworld(),
                class_2893.class_2895.field_13176,
                Placed.ORE_PORPHYRY
        );
        BiomeModifications.addFeature(
                BiomeSelectors.foundInOverworld(),
                class_2893.class_2895.field_13176,
                Placed.ORE_ROCK_SALT
        );
        BiomeModifications.addFeature(
                BiomeSelectors.foundInOverworld(),
                class_2893.class_2895.field_13176,
                Placed.ORE_HORNFELS
        );
        BiomeModifications.addFeature(
                BiomeSelectors.foundInOverworld(),
                class_2893.class_2895.field_13176,
                Placed.ORE_BLUESCHIST
        );
        BiomeModifications.addFeature(
                BiomeSelectors.foundInOverworld(),
                class_2893.class_2895.field_13176,
                Placed.ORE_SYENITE
        );
        BiomeModifications.addFeature(
                BiomeSelectors.tag(class_6908.field_36509),
                class_2893.class_2895.field_13176,
                Placed.ORE_ROCK_SALT_OCEANS
        );
        BiomeModifications.addFeature(
                BiomeSelectors.includeByKey(class_1972.field_22076),
                class_2893.class_2895.field_13178,
                Placed.BONE_LITTER_SOUL_SAND_VALLEY
        );
        BiomeModifications.addFeature(
                BiomeSelectors.includeByKey(class_1972.field_9471, class_1972.field_38748),
                class_2893.class_2895.field_13178,
                Placed.SPRING_LOTUS_SWAMP
        );
        TrunkPlacerTypes.init();
        BALLOON_BULB_FEATURE = class_2378.method_10230(class_7923.field_41144, idOf("balloon_bulb"), new BalloonBulbFeature(class_3111.field_24893));
        LUMWASP_NEST_FEATURE = class_2378.method_10230(class_7923.field_41144, idOf("lumwasp_nest"), new LumwaspNestFeature(class_3111.field_24893));
    }

    private static class_5321<class_6796> registerPlaced(class_2960 id) {
        return class_5321.method_29179(class_7924.field_41245, id);
    }

    private static class_5321<class_2975<?, ?>> registerConfigured(class_2960 id) {
        return class_5321.method_29179(class_7924.field_41239, id);
    }

    public static class TrunkPlacerTypes {
        public static final class_5142<SoulbloomTrunkPlacer> SOULBLOOM_TRUNK_PLACER = class_2378.method_10230(class_7923.field_41151, idOf("soulbloom_trunk_placer"), new class_5142<>(SoulbloomTrunkPlacer.CODEC));
        public static final class_5142<WitheredTrunkPlacer> WITHERED_TRUNK_PLACER = class_2378.method_10230(class_7923.field_41151, idOf("withered_trunk_placer"), new class_5142<>(WitheredTrunkPlacer.CODEC));
        public static void init(){}
    }

    public static class FoliagePlacerTypes {
        //public static final FoliagePlacerType<WitheredFoliagePlacer> WITHERED_TRUNK_PLACER = Registry.register(Registries.FOLIAGE_PLACER_TYPE, idOf("withered_foliage_placer"), new FoliagePlacerType<>(WitheredFoliagePlacer.CODEC));
        public static void init(){}
    }
}
