package com.github.suninvr.virtualadditions.registry;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_39;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9297;
import net.minecraft.class_9334;
import java.util.Comparator;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

public class VAItemGroups {
    public static final class_5321<class_1761> VIRTUAL_ADDITIONS_KEY = class_5321.method_29179(class_7923.field_44687.method_46765(), idOf("virtual_additions"));
    public static final class_1761 VIRTUAL_ADDITIONS = FabricItemGroup.builder()
            .method_47320(() -> new class_1799(VAItems.IOLITE))
            .method_47321(class_2561.method_30163("Virtual Additions"))
            .method_47324();
    public static final class_5321<class_1761> LOOT_TABLES_KEY = class_5321.method_29179(class_7923.field_44687.method_46765(), idOf("loot_tables"));
    public static final class_1761 LOOT_TABLES = FabricItemGroup.builder()
            .method_47320(() -> new class_1799(class_1802.field_8106))
            .method_47321(class_2561.method_30163("Loot Tables"))
            .method_47324();

    public static void init() {
        if (VirtualAdditions.DEBUG) {
            class_2378.method_39197(class_7923.field_44687, VIRTUAL_ADDITIONS_KEY, VIRTUAL_ADDITIONS);
            populateVirtualAdditionsGroup();
            class_2378.method_39197(class_7923.field_44687, LOOT_TABLES_KEY, LOOT_TABLES);
            populateLootTablesGroup();
        }

    }

    private static void populateLootTablesGroup() {
        ItemGroupEvents.modifyEntriesEvent(LOOT_TABLES_KEY).register(group -> {
            class_39.method_270().stream().sorted(Comparator.comparing(registryKey -> registryKey.method_29177().toString())).forEach(lootTableKey -> {
                class_1799 stack = class_1802.field_8106.method_7854();
                stack.method_57379(class_9334.field_49626, new class_9297(lootTableKey, 0L));
                stack.method_57379(class_9334.field_50239, class_2561.method_30163(lootTableKey.method_29177().toString()));
                group.method_45420(stack);
            });
        });
    }

    private static void populateVirtualAdditionsGroup() {
        ItemGroupEvents.modifyEntriesEvent(VIRTUAL_ADDITIONS_KEY).register(group -> {
            class_7923.field_41178.forEach(item -> {
                if (class_7923.field_41178.method_10221(item).method_12836().equals(VirtualAdditions.NAMESPACE)) {
                    group.method_45420(item.method_7854());
                }
            });
        });
    }
}
