package com.github.suninvr.virtualadditions.registry;

import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import com.github.suninvr.virtualadditions.network.*;
import com.github.suninvr.virtualadditions.screen.EntanglementDriveScreenHandler;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1313;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_8710;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

public class VAPackets {

    public static class_8710.class_9154<EntanglementDriveC2SPayload> ENTANGLEMENT_DRIVE_C2S_ID = new class_8710.class_9154<>(idOf("entanglement_drive_c2s"));
    public static class_8710.class_9154<RemoteNotifierS2CPayload> REMOTE_NOTIFIER_S2C_ID = new class_8710.class_9154<>(idOf("remote_notifier_s2c"));
    public static class_8710.class_9154<ColoringStationS2CPayload> COLORING_STATION_S2C_ID = new class_8710.class_9154<>(idOf("coloring_station_s2c"));
    public static class_8710.class_9154<PlayerProjectionS2CPayload> PLAYER_PROJECTION_S2C_ID = new class_8710.class_9154<>(idOf("player_projection_s2c"));
    public static class_8710.class_9154<PlayerProjectionMovementC2SPayload> PLAYER_PROJECTION_MOVEMENT_C2S_ID = new class_8710.class_9154<>(idOf("player_projection_movement_c2s"));

    static {
        PayloadTypeRegistry.playC2S().register(ENTANGLEMENT_DRIVE_C2S_ID, EntanglementDriveC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ENTANGLEMENT_DRIVE_C2S_ID, (payload, context) -> {
            if (context.player().field_7512 instanceof EntanglementDriveScreenHandler screenHandler) {
                screenHandler.setActiveSlotIndex(payload.getSlotIndex());
                screenHandler.setActivePlayerId(payload.getPlayerId());
                screenHandler.decrementPaymentSlot();
                screenHandler.getEntity().ifPresent( blockEntity -> blockEntity.method_10997().method_8396(null, blockEntity.method_11016(), VASoundEvents.BLOCK_ENTANGLEMENT_DRIVE_USE, class_3419.field_15245, 1.0F, 1.0F));
                VAAdvancementCriteria.USE_ENTANGLEMENT_DRIVE.method_9141(context.player());
            }
        });

        PayloadTypeRegistry.playC2S().register(PLAYER_PROJECTION_MOVEMENT_C2S_ID, PlayerProjectionMovementC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PLAYER_PROJECTION_MOVEMENT_C2S_ID, (payload, context) -> {
            if (context.player().method_51469() != null && context.player().method_51469().method_66347(payload.entityId()) instanceof PlayerProjectionEntity entity) {
                payload.pos().ifPresent(pos -> {
                    double dx = pos.field_1352 - entity.field_6014;
                    double dy = pos.field_1351 - entity.field_6036;
                    double dz = pos.field_1350 - entity.field_5969;
                    entity.method_5784(class_1313.field_6305, new class_243(dx, dy, dz));
                });
                if (payload.pitch().isPresent() && payload.yaw().isPresent()) {
                    entity.method_60608(payload.yaw().get(), payload.pitch().get());
                    entity.field_5982 = entity.field_6283 = entity.field_6241 = entity.method_36454();
                }
            }
        });

        PayloadTypeRegistry.playS2C().register(REMOTE_NOTIFIER_S2C_ID, RemoteNotifierS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(COLORING_STATION_S2C_ID, ColoringStationS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PLAYER_PROJECTION_S2C_ID, PlayerProjectionS2CPayload.CODEC);

    }

    public static void init(){}


}
