package com.github.suninvr.virtualadditions.worldgen.feature;

import com.github.suninvr.virtualadditions.registry.VAFeatures;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class SoulbloomTrunkPlacer extends class_5141 {
    public static final MapCodec<SoulbloomTrunkPlacer> CODEC =
            RecordCodecBuilder.mapCodec(soulbloomTrunkPlacerInstance -> SoulbloomTrunkPlacer.method_28904(soulbloomTrunkPlacerInstance).apply(soulbloomTrunkPlacerInstance, SoulbloomTrunkPlacer::new));


    public SoulbloomTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    @Override
    protected class_5142<?> method_28903() {
        return VAFeatures.TrunkPlacerTypes.SOULBLOOM_TRUNK_PLACER;
    }

    @Override
    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        int lowerTrunkHeight = Math.round(height * ((random.method_43057() * 0.3F) + 0.3F));
        class_2338 dirtPos = startPos.method_10074();
        SoulbloomTrunkPlacer.method_27400(world, replacer, random, dirtPos, config);
        if (lowerTrunkHeight > 0) {
            SoulbloomTrunkPlacer.method_27400(world, replacer, random, dirtPos.method_10095(), config);
            SoulbloomTrunkPlacer.method_27400(world, replacer, random, dirtPos.method_10078(), config);
            SoulbloomTrunkPlacer.method_27400(world, replacer, random, dirtPos.method_10072(), config);
            SoulbloomTrunkPlacer.method_27400(world, replacer, random, dirtPos.method_10067(), config);
        }
        int selectedHeight = 0;
        class_2338 selectedPos = startPos;
        while (selectedHeight < height) {
            selectedPos = startPos.method_10086(selectedHeight);
            this.method_35375(world, replacer, random, selectedPos, config);
            class_2338 finalSelectedPos = selectedPos;
            if (selectedHeight < lowerTrunkHeight) {
                class_2350.method_42013().filter(direction -> direction.method_10166().method_10179()).forEach(direction -> this.method_35375(world, replacer, random, finalSelectedPos.method_10093(direction), config));
            }
            if (selectedHeight == lowerTrunkHeight) {
                class_2350.method_42013().filter(direction -> direction.method_10166().method_10179()).forEach(direction -> {
                    if (random.method_43056()) this.method_35375(world, replacer, random, finalSelectedPos.method_10093(direction), config);
                });
            }
            selectedHeight++;
        }
        return List.of(new class_4647.class_5208(selectedPos, 0, false));
    }
}
