package com.github.suninvr.virtualadditions.worldgen.feature;

import com.github.suninvr.virtualadditions.registry.VAFeatures;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class WitheredTrunkPlacer extends class_5141 {
    public static final MapCodec<WitheredTrunkPlacer> CODEC =
            RecordCodecBuilder.mapCodec(instance -> WitheredTrunkPlacer.method_28904(instance).apply(instance, WitheredTrunkPlacer::new));

    public WitheredTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    @Override
    protected class_5142<?> method_28903() {
        return VAFeatures.TrunkPlacerTypes.WITHERED_TRUNK_PLACER;
    }

    @Override
    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList<class_4647.class_5208> nodes = new ArrayList<>();
        int[][] branches = getBranches(random, height);
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        boolean bl = false;
        for (int i = 0; i < height; ++i) {
            class_2338 pos = startPos.method_10086(i);
            this.method_35375(world, replacer, random, pos, config);
            for (int[] branch : branches) {
                if (branch[0] == i) {
                    class_4647.class_5208 node = placeBranch(world, replacer, random, pos, branch, direction, config);
                    if (node != null) {
                        nodes.add(node);
                    }
                    direction = direction.method_10170();
                    if (!bl && random.method_43048(2) == 1) {
                        direction = direction.method_10170();
                        bl = true;
                    }
                }
            }
        }
        nodes.add(new class_4647.class_5208(startPos.method_10086(height), 1, false));
        return List.copyOf(nodes);
    }

    private class_4647.class_5208 placeBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 branchPos, int[] branch, class_2350 direction, class_4643 config) {

        this.method_27402(world, replacer, random, branchPos.method_10093(direction), config, state -> state.method_11657(class_2741.field_12496, direction.method_10166()));
        for (int i = 0; i < branch[1]; i++) {
            this.method_35375(world, replacer, random, branchPos.method_10079(direction, 2).method_10086(i+1), config);
        }
        return new class_4647.class_5208(branchPos.method_10079(direction, 2).method_10086(1 + branch[1]), 1, false);
    }

    private int[][] getBranches(class_5819 random, int height) {
        ArrayList<int[]> branches = new ArrayList<>();
        branches.add(getRandomBranchHeight(random, height));
        branches.add(getRandomBranchHeight(random, height));
        if (random.method_43048(2) == 1) branches.add(getRandomBranchHeight(random, height));
        return branches.toArray(new int[][]{});
    }

    private int[] getRandomBranchHeight(class_5819 random, int height) {
        int min = height / 4;
        int max = height - min;
        if (max < min) return new int[]{-1};
        return new int[]{random.method_43048(max) + min, random.method_43048(2) + 1};
    }
}
