/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VAItems;
import com.mojang.serialization.MapCodec;
import java.util.Locale;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CornCropBlock
extends class_2302 {
    public static final MapCodec<CornCropBlock> CODEC = CornCropBlock.method_54094(CornCropBlock::new);
    public static final class_2754<Segment> SEGMENT = class_2754.method_11850((String)"segment", Segment.class);
    private static final class_265 SHAPE_AGE_1 = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    private static final class_265 SHAPE_AGE_2 = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final class_265 SHAPE_AGE_3 = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public CornCropBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(SEGMENT, (Comparable)((Object)Segment.BOTTOM)));
    }

    public MapCodec<? extends class_2302> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SEGMENT});
        super.method_9515(builder);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_243 offset = state.method_26226(pos);
        return ((Segment)((Object)state.method_11654(SEGMENT))).getShape((Integer)state.method_11654((class_2769)field_10835)).method_1096(offset.field_1352, offset.field_1351, offset.field_1350);
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184((class_4538)world, pos)) {
            world.method_22352(pos, true);
        }
        super.method_9588(state, world, pos, random);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        tickView.method_64310(pos, (class_2248)this, 1);
        return state;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        float f;
        int i;
        if (world.method_22335(pos, 0) >= 9 && (i = this.method_9829(state)) < this.method_9827() && random.method_43048((int)(25.0f / (f = CornCropBlock.method_9830((class_2248)this, (class_1922)world, (class_2338)pos))) + 1) == 0) {
            this.grow((class_1937)world, state, pos);
        }
    }

    protected class_1935 method_9832() {
        return VAItems.CORN_SEEDS;
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return this.isSpaceToGrow(world, state, pos) && super.method_9651(world, pos, state);
    }

    public void method_9826(class_1937 world, class_2338 pos, class_2680 state) {
        int i = Math.min(this.method_9829(state) + this.method_9831(world), this.getMaxAgeForSpace(world, pos, state));
        this.setAge(world, state, pos, i);
    }

    private int getMaxAgeForSpace(class_1937 world, class_2338 pos, class_2680 state) {
        if (!state.method_27852(VABlocks.CORN_CROP)) {
            return 0;
        }
        Segment segment = (Segment)((Object)state.method_11654(SEGMENT));
        if (!segment.equals((Object)Segment.BOTTOM)) {
            class_2338 offsetPos = pos.method_10086(segment.getYOffset(Segment.BOTTOM));
            return this.getMaxAgeForSpace(world, offsetPos, world.method_8320(offsetPos));
        }
        if (this.canReplaceBlockState(world, pos.method_10084().method_10084())) {
            return 7;
        }
        if (this.canReplaceBlockState(world, pos.method_10084())) {
            return 5;
        }
        return 2;
    }

    private void grow(class_1937 world, class_2680 state, class_2338 pos) {
        if (!state.method_27852((class_2248)this)) {
            return;
        }
        int age = (Integer)state.method_11654((class_2769)field_10835) + 1;
        this.setAge(world, state, pos, age);
    }

    private boolean isSpaceToGrow(class_4538 world, class_2680 state, class_2338 pos) {
        boolean bl = true;
        int age = (Integer)state.method_11654((class_2769)field_10835);
        Segment segment = (Segment)((Object)state.method_11654(SEGMENT));
        if (segment.equals((Object)Segment.BOTTOM) && age >= 2) {
            bl = this.checkForState(world, pos, state, Segment.MIDDLE, true);
        }
        if (!segment.equals((Object)Segment.TOP) && age >= 5) {
            bl = bl && this.checkForState(world, pos, state, Segment.TOP, true);
        }
        return bl;
    }

    private void setAge(class_1937 world, class_2680 state, class_2338 pos, int age) {
        boolean growMiddle = age > 2;
        boolean growTop = age > 5;
        switch (((Segment)((Object)state.method_11654(SEGMENT))).ordinal()) {
            case 2: {
                boolean canGrow = true;
                if (growMiddle) {
                    canGrow = this.canReplaceBlockState(world, pos.method_10084());
                }
                if (growTop) {
                    boolean bl = canGrow = canGrow && this.canReplaceBlockState(world, pos.method_10086(2));
                }
                if (!canGrow) break;
                world.method_8652(pos, this.bottomSegment(age), 2);
                if (growMiddle) {
                    world.method_8652(pos.method_10084(), this.middleSegment(age), 2);
                }
                if (!growTop) break;
                world.method_8652(pos.method_10086(2), this.topSegment(age), 2);
                break;
            }
            case 1: {
                boolean canGrow = true;
                if (growTop) {
                    canGrow = this.canReplaceBlockState(world, pos.method_10084());
                }
                if (!canGrow) break;
                world.method_8652(pos.method_10074(), this.bottomSegment(age), 2);
                world.method_8652(pos, this.middleSegment(age), 2);
                if (!growTop) break;
                world.method_8652(pos.method_10084(), this.topSegment(age), 2);
                break;
            }
            case 0: {
                world.method_8652(pos.method_10087(2), this.bottomSegment(age), 2);
                world.method_8652(pos.method_10074(), this.middleSegment(age), 2);
                world.method_8652(pos, this.topSegment(age), 2);
            }
        }
    }

    private boolean checkForState(class_4538 world, class_2338 pos, class_2680 state, Segment checkSegment, boolean allowAir) {
        Segment segment = (Segment)((Object)state.method_11654(SEGMENT));
        int offset = segment.getYOffset(checkSegment);
        class_2680 checkState = world.method_8320(pos.method_10079(class_2350.field_11036, offset));
        if (checkState.method_27852(VABlocks.CORN_CROP)) {
            return ((Segment)((Object)checkState.method_11654(SEGMENT))).equals((Object)checkSegment) && ((Integer)checkState.method_11654((class_2769)field_10835)).equals(state.method_11654((class_2769)field_10835));
        }
        return allowAir && world.method_8320(pos.method_10079(class_2350.field_11036, offset)).method_26215();
    }

    public class_2680 topSegment(int age) {
        return this.stateOf(age, Segment.TOP);
    }

    public class_2680 middleSegment(int age) {
        return this.stateOf(age, Segment.MIDDLE);
    }

    public class_2680 bottomSegment(int age) {
        return this.stateOf(age, Segment.BOTTOM);
    }

    public class_2680 stateOf(int age, Segment segment) {
        return (class_2680)this.method_9828(age).method_11657(SEGMENT, (Comparable)((Object)segment));
    }

    private boolean canReplaceBlockState(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26215() || state.method_27852(VABlocks.SPOTLIGHT_LIGHT) || state.method_27852((class_2248)this);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return switch (((Segment)((Object)state.method_11654(SEGMENT))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.checkSegment(world, pos, state, class_2350.field_11033);
            case 1 -> {
                if (this.checkSegment(world, pos, state, class_2350.field_11033) && ((Integer)state.method_11654((class_2769)field_10835) <= 5 || this.checkSegment(world, pos, state, class_2350.field_11036))) {
                    yield true;
                }
                yield false;
            }
            case 2 -> !(world.method_22335(pos, 0) < 8 && !world.method_8311(pos) || !super.method_9558(state, world, pos) || (Integer)state.method_11654((class_2769)field_10835) > 2 && !this.checkSegment(world, pos, state, class_2350.field_11036));
        };
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(SEGMENT, (Comparable)((Object)Segment.BOTTOM));
    }

    private boolean checkSegment(class_4538 world, class_2338 pos, class_2680 state, class_2350 direction) {
        Segment expectedSegment;
        Segment segment = (Segment)((Object)state.method_11654(SEGMENT));
        Segment segment2 = expectedSegment = direction.equals((Object)class_2350.field_11036) ? segment.aboveSegment() : segment.belowSegment();
        if (expectedSegment == null) {
            return false;
        }
        class_2680 offsetState = world.method_8320(pos.method_10093(direction));
        return offsetState.method_27852((class_2248)this) && ((Segment)((Object)offsetState.method_11654(SEGMENT))).equals((Object)expectedSegment) && ((Integer)offsetState.method_11654((class_2769)field_10835)).equals(state.method_11654((class_2769)field_10835));
    }

    public static enum Segment implements class_3542
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public class_265 getShape(int age) {
            if ((age -= this.minAge()) < 1) {
                return SHAPE_AGE_1;
            }
            if (age > 1) {
                return SHAPE_AGE_3;
            }
            return SHAPE_AGE_2;
        }

        @Nullable
        public Segment aboveSegment() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> null;
                case 1 -> TOP;
                case 2 -> MIDDLE;
            };
        }

        @Nullable
        public Segment belowSegment() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> MIDDLE;
                case 1 -> BOTTOM;
                case 2 -> null;
            };
        }

        public int getYOffset(Segment expectedSegment) {
            return this.ordinal() - expectedSegment.ordinal();
        }

        public int minAge() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 6;
                case 1 -> 3;
                case 2 -> 0;
            };
        }
    }
}

