/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.enums.CrystalShape;
import com.github.suninvr.virtualadditions.registry.VABlockTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class CrystalBlock
extends class_2248
implements class_3737 {
    public static final MapCodec<CrystalBlock> CODEC = CrystalBlock.method_54094(CrystalBlock::new);
    public static final class_2754<CrystalShape> SHAPE = class_2754.method_11850((String)"shape", CrystalShape.class);
    public static final class_2754<class_2350> POINTING = class_2741.field_12525;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_265 BODY_Y_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final class_265 TIP_DOWN_SHAPE = class_2248.method_9541((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final class_265 TIP_UP_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0);
    public static final class_265 BODY_X_SHAPE = class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final class_265 TIP_EAST_SHAPE = class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0);
    public static final class_265 TIP_WEST_SHAPE = class_2248.method_9541((double)7.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final class_265 BODY_Z_SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    public static final class_265 TIP_NORTH_SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)7.0, (double)12.0, (double)12.0, (double)16.0);
    public static final class_265 TIP_SOUTH_SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)9.0);

    public CrystalBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(SHAPE, (Comparable)((Object)CrystalShape.TIP))).method_11657(POINTING, (Comparable)class_2350.field_11036)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends class_2248> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHAPE}).method_11667(new class_2769[]{POINTING}).method_11667(new class_2769[]{WATERLOGGED});
    }

    public void onLandedUpon(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (state.method_11654(POINTING) == class_2350.field_11036 && state.method_11654(SHAPE) == CrystalShape.TIP) {
            entity.method_5747((double)(fallDistance + 2.0f), 2.0f, world.method_48963().method_48837());
        } else {
            super.method_9554(world, state, pos, entity, (double)fallDistance);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350[] directions;
        for (class_2350 direction : directions = ctx.method_7718()) {
            class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657(POINTING, (Comparable)direction.method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
            if (!this.method_9558(state, (class_4538)ctx.method_8045(), ctx.method_8037())) continue;
            return state;
        }
        return null;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654(POINTING);
        return this.canPlaceOn(world, new class_2338((class_2382)pos.method_10093(direction.method_10153())), direction);
    }

    public boolean canPlaceOn(class_4538 world, class_2338 pos, class_2350 direction) {
        return class_2248.method_20044((class_4538)world, (class_2338)pos, (class_2350)direction) || world.method_8320(pos).method_26164(VABlockTags.CRYSTALS) && world.method_8320(pos).method_11654(POINTING) == direction;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_22352(pos, true);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        class_2350 pointing;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (!this.canPlaceOn((class_4538)world, new class_2338((class_2382)pos.method_10093((pointing = (class_2350)state.method_11654(POINTING)).method_10153())), pointing)) {
            world.method_64310(pos, (class_2248)this, 1);
        }
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        class_2350 pointing = (class_2350)state.method_11654(POINTING);
        if (direction == pointing) {
            class_2680 fromState = world.method_8320(new class_2338((class_2382)pos.method_10093(direction)));
            if (fromState.method_26164(VABlockTags.CRYSTALS) && fromState.method_11654(POINTING) == direction) {
                return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)CrystalShape.BODY));
            }
            return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)CrystalShape.TIP));
        }
        return state;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        boolean isBody = state.method_11654(SHAPE) == CrystalShape.BODY;
        class_243 vec3d = state.method_26226(pos);
        return switch ((class_2350)state.method_11654(POINTING)) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036 -> {
                if (isBody) {
                    yield BODY_Y_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                }
                yield TIP_UP_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            }
            case class_2350.field_11033 -> {
                if (isBody) {
                    yield BODY_Y_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                }
                yield TIP_DOWN_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            }
            case class_2350.field_11043 -> {
                if (isBody) {
                    yield BODY_Z_SHAPE;
                }
                yield TIP_NORTH_SHAPE;
            }
            case class_2350.field_11035 -> {
                if (isBody) {
                    yield BODY_Z_SHAPE;
                }
                yield TIP_SOUTH_SHAPE;
            }
            case class_2350.field_11034 -> {
                if (isBody) {
                    yield BODY_X_SHAPE;
                }
                yield TIP_EAST_SHAPE;
            }
            case class_2350.field_11039 -> isBody ? BODY_X_SHAPE : TIP_WEST_SHAPE;
        };
    }
}

