/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.SpotlightLightBlock;
import com.github.suninvr.virtualadditions.block.entity.SpotlightBlockEntity;
import com.github.suninvr.virtualadditions.block.enums.LightStatus;
import com.github.suninvr.virtualadditions.registry.VABlockTags;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import net.minecraft.class_5000;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class SpotlightBlock
extends class_2237 {
    public static final MapCodec<SpotlightBlock> CODEC = SpotlightBlock.method_54094(SpotlightBlock::new);
    public static final class_2754<class_5000> ORIENTATION = class_2741.field_23333;
    public static final class_2746 POWERED = class_2741.field_12484;

    public SpotlightBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(ORIENTATION, (Comparable)class_5000.field_23390)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ORIENTATION}).method_11667(new class_2769[]{POWERED});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (state.method_27852((class_2248)this) && ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            SpotlightBlock.updateLightLocation(world, pos, state);
        }
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        SpotlightBlock.updateLightLocation((class_1937)world, pos, state);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        boolean redstonePower = world.method_49803(pos);
        boolean isPowered = (Boolean)state.method_11654((class_2769)POWERED);
        if (redstonePower && !isPowered) {
            SpotlightBlock.updateLightLocation(world, pos, state);
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)));
            SpotlightBlock.setLightState(world, pos, LightStatus.LIT);
        } else if (!redstonePower && isPowered) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
            SpotlightBlock.setLightState(world, pos, LightStatus.UNLIT);
        }
    }

    public static void updateLightLocation(class_1937 world, class_2338 pos, class_2680 state) {
        class_2680 lightState;
        boolean isWater;
        SpotlightBlockEntity spotlightBlockEntity;
        SpotlightBlockEntity blockEntity;
        if (world.method_8608()) {
            return;
        }
        if (!state.method_27852(VABlocks.SPOTLIGHT)) {
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        SpotlightBlockEntity spotlightBlockEntity2 = blockEntity = class_25862 instanceof SpotlightBlockEntity ? (spotlightBlockEntity = (SpotlightBlockEntity)class_25862) : null;
        if (blockEntity == null) {
            return;
        }
        class_2350 direction = ((class_5000)state.method_11654(ORIENTATION)).method_26426();
        class_2338 newLightPos = SpotlightBlock.findLightLocation(world, pos, direction);
        class_2338 oldLightPos = blockEntity.getLightLocation();
        class_2680 newLightState = world.method_8320(newLightPos);
        class_2680 oldLightState = world.method_8320(oldLightPos);
        boolean bl = isWater = newLightState.method_27852(class_2246.field_10382) && world.method_8316(newLightPos).method_33659((class_3611)class_3612.field_15910);
        if (newLightState.method_27852(VABlocks.SPOTLIGHT_LIGHT) || newLightState.method_26215() || isWater) {
            lightState = SpotlightBlock.getLightState(world, pos, newLightState.method_27852(VABlocks.SPOTLIGHT_LIGHT) ? newLightState : (class_2680)VABlocks.SPOTLIGHT_LIGHT.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(isWater)));
            world.method_8501(newLightPos, lightState);
            blockEntity.setLightLocation(newLightPos);
        }
        if (!oldLightPos.equals((Object)newLightPos) && oldLightState.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            lightState = SpotlightBlock.getLightState(state, oldLightState, LightStatus.NONE);
            world.method_8501(oldLightPos, lightState);
        }
    }

    private static class_2338 findLightLocation(class_1937 world, class_2338 startPos, class_2350 direction) {
        class_2338 pos = new class_2338((class_2382)startPos.method_10093(direction));
        if (!world.method_22347(pos) && !world.method_8320(pos).method_26164(VABlockTags.SPOTLIGHT_PERMEABLE)) {
            return pos;
        }
        class_2338 finalPos = pos;
        class_2338 offsetPos = new class_2338((class_2382)pos.method_10093(direction));
        class_2680 offsetState = world.method_8320(offsetPos);
        for (int i = 0; (world.method_22347(offsetPos) || offsetState.method_27852(VABlocks.SPOTLIGHT_LIGHT) || offsetState.method_26164(VABlockTags.SPOTLIGHT_PERMEABLE)) && i < 31; ++i) {
            pos = new class_2338((class_2382)pos.method_10093(direction));
            offsetPos = new class_2338((class_2382)pos.method_10093(direction));
            offsetState = world.method_8320(offsetPos);
            if (!world.method_22347(pos) && !world.method_8320(pos).method_27852(class_2246.field_10382) && !world.method_8320(pos).method_27852(VABlocks.SPOTLIGHT_LIGHT)) continue;
            finalPos = pos;
        }
        return finalPos;
    }

    public static void setLightState(class_1937 world, class_2338 pos, LightStatus status) {
        SpotlightBlock.setLightState(world, pos, world.method_8320(pos), status);
    }

    public static void setLightState(class_1937 world, class_2338 pos, class_2680 state, LightStatus status) {
        if (!state.method_27852(VABlocks.SPOTLIGHT)) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (!world.method_8608() && blockEntity instanceof SpotlightBlockEntity) {
            SpotlightBlockEntity spotlightBlockEntity = (SpotlightBlockEntity)blockEntity;
            class_2338 lightPos = spotlightBlockEntity.getLightLocation();
            SpotlightBlock.setLightState(world, state, lightPos, world.method_8320(lightPos), status);
        }
    }

    public static void setLightState(class_1937 world, class_2680 state, class_2338 lightPos, class_2680 lightState, LightStatus status) {
        if (!state.method_27852(VABlocks.SPOTLIGHT)) {
            return;
        }
        class_2680 updatedLightState = SpotlightBlock.getLightState(state, lightState, status);
        world.method_8501(lightPos, updatedLightState);
    }

    public static class_2680 getLightState(class_1937 world, class_2338 pos, class_2680 lightState) {
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852(VABlocks.SPOTLIGHT)) {
            return lightState;
        }
        LightStatus status = (Boolean)state.method_11654((class_2769)POWERED) != false ? LightStatus.LIT : LightStatus.UNLIT;
        return SpotlightBlock.getLightState(state, lightState, status);
    }

    public static class_2680 getLightState(class_2680 state, class_2680 lightState, LightStatus status) {
        if (!lightState.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            return lightState;
        }
        if (!state.method_27852(VABlocks.SPOTLIGHT)) {
            return lightState;
        }
        class_2350 direction = ((class_5000)state.method_11654(ORIENTATION)).method_26426().method_10153();
        return SpotlightLightBlock.getUpdatedLightState((class_2680)lightState.method_11657(SpotlightLightBlock.getDirectionProperty(direction), (Comparable)((Object)status)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpotlightBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2350 facingDirection = ctx.method_7715();
        class_2350 rotationDirection = switch (facingDirection) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> ctx.method_8042();
            case class_2350.field_11036 -> ctx.method_8042().method_10153();
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> class_2350.field_11036;
        };
        return (class_2680)((class_2680)this.method_9564().method_11657(ORIENTATION, (Comparable)class_5000.method_26425((class_2350)facingDirection, (class_2350)rotationDirection))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(world.method_49803(pos)));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(ORIENTATION, (Comparable)rotation.method_26383().method_26389((class_5000)state.method_11654(ORIENTATION)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657(ORIENTATION, (Comparable)mirror.method_26380().method_26389((class_5000)state.method_11654(ORIENTATION)));
    }
}

