/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.entity.SpotlightBlockEntity;
import com.github.suninvr.virtualadditions.block.entity.SpotlightLightBlockEntity;
import com.github.suninvr.virtualadditions.block.enums.LightStatus;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SpotlightLightBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<SpotlightLightBlock> CODEC = SpotlightLightBlock.method_54094(SpotlightLightBlock::new);
    public static class_2746 WATERLOGGED = class_2741.field_12508;
    public static class_2746 LIT = class_2741.field_12548;
    public static class_2754<LightStatus> NORTH = class_2754.method_11850((String)"north", LightStatus.class);
    public static class_2754<LightStatus> EAST = class_2754.method_11850((String)"east", LightStatus.class);
    public static class_2754<LightStatus> SOUTH = class_2754.method_11850((String)"south", LightStatus.class);
    public static class_2754<LightStatus> WEST = class_2754.method_11850((String)"west", LightStatus.class);
    public static class_2754<LightStatus> UP = class_2754.method_11850((String)"up", LightStatus.class);
    public static class_2754<LightStatus> DOWN = class_2754.method_11850((String)"down", LightStatus.class);

    public SpotlightLightBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657(NORTH, (Comparable)((Object)LightStatus.NONE))).method_11657(EAST, (Comparable)((Object)LightStatus.NONE))).method_11657(SOUTH, (Comparable)((Object)LightStatus.NONE))).method_11657(WEST, (Comparable)((Object)LightStatus.NONE))).method_11657(UP, (Comparable)((Object)LightStatus.NONE))).method_11657(DOWN, (Comparable)((Object)LightStatus.NONE)));
    }

    public static void updateSources(class_1936 world, class_2338 pos, class_2680 state) {
        if (!state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            return;
        }
        SpotlightLightBlock.getSources(world, pos, state).forEach(pos2 -> world.method_64310(pos2, VABlocks.SPOTLIGHT, 1));
    }

    public static List<class_2338> getSources(class_1936 world, class_2338 pos, class_2680 state) {
        ArrayList<class_2338> posList = new ArrayList<class_2338>();
        for (class_2350 dir : class_2350.values()) {
            if (!((LightStatus)((Object)state.method_11654(SpotlightLightBlock.getDirectionProperty(dir)))).hasLight()) continue;
            posList.add(SpotlightLightBlock.findSource(world, pos, dir));
        }
        return posList;
    }

    protected static class_2338 findSource(class_1936 world, class_2338 pos, class_2350 dir) {
        int i = 0;
        class_2338 blockPos = class_2338.field_10980;
        while (i < 33) {
            SpotlightBlockEntity spotlightBlockEntity;
            class_2586 class_25862;
            if (!((class_25862 = world.method_8321(blockPos = pos.method_10079(dir, ++i))) instanceof SpotlightBlockEntity) || !(spotlightBlockEntity = (SpotlightBlockEntity)class_25862).getLightLocation().equals((Object)pos)) continue;
            return blockPos;
        }
        return blockPos;
    }

    protected static class_2754<LightStatus> getDirectionProperty(class_2350 dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> DOWN;
            case class_2350.field_11036 -> UP;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
        };
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    protected boolean method_9579(class_2680 state) {
        return true;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    @Nullable
    public static LightStatus getStatus(class_2680 state, class_2350 direction) {
        if (state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11043 -> (LightStatus)((Object)state.method_11654(NORTH));
                case class_2350.field_11034 -> (LightStatus)((Object)state.method_11654(EAST));
                case class_2350.field_11035 -> (LightStatus)((Object)state.method_11654(SOUTH));
                case class_2350.field_11039 -> (LightStatus)((Object)state.method_11654(WEST));
                case class_2350.field_11036 -> (LightStatus)((Object)state.method_11654(UP));
                case class_2350.field_11033 -> (LightStatus)((Object)state.method_11654(DOWN));
            };
        }
        return null;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        LightStatus north = SpotlightLightBlock.getStatus(state, rotation.method_10503(class_2350.field_11035));
        LightStatus east = SpotlightLightBlock.getStatus(state, rotation.method_10503(class_2350.field_11039));
        LightStatus south = SpotlightLightBlock.getStatus(state, rotation.method_10503(class_2350.field_11043));
        LightStatus west = SpotlightLightBlock.getStatus(state, rotation.method_10503(class_2350.field_11034));
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)north))).method_11657(EAST, (Comparable)((Object)east))).method_11657(SOUTH, (Comparable)((Object)south))).method_11657(WEST, (Comparable)((Object)west));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        LightStatus north = SpotlightLightBlock.getStatus(state, mirror.method_10345(class_2350.field_11043).method_10503(class_2350.field_11043));
        LightStatus east = SpotlightLightBlock.getStatus(state, mirror.method_10345(class_2350.field_11034).method_10503(class_2350.field_11034));
        LightStatus south = SpotlightLightBlock.getStatus(state, mirror.method_10345(class_2350.field_11035).method_10503(class_2350.field_11035));
        LightStatus west = SpotlightLightBlock.getStatus(state, mirror.method_10345(class_2350.field_11039).method_10503(class_2350.field_11039));
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)north))).method_11657(EAST, (Comparable)((Object)east))).method_11657(SOUTH, (Comparable)((Object)south))).method_11657(WEST, (Comparable)((Object)west));
    }

    public static boolean isLit(class_2680 state) {
        if (state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            for (class_2350 direction : class_2350.values()) {
                LightStatus status = SpotlightLightBlock.getStatus(state, direction);
                if (status != LightStatus.LIT) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldRemove(class_2680 state) {
        if (state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            for (class_2350 direction : class_2350.values()) {
                LightStatus status = SpotlightLightBlock.getStatus(state, direction);
                if (status == LightStatus.NONE) continue;
                return false;
            }
        }
        return true;
    }

    public static class_2680 getUpdatedLightState(class_2680 state) {
        if (!state.method_27852(VABlocks.SPOTLIGHT_LIGHT)) {
            return state;
        }
        if (SpotlightLightBlock.shouldRemove(state)) {
            return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
        }
        return (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(SpotlightLightBlock.isLit(state)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED}).method_11667(new class_2769[]{LIT}).method_11667(new class_2769[]{NORTH}).method_11667(new class_2769[]{EAST}).method_11667(new class_2769[]{SOUTH}).method_11667(new class_2769[]{WEST}).method_11667(new class_2769[]{UP}).method_11667(new class_2769[]{DOWN});
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(SpotlightLightBlock.isLit(state)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpotlightLightBlockEntity(pos, state);
    }
}

