/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.block.entity;

import com.github.suninvr.virtualadditions.registry.VADyeColors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_3913;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class DyeContents {
    public static final class_9139<class_9129, DyeContents> PACKET_CODEC = new class_9139<class_9129, DyeContents>(){

        public DyeContents decode(class_9129 buf) {
            return new DyeContents(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
        }

        public void encode(class_9129 buf, DyeContents contents) {
            buf.method_53002(contents.getR());
            buf.method_53002(contents.getG());
            buf.method_53002(contents.getB());
            buf.method_53002(contents.getY());
            buf.method_53002(contents.getK());
            buf.method_53002(contents.getW());
        }
    };
    private int r;
    private int g;
    private int b;
    private int y;
    private int k;
    private int w;

    public DyeContents() {
        this(0, 0, 0, 0, 0, 0);
    }

    public DyeContents(int r, int g, int b, int y, int k, int w) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
        this.setY(y);
        this.setK(k);
        this.setW(w);
    }

    public DyeContents(class_3913 propertyDelegate) {
        this(propertyDelegate.method_17390(0), propertyDelegate.method_17390(1), propertyDelegate.method_17390(2), propertyDelegate.method_17390(3), propertyDelegate.method_17390(4), propertyDelegate.method_17390(5));
    }

    public static DyeContents from(class_11368 view) {
        Optional contents = view.method_71442("dye_contents");
        return contents.map(ints -> new DyeContents(((int[])ints).length > 0 ? ints[0] : 0, ((int[])ints).length > 1 ? ints[1] : 0, ((int[])ints).length > 2 ? ints[2] : 0, ((int[])ints).length > 3 ? ints[3] : 0, ((int[])ints).length > 4 ? ints[4] : 0, ((int[])ints).length > 5 ? ints[5] : 0)).orElseGet(DyeContents::new);
    }

    public static DyeContents from(class_2540 buf) {
        return new DyeContents(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static DyeContents empty() {
        return new DyeContents(0, 0, 0, 0, 0, 0);
    }

    public void to(class_11372 view) {
        view.method_71473("dye_contents", this.asIntArray());
    }

    public void to(class_2540 buf) {
        buf.method_53002(this.getR());
        buf.method_53002(this.getG());
        buf.method_53002(this.getB());
        buf.method_53002(this.getY());
        buf.method_53002(this.getK());
        buf.method_53002(this.getW());
    }

    public void set(int r, int g, int b, int y, int k, int w) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
        this.setY(y);
        this.setK(k);
        this.setW(w);
    }

    public DyeContents add(DyeContents contents) {
        this.setR(this.getR() + contents.getR());
        this.setG(this.getG() + contents.getG());
        this.setB(this.getB() + contents.getB());
        this.setY(this.getY() + contents.getY());
        this.setK(this.getK() + contents.getK());
        this.setW(this.getW() + contents.getW());
        return this;
    }

    public int[] asIntArray() {
        return new int[]{this.getR(), this.getG(), this.getB(), this.getY(), this.getK(), this.getW()};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DyeContents contents = (DyeContents)o;
        return this.r == contents.r && this.g == contents.g && this.b == contents.b && this.y == contents.y && this.k == contents.k && this.w == contents.w;
    }

    public int hashCode() {
        return Objects.hash(this.r, this.g, this.b, this.y, this.k, this.w);
    }

    public boolean canAdd(DyeContents contents) {
        int[] thisContents = this.asIntArray();
        int[] thatContents = contents.asIntArray();
        for (int i = 0; i <= 5; ++i) {
            int c = thisContents[i] + thatContents[i];
            if (0 <= c && c <= 8192) continue;
            return false;
        }
        return true;
    }

    public void multiply(int x) {
        this.setR(this.getR() * x);
        this.setG(this.getG() * x);
        this.setB(this.getB() * x);
        this.setY(this.getY() * x);
        this.setK(this.getK() * x);
        this.setW(this.getW() * x);
    }

    public int getR() {
        return this.r;
    }

    public void setR(int r) {
        this.r = r;
    }

    public int getG() {
        return this.g;
    }

    public void setG(int g) {
        this.g = g;
    }

    public int getB() {
        return this.b;
    }

    public void setB(int b) {
        this.b = b;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public List<class_1799> getDyeStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int[] ints = this.asIntArray();
        int i = 0;
        for (int j : ints) {
            for (int c = Math.floorDiv(j, 32); c > 0; c -= 64) {
                stacks.add(new class_1799((class_1935)DyeContents.getDyeFromIndex(i), Math.min(c, 64)));
            }
            ++i;
        }
        return stacks;
    }

    private static class_1792 getDyeFromIndex(int index) {
        return switch (index) {
            case 0 -> class_1802.field_8264;
            case 1 -> class_1802.field_8408;
            case 2 -> class_1802.field_8345;
            case 3 -> class_1802.field_8192;
            case 4 -> class_1802.field_8226;
            case 5 -> class_1802.field_8446;
            default -> throw new IllegalStateException("Unexpected value: " + index);
        };
    }

    public DyeContents copy() {
        return new DyeContents(this.getR(), this.getG(), this.getB(), this.getY(), this.getK(), this.getW());
    }

    public DyeContents copyAndMultiply(int x) {
        DyeContents contents = this.copy();
        contents.multiply(x);
        return contents;
    }

    public void addDye(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            DyeContents contents = VADyeColors.getContents(dyeItem, 8);
            while (!itemStack.method_7960() && this.canAdd(contents)) {
                this.add(contents);
                itemStack.method_7934(1);
            }
        }
    }
}

