/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.client.render.block;

import com.github.suninvr.virtualadditions.block.entity.MiniPortalBlockEntity;
import com.github.suninvr.virtualadditions.client.VARenderLayers;
import com.github.suninvr.virtualadditions.client.render.block.MiniPortalBlockEntityRenderState;
import java.util.Optional;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class MiniPortalBlockEntityRenderer
implements class_827<MiniPortalBlockEntity, MiniPortalBlockEntityRenderState> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"virtual_additions", (String)"textures/entity/mini_portal/open.png");
    private static final class_2960 TEXTURE_BLOCKED = class_2960.method_60655((String)"virtual_additions", (String)"textures/entity/mini_portal/blocked.png");
    private static final class_2960 TEXTURE_GLOW = class_2960.method_60655((String)"virtual_additions", (String)"textures/entity/mini_portal/open_glow.png");
    private static final class_2960 TEXTURE_BLOCKED_GLOW = class_2960.method_60655((String)"virtual_additions", (String)"textures/entity/mini_portal/blocked_glow.png");
    private static final class_2960 TEXTURE_DYED = class_2960.method_60655((String)"virtual_additions", (String)"textures/entity/mini_portal/dyed_open.png");
    private static final class_2960 TEXTURE_DYED_BLOCKED = class_2960.method_60655((String)"virtual_additions", (String)"textures/entity/mini_portal/dyed_blocked.png");
    private static final class_2960 TEXTURE_DYED_GLOW = class_2960.method_60655((String)"virtual_additions", (String)"textures/entity/mini_portal/dyed_open_glow.png");
    private static final class_2960 TEXTURE_DYED_BLOCKED_GLOW = class_2960.method_60655((String)"virtual_additions", (String)"textures/entity/mini_portal/dyed_blocked_glow.png");
    private static final class_1921 LAYER = VARenderLayers.getMiniPortal(TEXTURE, false);
    private static final class_1921 LAYER_BLOCKED = VARenderLayers.getMiniPortal(TEXTURE_BLOCKED, false);
    private static final class_1921 LAYER_GLOW = VARenderLayers.getMiniPortal(TEXTURE_GLOW, true);
    private static final class_1921 LAYER_BLOCKED_GLOW = VARenderLayers.getMiniPortal(TEXTURE_BLOCKED_GLOW, true);
    private static final class_1921 LAYER_DYED = VARenderLayers.getMiniPortal(TEXTURE_DYED, false);
    private static final class_1921 LAYER_DYED_BLOCKED = VARenderLayers.getMiniPortal(TEXTURE_DYED_BLOCKED, false);
    private static final class_1921 LAYER_DYED_GLOW = VARenderLayers.getMiniPortal(TEXTURE_DYED_GLOW, true);
    private static final class_1921 LAYER_DYED_BLOCKED_GLOW = VARenderLayers.getMiniPortal(TEXTURE_DYED_BLOCKED_GLOW, true);

    public MiniPortalBlockEntityRenderer(class_5614.class_5615 context) {
    }

    private static class_1921 getGlowLayer(MiniPortalBlockEntityRenderState state) {
        boolean dyed = state.dyeColor.isPresent();
        if (dyed) {
            return state.blocked ? LAYER_DYED_BLOCKED_GLOW : LAYER_DYED_GLOW;
        }
        return state.blocked ? LAYER_BLOCKED_GLOW : LAYER_GLOW;
    }

    private static class_1921 getBaseLayer(MiniPortalBlockEntityRenderState state) {
        boolean dyed = state.dyeColor.isPresent();
        if (dyed) {
            return state.blocked ? LAYER_DYED_BLOCKED : LAYER_DYED;
        }
        return state.blocked ? LAYER_BLOCKED : LAYER;
    }

    private static void renderPortal(MiniPortalBlockEntityRenderState state, class_4587 matrices, class_11659 renderCommandQueue, class_12075 cameraRenderState, class_1921 layer) {
        renderCommandQueue.method_73483(matrices, layer, (matricesEntry, vertexConsumer) -> {
            matricesEntry.method_67796(0.5f, 0.5f, 0.5f);
            matricesEntry.method_67798((Quaternionfc)cameraRenderState.field_63081);
            int color = state.dyeColor.map(class_1767::method_7787).orElse(-1);
            MiniPortalBlockEntityRenderer.producePortalVertex(vertexConsumer, matricesEntry, 255, 0.0f, 0, 0, 1, color);
            MiniPortalBlockEntityRenderer.producePortalVertex(vertexConsumer, matricesEntry, 255, 1.0f, 0, 1, 1, color);
            MiniPortalBlockEntityRenderer.producePortalVertex(vertexConsumer, matricesEntry, 255, 1.0f, 1, 1, 0, color);
            MiniPortalBlockEntityRenderer.producePortalVertex(vertexConsumer, matricesEntry, 255, 0.0f, 1, 0, 0, color);
        });
    }

    private static void producePortalVertex(class_4588 vertexConsumer, class_4587.class_4665 matrix, int light, float x, int z, int textureU, int textureV, int color) {
        vertexConsumer.method_56824(matrix, x - 0.5f, (float)z - 0.5f, 0.0f).method_39415(color).method_22913((float)textureU, (float)textureV).method_22922(class_4608.field_21444).method_60803(light).method_60831(matrix, 0.0f, 1.0f, 0.0f);
    }

    public MiniPortalBlockEntityRenderState createRenderState() {
        return new MiniPortalBlockEntityRenderState();
    }

    public void updateRenderState(MiniPortalBlockEntity blockEntity, MiniPortalBlockEntityRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)state, tickProgress, cameraPos, crumblingOverlay);
        state.blocked = blockEntity.isBlocked();
        state.dyeColor = Optional.ofNullable(blockEntity.getDyeColor());
    }

    public void render(MiniPortalBlockEntityRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraRenderState) {
        MiniPortalBlockEntityRenderer.renderPortal(state, matrices, queue, cameraRenderState, MiniPortalBlockEntityRenderer.getGlowLayer(state));
        MiniPortalBlockEntityRenderer.renderPortal(state, matrices, queue, cameraRenderState, MiniPortalBlockEntityRenderer.getBaseLayer(state));
    }
}

