/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.client.screen;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.block.entity.DyeContents;
import com.github.suninvr.virtualadditions.screen.ColoringStationScreenHandler;
import java.util.ArrayList;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class ColoringStationScreen
extends class_465<ColoringStationScreenHandler> {
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60654((String)"container/stonecutter/scroller");
    private static final class_2960 SCROLLER_DISABLED_TEXTURE = class_2960.method_60654((String)"container/stonecutter/scroller_disabled");
    private static final class_2960 RECIPE_SELECTED_TEXTURE = class_2960.method_60654((String)"container/stonecutter/recipe_selected");
    private static final class_2960 RECIPE_HIGHLIGHTED_TEXTURE = class_2960.method_60654((String)"container/stonecutter/recipe_highlighted");
    private static final class_2960 RECIPE_UNCRAFTABLE_TEXTURE = VirtualAdditions.idOf("container/coloring_station/recipe_uncraftable");
    private static final class_2960 RECIPE_TEXTURE = class_2960.method_60654((String)"container/stonecutter/recipe");
    private static final class_2960 DYE_SLOT_TEXTURE = class_2960.method_60654((String)"container/slot/dye");
    private static final class_2960 TEXTURE = VirtualAdditions.idOf("textures/gui/container/coloring_station.png");
    private static final class_2561 NOT_ENOUGH_DYE_WARNING = class_2561.method_43471((String)"container.virtual_additions.coloring_station.not_enough_dye_warning").method_27692(class_124.field_1061);
    private static final class_2561 CANT_CRAFT_SAME_ITEM_WARNING = class_2561.method_43471((String)"container.virtual_additions.coloring_station.cant_craft_same_item_warning").method_27692(class_124.field_1061);
    private static final class_2561 DYE_SLOT_HINT = class_2561.method_43471((String)"container.virtual_additions.coloring_station.dye_slot_hint");
    private static final class_2561 ITEM_SLOT_HINT = class_2561.method_43471((String)"container.virtual_additions.coloring_station.item_slot_hint");
    private static int K = 0;
    private static int W = 0;
    private static int R = 0;
    private static int G = 0;
    private static int B = 0;
    private static int Y = 0;
    private static final String INDICATOR_BLACK = "container.virtual_additions.coloring_station.indicator.black";
    private static final String INDICATOR_WHITE = "container.virtual_additions.coloring_station.indicator.white";
    private static final String INDICATOR_RED = "container.virtual_additions.coloring_station.indicator.red";
    private static final String INDICATOR_GREEN = "container.virtual_additions.coloring_station.indicator.green";
    private static final String INDICATOR_BLUE = "container.virtual_additions.coloring_station.indicator.blue";
    private static final String INDICATOR_YELLOW = "container.virtual_additions.coloring_station.indicator.yellow";
    private static final String INDICATOR_ADVANCED_BLACK = "container.virtual_additions.coloring_station.indicator.advanced.black";
    private static final String INDICATOR_ADVANCED_WHITE = "container.virtual_additions.coloring_station.indicator.advanced.white";
    private static final String INDICATOR_ADVANCED_RED = "container.virtual_additions.coloring_station.indicator.advanced.red";
    private static final String INDICATOR_ADVANCED_GREEN = "container.virtual_additions.coloring_station.indicator.advanced.green";
    private static final String INDICATOR_ADVANCED_BLUE = "container.virtual_additions.coloring_station.indicator.advanced.blue";
    private static final String INDICATOR_ADVANCED_YELLOW = "container.virtual_additions.coloring_station.indicator.advanced.yellow";
    private DyeContents dyeContents;
    private DyeContents cachedDyeContents;
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;
    private boolean canCraft;
    private ColorCache[] caches = new ColorCache[]{new ColorCache(0), new ColorCache(0), new ColorCache(0), new ColorCache(0), new ColorCache(0), new ColorCache(0)};

    public ColoringStationScreen(ColoringStationScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        this.dyeContents = handler.getDyeContents();
    }

    protected void method_25426() {
        super.method_25426();
        this.updateCaches();
        --this.field_25268;
    }

    private void updateCaches() {
        int[] dyes = this.dyeContents.asIntArray();
        for (int i = 0; i < 6; ++i) {
            this.caches[i] = new ColorCache(dyes[i]);
        }
        this.cachedDyeContents = this.dyeContents.copy();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.cachedDyeContents.equals(this.dyeContents)) {
            this.updateCaches();
        }
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int i = this.field_2776;
        int j = this.field_2800;
        context.method_25290(class_10799.field_56883, TEXTURE, i, j, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        this.drawDyeStatusBar(context, 0, this.caches[4].percent, i + 10, j + 35);
        this.drawDyeStatusBar(context, 1, this.caches[5].percent, i + 10, j + 41);
        this.drawDyeStatusBar(context, 2, this.caches[0].percent, i + 10, j + 47);
        this.drawDyeStatusBar(context, 3, this.caches[1].percent, i + 10, j + 53);
        this.drawDyeStatusBar(context, 4, this.caches[2].percent, i + 10, j + 59);
        this.drawDyeStatusBar(context, 5, this.caches[3].percent, i + 10, j + 65);
        class_1735 slot = ((ColoringStationScreenHandler)this.field_2797).method_7611(0);
        if (!slot.method_7681()) {
            context.method_52706(class_10799.field_56883, DYE_SLOT_TEXTURE, i + slot.field_7873, j + slot.field_7872, 16, 16);
        }
        int k = (int)(41.0f * this.scrollAmount);
        class_2960 identifier = this.shouldScroll() ? SCROLLER_TEXTURE : SCROLLER_DISABLED_TEXTURE;
        context.method_52706(class_10799.field_56883, identifier, i + 119, j + 15 + k, 12, 15);
        int l = this.field_2776 + 52;
        int m = this.field_2800 + 14;
        int n = this.scrollOffset + 12;
        this.renderRecipeBackground(context, mouseX, mouseY, l, m, n);
        this.renderRecipeIcons(context, l, m, n);
    }

    private void drawDyeStatusBar(class_332 context, int index, float percent, int x, int y) {
        int v = index * 4;
        int max = (int)Math.ceil(34.0f * percent);
        context.method_25290(class_10799.field_56883, TEXTURE, x, y, 176.0f, (float)v, max, 4, 256, 256);
    }

    protected void method_2380(class_332 context, int x, int y) {
        boolean bl;
        int k;
        int j;
        int i;
        super.method_2380(context, x, y);
        if (this.field_22787 == null) {
            return;
        }
        boolean advanced = this.field_22787.field_1690.field_1827;
        if (((ColoringStationScreenHandler)this.field_2797).canCraft() && this.field_22787.field_1687 != null) {
            i = this.field_2776 + 52;
            j = this.field_2800 + 14;
            k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k && l < ((ColoringStationScreenHandler)this.field_2797).getAvailableRecipeCount(); ++l) {
                if (((ColoringStationScreenHandler)this.field_2797).getRecipeData(l) == null) continue;
                ColoringStationScreenHandler.ColoringRecipeData data = ((ColoringStationScreenHandler)this.field_2797).getRecipeData(l);
                int m = l - this.scrollOffset;
                int n = i + m % 4 * 16;
                int o = j + m / 4 * 18 + 2;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                class_1799 stack = data.stack();
                ArrayList<Object> tooltip = new ArrayList<Object>(class_437.method_25408((class_310)this.field_22787, (class_1799)stack));
                if (!data.isInputValid(((ColoringStationScreenHandler)this.field_2797).input.method_5438(1))) {
                    tooltip.add(CANT_CRAFT_SAME_ITEM_WARNING);
                } else if (!data.isDyeContentSufficient(this.dyeContents)) {
                    tooltip.add(NOT_ENOUGH_DYE_WARNING);
                }
                if (advanced) {
                    DyeContents cost = data.dyeCost().copyAndMultiply(-1);
                    int K = cost.getK();
                    int W = cost.getW();
                    int R = cost.getR();
                    int G = cost.getG();
                    int B = cost.getB();
                    int Y = cost.getY();
                    if (K > 0) {
                        tooltip.add(class_2561.method_30163((String)("Black Cost: " + K)).method_27661().method_27692(K > this.dyeContents.getK() ? class_124.field_1061 : class_124.field_1080));
                    }
                    if (W > 0) {
                        tooltip.add(class_2561.method_30163((String)("White Cost: " + W)).method_27661().method_27692(W > this.dyeContents.getW() ? class_124.field_1061 : class_124.field_1080));
                    }
                    if (R > 0) {
                        tooltip.add(class_2561.method_30163((String)("Red Cost: " + R)).method_27661().method_27692(R > this.dyeContents.getR() ? class_124.field_1061 : class_124.field_1080));
                    }
                    if (G > 0) {
                        tooltip.add(class_2561.method_30163((String)("Green Cost: " + G)).method_27661().method_27692(G > this.dyeContents.getG() ? class_124.field_1061 : class_124.field_1080));
                    }
                    if (B > 0) {
                        tooltip.add(class_2561.method_30163((String)("Blue Cost: " + B)).method_27661().method_27692(B > this.dyeContents.getB() ? class_124.field_1061 : class_124.field_1080));
                    }
                    if (Y > 0) {
                        tooltip.add(class_2561.method_30163((String)("Yellow Cost: " + Y)).method_27661().method_27692(Y > this.dyeContents.getY() ? class_124.field_1061 : class_124.field_1080));
                    }
                }
                context.method_64038(this.field_22793, tooltip, stack.method_32347(), x, y);
            }
        }
        i = this.field_2776;
        j = this.field_2800;
        if (x < i + 45 && x >= i + 9 && y < j + 40 && y >= j + 34) {
            K = !advanced ? this.caches[4].dye : this.dyeContents.getK();
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)(advanced ? INDICATOR_ADVANCED_BLACK : INDICATOR_BLACK), (Object[])new Object[]{K}), x, y);
        }
        if (x < i + 45 && x >= i + 9 && y < j + 46 && y >= j + 40) {
            W = !advanced ? this.caches[5].dye : this.dyeContents.getW();
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)(advanced ? INDICATOR_ADVANCED_WHITE : INDICATOR_WHITE), (Object[])new Object[]{W}), x, y);
        }
        if (x < i + 45 && x >= i + 9 && y < j + 52 && y >= j + 46) {
            R = !advanced ? this.caches[0].dye : this.dyeContents.getR();
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)(advanced ? INDICATOR_ADVANCED_RED : INDICATOR_RED), (Object[])new Object[]{R}), x, y);
        }
        if (x < i + 45 && x >= i + 9 && y < j + 58 && y >= j + 52) {
            G = !advanced ? this.caches[1].dye : this.dyeContents.getG();
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)(advanced ? INDICATOR_ADVANCED_GREEN : INDICATOR_GREEN), (Object[])new Object[]{G}), x, y);
        }
        if (x < i + 45 && x >= i + 9 && y < j + 64 && y >= j + 58) {
            B = !advanced ? this.caches[2].dye : this.dyeContents.getB();
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)(advanced ? INDICATOR_ADVANCED_BLUE : INDICATOR_BLUE), (Object[])new Object[]{B}), x, y);
        }
        if (x < i + 45 && x >= i + 9 && y < j + 70 && y >= j + 64) {
            Y = !advanced ? this.caches[3].dye : this.dyeContents.getY();
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)(advanced ? INDICATOR_ADVANCED_YELLOW : INDICATOR_YELLOW), (Object[])new Object[]{Y}), x, y);
        }
        k = 0;
        boolean bl2 = bl = this.field_2787 != null;
        if (bl) {
            k = this.field_2787.field_7874;
        }
        if (bl && k == 0 && !this.field_2787.method_7681()) {
            context.method_51438(this.field_22793, DYE_SLOT_HINT, x, y);
        }
        if (bl && k == 1 && !this.field_2787.method_7681()) {
            context.method_51438(this.field_22793, ITEM_SLOT_HINT, x, y);
        }
    }

    private void renderRecipeBackground(class_332 context, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((ColoringStationScreenHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            if (((ColoringStationScreenHandler)this.field_2797).getRecipeData(i) == null) continue;
            int j = i - this.scrollOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            ColoringStationScreenHandler.ColoringRecipeData data = ((ColoringStationScreenHandler)this.field_2797).getRecipeData(i);
            class_1799 stack = ((ColoringStationScreenHandler)this.field_2797).input.method_5438(1);
            class_2960 identifier = data.isDyeContentSufficient(this.dyeContents) && data.isInputValid(stack) ? (i == ((ColoringStationScreenHandler)this.field_2797).getSelectedRecipe() ? RECIPE_SELECTED_TEXTURE : (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18 ? RECIPE_HIGHLIGHTED_TEXTURE : RECIPE_TEXTURE)) : RECIPE_UNCRAFTABLE_TEXTURE;
            context.method_52706(class_10799.field_56883, identifier, k, m - 1, 16, 18);
        }
    }

    private void renderRecipeIcons(class_332 context, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((ColoringStationScreenHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            if (((ColoringStationScreenHandler)this.field_2797).getRecipeData(i) == null) continue;
            int j = i - this.scrollOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            ColoringStationScreenHandler.ColoringRecipeData data = ((ColoringStationScreenHandler)this.field_2797).getRecipeData(i);
            context.method_51427(data.stack(), k, m);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        this.mouseClicked = false;
        if (this.field_22787 != null && ((ColoringStationScreenHandler)this.field_2797).canCraft()) {
            int i = this.field_2776 + 52;
            int j = this.field_2800 + 14;
            int k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k; ++l) {
                int m = l - this.scrollOffset;
                double d = click.comp_4798() - (double)(i + m % 4 * 16);
                double e = click.comp_4799() - (double)(j + m / 4 * 18);
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((ColoringStationScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, l))) continue;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                if (this.field_22787.field_1761 != null) {
                    this.field_22787.field_1761.method_2900(((ColoringStationScreenHandler)this.field_2797).field_7763, l);
                }
                return true;
            }
            i = this.field_2776 + 119;
            j = this.field_2800 + 9;
            if (click.comp_4798() >= (double)i && click.comp_4798() < (double)(i + 12) && click.comp_4799() >= (double)j && click.comp_4799() < (double)(j + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_2800 + 14;
            int j = i + 54;
            this.scrollAmount = (float)((click.comp_4799() - (double)i - 7.5) / (double)((float)(j - i) - 15.0f));
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            float f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean shouldScroll() {
        return ((ColoringStationScreenHandler)this.field_2797).canCraft() && ((ColoringStationScreenHandler)this.field_2797).getAvailableRecipeCount() > 12;
    }

    protected int getMaxScroll() {
        return (((ColoringStationScreenHandler)this.field_2797).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    private void onInventoryChange() {
        this.canCraft = ((ColoringStationScreenHandler)this.field_2797).canCraft();
        if (!this.canCraft) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }

    private record ColorCache(int amount, int dye, float percent) {
        private ColorCache(int amount) {
            this(amount, amount / 32, (float)amount / 8192.0f);
        }
    }
}

