/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import net.minecraft.class_9473;

public record EffectsOnHitComponent(Optional<class_1844> potionContents, Optional<Integer> uses, Optional<Integer> remaining) implements class_9299
{
    public static final EffectsOnHitComponent DEFAULT = new EffectsOnHitComponent(Optional.empty(), Optional.empty(), Optional.empty());
    public static final Codec<EffectsOnHitComponent> CODEC;
    public static final class_9139<class_9129, EffectsOnHitComponent> PACKET_CODEC;
    private static final class_2561 tooltipText;

    public EffectsOnHitComponent(class_6880<class_1842> potion) {
        this(Optional.of(new class_1844(potion)), Optional.of(30), Optional.of(0));
    }

    public EffectsOnHitComponent(class_1844 component, int uses, int remaining) {
        this(Optional.of(component), Optional.of(uses), Optional.of(remaining));
    }

    public int getRemainingUses() {
        return this.remaining.orElse(0);
    }

    public int getTotalUses() {
        return this.uses.orElse(0);
    }

    public int getItemBarAmount() {
        int remaining = this.getRemainingUses();
        int total = this.getTotalUses();
        return total == 0 ? 0 : remaining * 13 / total;
    }

    public int getColor() {
        return this.potionContents.map(class_1844::method_8064).orElse(0xF800F8);
    }

    public boolean hasEffectsComponent() {
        return this.potionContents.isPresent();
    }

    public EffectsOnHitComponent decrementRemainingUses() {
        if (this.remaining.isEmpty()) {
            return this;
        }
        int remaining = this.remaining.get() - 1;
        return remaining <= 0 ? null : new EffectsOnHitComponent(this.potionContents, this.uses, Optional.of(this.remaining.get() - 1));
    }

    public Iterable<class_1293> getEffects() {
        if (this.potionContents.isPresent()) {
            return this.potionContents.get().method_57397();
        }
        return List.of();
    }

    public void forEachEffect(Consumer<class_1293> effectConsumer) {
        this.potionContents.ifPresent(component -> component.method_57402(effectConsumer, 1.0f));
    }

    public static class_9331.class_9332<EffectsOnHitComponent> setCodecs(class_9331.class_9332<EffectsOnHitComponent> builder) {
        return builder.method_57881(CODEC).method_57882(PACKET_CODEC);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        if (this.hasEffectsComponent()) {
            if (type.method_8035() && this.getRemainingUses() > 0) {
                class_5250 text = class_2561.method_43469((String)"item.virtual_additions.applied_effect_tooltip.advanced", (Object[])new Object[]{this.getRemainingUses(), this.getTotalUses()}).method_27692(class_124.field_1064);
                textConsumer.accept((class_2561)text);
            }
            textConsumer.accept(tooltipText);
            this.potionContents.get().method_57409(context, textConsumer, type, components);
        }
    }

    static {
        tooltipText = class_2561.method_43471((String)"item.virtual_additions.applied_effect_tooltip").method_27692(class_124.field_1064);
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1844.field_49275.optionalFieldOf("potion").forGetter(EffectsOnHitComponent::potionContents), (App)class_5699.field_33441.optionalFieldOf("total_uses").forGetter(EffectsOnHitComponent::uses), (App)class_5699.field_33441.optionalFieldOf("remaining_uses").forGetter(EffectsOnHitComponent::remaining)).apply((Applicative)instance, EffectsOnHitComponent::new));
        PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.method_56382((class_9139)class_1844.field_49276), EffectsOnHitComponent::potionContents, (class_9139)class_9135.field_49675.method_56433(class_9135::method_56382), EffectsOnHitComponent::uses, (class_9139)class_9135.field_49675.method_56433(class_9135::method_56382), EffectsOnHitComponent::remaining, EffectsOnHitComponent::new);
    }
}

