/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.datagen;

import com.github.suninvr.virtualadditions.block.BalloonBulbPlantBlock;
import com.github.suninvr.virtualadditions.block.CornCropBlock;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VACollections;
import com.github.suninvr.virtualadditions.registry.VAItems;
import com.github.suninvr.virtualadditions.registry.collection.ColorfulBlockSet;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_104;
import net.minecraft.class_10596;
import net.minecraft.class_116;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_205;
import net.minecraft.class_2090;
import net.minecraft.class_212;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_44;
import net.minecraft.class_4550;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_5794;
import net.minecraft.class_65;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7788;
import net.minecraft.class_7871;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import net.minecraft.class_8548;
import net.minecraft.class_8551;
import net.minecraft.class_94;

public final class VABlockLootTableProvider {
    public static FabricDataGenerator.Pack.RegistryDependentFactory<?> base() {
        return BaseProvider::new;
    }

    public static FabricDataGenerator.Pack.RegistryDependentFactory<?> preview() {
        return PreviewProvider::new;
    }

    private static abstract class Provider
    extends FabricBlockLootTableProvider {
        protected final class_7871<class_1887> registryLookup;

        protected Provider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
            this.registryLookup = this.field_51845.method_46762(class_7924.field_41265);
        }

        protected void addFamilyDrops(class_5794 ... blockFamilies) {
            for (class_5794 family : blockFamilies) {
                this.method_46025(family.method_33469());
                family.method_33474().forEach(this::addDrop);
            }
        }

        protected void addColorfulBlockSetDrops(ColorfulBlockSet set) {
            set.ifWool(this::method_46025);
            set.ifCarpet(this::method_46025);
            set.ifTerracotta(this::method_46025);
            set.ifConcrete(this::method_46025);
            set.ifConcretePowder(this::method_46025);
            set.ifStainedGlass(arg_0 -> ((Provider)this).method_46024(arg_0));
            set.ifStainedGlassPane(arg_0 -> ((Provider)this).method_46024(arg_0));
            set.ifSilkbulb(this::method_46025);
            set.ifCandle(block -> {
                this.field_40610.put((class_5321)block.method_26162().get(), this.method_46020((class_2248)block));
                set.ifCandleCake(candleCakeBlock -> this.field_40610.put((class_5321)candleCakeBlock.method_26162().get(), class_7788.method_46021((class_2248)block)));
            });
            set.ifBed(block -> this.field_40610.put((class_5321)block.method_26162().get(), this.method_45987((class_2248)block, (class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560)));
            set.ifShulkerBox(block -> this.field_40610.put((class_5321)block.method_26162().get(), this.method_46004((class_2248)block)));
            set.ifBanner(block -> this.field_40610.put((class_5321)block.method_26162().get(), this.method_46013((class_2248)block)));
            set.ifGlazedTerracotta(this::method_46025);
        }

        protected void addDrop(class_5794.class_5796 variant, class_2248 block) {
            switch (variant) {
                case field_28539: {
                    this.method_45994(block, arg_0 -> ((Provider)this).method_45980(arg_0));
                    break;
                }
                case field_28535: {
                    this.method_45994(block, arg_0 -> ((Provider)this).method_46022(arg_0));
                    break;
                }
                default: {
                    this.method_46025(block);
                }
            }
        }

        protected void addSimpleDrops(class_2248 ... blocks) {
            for (class_2248 block : blocks) {
                this.method_46025(block);
            }
        }

        public void method_46025(class_2248 block) {
            this.method_46006(block, (class_1935)block);
        }

        public void method_46006(class_2248 block, class_1935 drop) {
            this.method_45988(block, this.method_45976(drop));
        }

        public void method_45988(class_2248 block, class_52.class_53 lootTable) {
            this.field_40610.put((class_5321)block.method_26162().get(), lootTable.method_51883(((class_5321)block.method_26162().get()).method_29177()));
        }

        public class_52.class_53 cropDrops(class_2248 crop, class_1792 product, class_1792 seeds, int minYield, int maxYield, class_5341.class_210 condition) {
            class_7225.class_7226 impl = this.field_51845.method_46762(class_7924.field_41265);
            return (class_52.class_53)this.method_45977((class_1935)crop, (class_116)class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)((class_85.class_86)class_77.method_411((class_1935)product).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)minYield, (float)maxYield))).method_421(condition)).method_417((class_79.class_80)class_77.method_411((class_1935)seeds)))).method_336(class_55.method_347().method_356(condition).method_351((class_79.class_80)class_77.method_411((class_1935)seeds).method_438((class_117.class_118)class_94.method_463((class_6880)impl.method_46747(class_1893.field_9130), (float)0.5714286f, (int)3)))));
        }

        public class_52.class_53 plantCropDrops(class_2248 crop, class_1792 product, class_1792 seeds, class_5341.class_210 condition) {
            class_7225.class_7226 impl = this.field_51845.method_46762(class_7924.field_41265);
            return (class_52.class_53)this.method_45977((class_1935)crop, (class_116)class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)((class_85.class_86)class_77.method_411((class_1935)product).method_421(condition)).method_417((class_79.class_80)class_77.method_411((class_1935)seeds)))).method_336(class_55.method_347().method_356(condition).method_351((class_79.class_80)class_77.method_411((class_1935)seeds).method_438((class_117.class_118)class_94.method_463((class_6880)impl.method_46747(class_1893.field_9130), (float)0.5714286f, (int)3)))));
        }

        public class_52.class_53 method_45981(class_2248 dropWithSilkTouch, class_1792 drop) {
            return this.method_45989(dropWithSilkTouch, (class_79.class_80)this.method_45977((class_1935)dropWithSilkTouch, (class_116)class_77.method_411((class_1935)drop).method_438((class_117.class_118)class_94.method_455((class_6880)this.registryLookup.method_46747(class_1893.field_9130))))).method_51883(((class_5321)dropWithSilkTouch.method_26162().get()).method_29177());
        }

        public class_52.class_53 rockSaltOreDrops(class_2248 drop) {
            class_7225.class_7226 impl = this.field_51845.method_46762(class_7924.field_41265);
            return this.method_45989(drop, (class_79.class_80)this.method_45977((class_1935)drop, (class_116)class_77.method_411((class_1935)VAItems.ROCK_SALT).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)2.0f))).method_438((class_117.class_118)class_94.method_455((class_6880)impl.method_46747(class_1893.field_9130)))));
        }

        public class_52.class_53 bonePileDrops(class_2248 drop) {
            return this.method_45989(drop, (class_79.class_80)this.method_45977((class_1935)drop, (class_116)class_77.method_411((class_1935)class_1802.field_8324).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)-1.0f, (float)1.0f)))));
        }

        protected class_52.class_53 cornDrops() {
            class_7225.class_7226 impl = this.field_51845.method_46762(class_7924.field_41265);
            return class_52.method_324().method_336(this.createCornCropSeedsLoot((class_7225.class_7226<class_1887>)impl, CornCropBlock.Segment.TOP)).method_336(this.createCornCropSeedsLoot((class_7225.class_7226<class_1887>)impl, CornCropBlock.Segment.MIDDLE)).method_336(this.createCornCropSeedsLoot((class_7225.class_7226<class_1887>)impl, CornCropBlock.Segment.BOTTOM)).method_336(this.createCornCropLoot(CornCropBlock.Segment.TOP)).method_336(this.createCornCropLoot(CornCropBlock.Segment.MIDDLE)).method_336(this.createCornCropLoot(CornCropBlock.Segment.BOTTOM)).method_335((class_117.class_118)class_104.method_478());
        }

        private class_55.class_56 createCornCropSeedsLoot(class_7225.class_7226<class_1887> impl, CornCropBlock.Segment segment) {
            class_55.class_56 builder = class_55.method_347();
            builder.method_351((class_79.class_80)class_77.method_411((class_1935)VAItems.CORN_SEEDS).method_438((class_117.class_118)class_94.method_463((class_6880)impl.method_46747(class_1893.field_9130), (float)0.5714286f, (int)3).method_524((class_5341.class_210)class_212.method_900((class_2248)VABlocks.CORN_CROP).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)CornCropBlock.field_10835, 7))))).method_356((class_5341.class_210)class_212.method_900((class_2248)VABlocks.CORN_CROP).method_22584(class_4559.class_4560.method_22523().method_22525(CornCropBlock.SEGMENT, (Comparable)((Object)segment))));
            if (segment.equals((Object)CornCropBlock.Segment.BOTTOM)) {
                builder.method_356(this.createCornCropSeedsLootCondition(segment, CornCropBlock.Segment.MIDDLE));
                builder.method_356(this.createCornCropSeedsLootCondition(segment, CornCropBlock.Segment.TOP));
            }
            if (segment.equals((Object)CornCropBlock.Segment.MIDDLE)) {
                builder.method_356(this.createCornCropSeedsLootCondition(segment, CornCropBlock.Segment.TOP));
                builder.method_356(this.createCornCropLootCondition(segment, CornCropBlock.Segment.BOTTOM));
            }
            if (segment.equals((Object)CornCropBlock.Segment.TOP)) {
                builder.method_356(this.createCornCropLootCondition(segment, CornCropBlock.Segment.MIDDLE));
                builder.method_356(this.createCornCropLootCondition(segment, CornCropBlock.Segment.BOTTOM));
            }
            return builder;
        }

        private class_55.class_56 createCornCropLoot(CornCropBlock.Segment segment) {
            class_55.class_56 builder = class_55.method_347();
            builder.method_351((class_79.class_80)class_77.method_411((class_1935)VAItems.CORN)).method_356((class_5341.class_210)class_212.method_900((class_2248)VABlocks.CORN_CROP).method_22584(class_4559.class_4560.method_22523().method_22525(CornCropBlock.SEGMENT, (Comparable)((Object)segment)).method_22524((class_2769)CornCropBlock.field_10835, 7)));
            if (!segment.equals((Object)CornCropBlock.Segment.BOTTOM)) {
                builder.method_356(this.createCornCropLootCondition(segment, CornCropBlock.Segment.BOTTOM, true));
            }
            if (!segment.equals((Object)CornCropBlock.Segment.MIDDLE)) {
                builder.method_356(this.createCornCropLootCondition(segment, CornCropBlock.Segment.MIDDLE, true));
            }
            if (!segment.equals((Object)CornCropBlock.Segment.TOP)) {
                builder.method_356(this.createCornCropLootCondition(segment, CornCropBlock.Segment.TOP, true));
            }
            return builder.method_353((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)2.0f)));
        }

        private class_5341.class_210 createCornCropSeedsLootCondition(CornCropBlock.Segment segment, CornCropBlock.Segment expectedSegment) {
            return class_8551.method_51727((class_5341.class_210[])new class_5341.class_210[]{this.createCornCropLootCondition(segment, expectedSegment), this.createCornCropSeedsAgeConditions(segment.minAge(), expectedSegment.minAge())});
        }

        private class_5341.class_210 createCornCropLootCondition(CornCropBlock.Segment segment, CornCropBlock.Segment expectedSegment) {
            int i = segment.getYOffset(expectedSegment);
            return class_8551.method_51727((class_5341.class_210[])this.createCornCropStateConditions(expectedSegment, i, segment.minAge()));
        }

        private class_5341.class_210 createCornCropLootCondition(CornCropBlock.Segment segment, CornCropBlock.Segment expectedSegment, boolean fullyGrown) {
            if (!fullyGrown) {
                return this.createCornCropLootCondition(segment, expectedSegment);
            }
            int i = segment.getYOffset(expectedSegment);
            return class_205.method_30151((class_2090.class_2091)class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27963(class_4559.class_4560.method_22523().method_22525(CornCropBlock.SEGMENT, (Comparable)((Object)expectedSegment)).method_22524((class_2769)CornCropBlock.field_10835, 7))), (class_2338)new class_2338(0, i, 0));
        }

        private class_5341.class_210[] createCornCropStateConditions(CornCropBlock.Segment segment, int offset, int minAge) {
            class_5341.class_210[] builders = new class_5341.class_210[]{};
            ArrayList<class_8548.class_8549> buildersList = new ArrayList<class_8548.class_8549>();
            for (int i = minAge; i < 8; ++i) {
                buildersList.add(class_8548.method_51723((class_5341.class_210[])new class_5341.class_210[]{class_212.method_900((class_2248)VABlocks.CORN_CROP).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)CornCropBlock.field_10835, i)), class_205.method_30151((class_2090.class_2091)class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27963(class_4559.class_4560.method_22523().method_22525(CornCropBlock.SEGMENT, (Comparable)((Object)segment)).method_22524((class_2769)CornCropBlock.field_10835, i))), (class_2338)new class_2338(0, offset, 0))}));
            }
            return buildersList.toArray(builders);
        }

        private class_5341.class_210 createCornCropSeedsAgeConditions(int minAge, int maxAge) {
            class_5341.class_210[] builders = new class_5341.class_210[]{};
            ArrayList<class_212.class_213> buildersList = new ArrayList<class_212.class_213>();
            for (int i = minAge; i < maxAge; ++i) {
                buildersList.add(class_212.method_900((class_2248)VABlocks.CORN_CROP).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)CornCropBlock.field_10835, i)));
            }
            return class_8551.method_51727((class_5341.class_210[])buildersList.toArray(builders));
        }

        protected class_52.class_53 boneLitterDrops(class_2248 segmented) {
            class_52.class_53 class_532;
            if (segmented instanceof class_10596) {
                class_10596 segmented2 = (class_10596)segmented;
                class_532 = class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_65.method_386((class_79.class_80[])new class_79.class_80[]{((class_85.class_86)class_77.method_411((class_1935)segmented).method_43739(IntStream.rangeClosed(1, 4).boxed().toList(), count -> class_141.method_621((class_5658)class_44.method_32448((float)count.intValue())).method_524((class_5341.class_210)class_212.method_900((class_2248)segmented).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)segmented2.method_66434(), count.intValue()))))).method_421(this.method_60390()), (class_79.class_80)class_77.method_411((class_1935)class_1802.field_8324).method_43739(IntStream.rangeClosed(1, 4).boxed().toList(), count -> class_141.method_621((class_5658)class_5662.method_32462((float)-1.0f, (float)count.intValue())).method_524((class_5341.class_210)class_212.method_900((class_2248)segmented).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)segmented2.method_66434(), count.intValue()))))})).method_353((class_117.class_118)class_104.method_478()));
            } else {
                class_532 = Provider.method_45975();
            }
            return class_532;
        }
    }

    private static class PreviewProvider
    extends Provider {
        public PreviewProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup);
        }

        public void method_10379() {
            this.method_45994(VABlocks.BALLOON_BULB, block -> this.method_45976((class_1935)VAItems.BALLOON_FRUIT));
            this.method_45994(VABlocks.BALLOON_BULB_PLANT, block -> new class_52.class_53().method_336(class_55.method_347().method_351((class_79.class_80)((class_85.class_86)class_77.method_411((class_1935)VAItems.BALLOON_FRUIT).method_421((class_5341.class_210)class_212.method_900((class_2248)VABlocks.BALLOON_BULB_PLANT).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)BalloonBulbPlantBlock.AGE, 3)))).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)2.0f, (float)3.0f))))));
        }
    }

    private static class BaseProvider
    extends Provider {
        protected BaseProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void method_10379() {
            this.addFamilyDrops(VACollections.CUT_STEEL, VACollections.EXPOSED_CUT_STEEL, VACollections.WEATHERED_CUT_STEEL, VACollections.OXIDIZED_CUT_STEEL, VACollections.WAXED_CUT_STEEL, VACollections.WAXED_EXPOSED_CUT_STEEL, VACollections.WAXED_WEATHERED_CUT_STEEL, VACollections.WAXED_OXIDIZED_CUT_STEEL, VACollections.COBBLED_HORNFELS, VACollections.COBBLED_BLUESCHIST, VACollections.COBBLED_SYENITE, VACollections.POLISHED_HORNFELS, VACollections.POLISHED_BLUESCHIST, VACollections.POLISHED_SYENITE, VACollections.HORNFELS_TILES, VACollections.BLUESCHIST_BRICKS, VACollections.SYENITE_BRICKS, VACollections.ROCK_SALT_BRICKS, VACollections.SOULBLOOM, VACollections.WITHERED, VACollections.PORPHYRY, VACollections.POLISHED_PORPHYRY, VACollections.PORPHYRY_BRICKS);
            this.addSimpleDrops(VABlocks.CLIMBING_ROPE_ANCHOR, VABlocks.EXPOSED_CLIMBING_ROPE_ANCHOR, VABlocks.WEATHERED_CLIMBING_ROPE_ANCHOR, VABlocks.OXIDIZED_CLIMBING_ROPE_ANCHOR, VABlocks.WAXED_CLIMBING_ROPE_ANCHOR, VABlocks.WAXED_EXPOSED_CLIMBING_ROPE_ANCHOR, VABlocks.WAXED_WEATHERED_CLIMBING_ROPE_ANCHOR, VABlocks.WAXED_OXIDIZED_CLIMBING_ROPE_ANCHOR, VABlocks.RAW_STEEL_BLOCK, VABlocks.STEEL_BLOCK, VABlocks.EXPOSED_STEEL_BLOCK, VABlocks.WEATHERED_STEEL_BLOCK, VABlocks.OXIDIZED_STEEL_BLOCK, VABlocks.WAXED_STEEL_BLOCK, VABlocks.WAXED_EXPOSED_STEEL_BLOCK, VABlocks.WAXED_WEATHERED_STEEL_BLOCK, VABlocks.WAXED_OXIDIZED_STEEL_BLOCK, VABlocks.STEEL_FENCE, VABlocks.STEEL_TRAPDOOR, VABlocks.EXPOSED_STEEL_TRAPDOOR, VABlocks.WEATHERED_STEEL_TRAPDOOR, VABlocks.OXIDIZED_STEEL_TRAPDOOR, VABlocks.WAXED_STEEL_TRAPDOOR, VABlocks.WAXED_EXPOSED_STEEL_TRAPDOOR, VABlocks.WAXED_WEATHERED_STEEL_TRAPDOOR, VABlocks.WAXED_OXIDIZED_STEEL_TRAPDOOR, VABlocks.STEEL_GRATE, VABlocks.EXPOSED_STEEL_GRATE, VABlocks.WEATHERED_STEEL_GRATE, VABlocks.OXIDIZED_STEEL_GRATE, VABlocks.WAXED_STEEL_GRATE, VABlocks.WAXED_EXPOSED_STEEL_GRATE, VABlocks.WAXED_WEATHERED_STEEL_GRATE, VABlocks.WAXED_OXIDIZED_STEEL_GRATE, VABlocks.REDSTONE_BRIDGE, VABlocks.CAGELIGHT, VABlocks.OAK_HEDGE, VABlocks.SPRUCE_HEDGE, VABlocks.BIRCH_HEDGE, VABlocks.JUNGLE_HEDGE, VABlocks.ACACIA_HEDGE, VABlocks.DARK_OAK_HEDGE, VABlocks.MANGROVE_HEDGE, VABlocks.CHERRY_HEDGE, VABlocks.AZALEA_HEDGE, VABlocks.FLOWERING_AZALEA_HEDGE, VABlocks.SILK_BLOCK, VABlocks.WEBBED_SILK, VABlocks.FRAYED_SILK, VABlocks.GREENCAP_MUSHROOM, VABlocks.SILKBULB, VABlocks.WHITE_SILKBULB, VABlocks.LIGHT_GRAY_SILKBULB, VABlocks.GRAY_SILKBULB, VABlocks.BLACK_SILKBULB, VABlocks.BROWN_SILKBULB, VABlocks.RED_SILKBULB, VABlocks.ORANGE_SILKBULB, VABlocks.YELLOW_SILKBULB, VABlocks.LIME_SILKBULB, VABlocks.GREEN_SILKBULB, VABlocks.CYAN_SILKBULB, VABlocks.LIGHT_BLUE_SILKBULB, VABlocks.BLUE_SILKBULB, VABlocks.PURPLE_SILKBULB, VABlocks.MAGENTA_SILKBULB, VABlocks.PINK_SILKBULB, VABlocks.ACID_BLOCK, VABlocks.ROCK_SALT_BLOCK, VABlocks.CHISELED_ROCK_SALT_BRICKS, VABlocks.SOULBLOOM_LOG, VABlocks.SOULBLOOM_WOOD, VABlocks.STRIPPED_SOULBLOOM_LOG, VABlocks.STRIPPED_SOULBLOOM_WOOD, VABlocks.SOULBLOOM_HANGING_SIGN, VABlocks.SOULBLOOM_SHELF, VABlocks.SOULBLOOM_SAPLING, VABlocks.SOULBLOOM_HEDGE, VABlocks.WITHERED_LOG, VABlocks.WITHERED_WOOD, VABlocks.STRIPPED_WITHERED_LOG, VABlocks.STRIPPED_WITHERED_WOOD, VABlocks.WITHERED_HANGING_SIGN, VABlocks.WITHERED_SHELF, VABlocks.WITHERED_SAPLING, VABlocks.WITHERED_HEDGE, VABlocks.NECROTIC_ROOTS, VABlocks.SPECTRAL_TORCH, VABlocks.SPECTRAL_LANTERN, VABlocks.SPECTRAL_SAND, VABlocks.COLORING_STATION, VABlocks.IOLITE_BLOCK, VABlocks.ENTANGLEMENT_DRIVE, VABlocks.SPOTLIGHT, VABlocks.SMALL_SPRING_LOTUS, VABlocks.SPRING_LOTUS, VABlocks.SOUL_SPROUT);
            this.method_45988(VABlocks.POTTED_GREENCAP_MUSHROOM, this.method_46009((class_1935)VABlocks.GREENCAP_MUSHROOM));
            this.method_45988(VABlocks.POTTED_SOULBLOOM_SAPLING, this.method_46009((class_1935)VABlocks.SOULBLOOM_SAPLING));
            this.method_45988(VABlocks.POTTED_WITHERED_SAPLING, this.method_46009((class_1935)VABlocks.WITHERED_SAPLING));
            this.method_45988(VABlocks.POTTED_NECROTIC_ROOTS, this.method_46009((class_1935)VABlocks.NECROTIC_ROOTS));
            this.method_45988(VABlocks.POTTED_SMALL_SPRING_LOTUS, this.method_46009((class_1935)VABlocks.SMALL_SPRING_LOTUS));
            this.method_45988(VABlocks.POTTED_SOUL_SPROUT, this.method_46009((class_1935)VABlocks.SOUL_SPROUT));
            this.method_45988(VABlocks.BLUE_PETALS, this.method_66554(VABlocks.BLUE_PETALS));
            this.method_45994(VABlocks.NECROTIC_NYLIUM, block -> this.method_45983((class_2248)block, (class_1935)class_2246.field_10515));
            this.method_45988(VABlocks.BONE_LITTER, this.boneLitterDrops(VABlocks.BONE_LITTER));
            this.method_45988(VABlocks.BONE_PILE, this.bonePileDrops(VABlocks.BONE_PILE));
            this.method_46006(VABlocks.MINI_PORTAL, (class_1935)VAItems.DRAINED_PORTAL_CORE);
            class_212.class_213 tomatoBuilder = class_212.method_900((class_2248)VABlocks.TOMATO).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)class_2302.field_10835, 7));
            this.method_45988(VABlocks.TOMATO, this.cropDrops(VABlocks.TOMATO, VAItems.TOMATO, VAItems.TOMATO_SEEDS, 1, 3, (class_5341.class_210)tomatoBuilder));
            class_212.class_213 cabbageBuilder = class_212.method_900((class_2248)VABlocks.CABBAGE).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)class_2302.field_10835, 7));
            this.method_45988(VABlocks.CABBAGE, this.method_45982(VABlocks.CABBAGE, VAItems.CABBAGE, VAItems.CABBAGE_SEEDS, (class_5341.class_210)cabbageBuilder));
            class_212.class_213 cottonBuilder = class_212.method_900((class_2248)VABlocks.COTTON).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)class_2302.field_10835, 7));
            this.method_45988(VABlocks.COTTON, this.cropDrops(VABlocks.COTTON, VAItems.COTTON, VAItems.COTTON_SEEDS, 1, 2, (class_5341.class_210)cottonBuilder));
            class_212.class_213 wisdom_berryCropBuilder = class_212.method_900((class_2248)VABlocks.WISDOM_BERRY).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)class_2302.field_10835, 7));
            this.method_45988(VABlocks.WISDOM_BERRY, this.plantCropDrops(VABlocks.WISDOM_BERRY, VAItems.WISDOM_BERRY, VAItems.WISDOM_BERRY_SEEDS, (class_5341.class_210)wisdom_berryCropBuilder));
            this.method_45988(VABlocks.CORN_CROP, this.cornDrops());
            this.addColorfulBlockSetDrops(VACollections.CHARTREUSE);
            this.addColorfulBlockSetDrops(VACollections.MAROON);
            this.addColorfulBlockSetDrops(VACollections.INDIGO);
            this.addColorfulBlockSetDrops(VACollections.PLUM);
            this.addColorfulBlockSetDrops(VACollections.VIRIDIAN);
            this.addColorfulBlockSetDrops(VACollections.TAN);
            this.addColorfulBlockSetDrops(VACollections.SINOPIA);
            this.addColorfulBlockSetDrops(VACollections.LILAC);
            this.method_45994(VABlocks.STEEL_DOOR, arg_0 -> ((BaseProvider)this).method_46022(arg_0));
            this.method_45994(VABlocks.EXPOSED_STEEL_DOOR, arg_0 -> ((BaseProvider)this).method_46022(arg_0));
            this.method_45994(VABlocks.WEATHERED_STEEL_DOOR, arg_0 -> ((BaseProvider)this).method_46022(arg_0));
            this.method_45994(VABlocks.OXIDIZED_STEEL_DOOR, arg_0 -> ((BaseProvider)this).method_46022(arg_0));
            this.method_45994(VABlocks.WAXED_STEEL_DOOR, arg_0 -> ((BaseProvider)this).method_46022(arg_0));
            this.method_45994(VABlocks.WAXED_EXPOSED_STEEL_DOOR, arg_0 -> ((BaseProvider)this).method_46022(arg_0));
            this.method_45994(VABlocks.WAXED_WEATHERED_STEEL_DOOR, arg_0 -> ((BaseProvider)this).method_46022(arg_0));
            this.method_45994(VABlocks.WAXED_OXIDIZED_STEEL_DOOR, arg_0 -> ((BaseProvider)this).method_46022(arg_0));
            this.method_45994(VABlocks.HORNFELS, block -> this.method_45983((class_2248)block, (class_1935)VABlocks.COBBLED_HORNFELS));
            this.method_45994(VABlocks.BLUESCHIST, block -> this.method_45983((class_2248)block, (class_1935)VABlocks.COBBLED_BLUESCHIST));
            this.method_45994(VABlocks.SYENITE, block -> this.method_45983((class_2248)block, (class_1935)VABlocks.COBBLED_SYENITE));
            this.method_45994(VABlocks.LUMWASP_NEST, block -> this.method_45983((class_2248)block, (class_1935)VABlocks.SILK_BLOCK));
            this.method_45994(VABlocks.GLOWING_SILK, block -> this.method_45983((class_2248)block, (class_1935)VAItems.SILK_THREAD));
            this.method_45994(VABlocks.IOLITE_ORE, block -> this.method_45981((class_2248)block, VAItems.IOLITE));
            this.method_45994(VABlocks.TALL_GREENCAP_MUSHROOMS, block -> this.method_45987((class_2248)block, (class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607));
            this.method_45994(VABlocks.ROCK_SALT_CRYSTAL, block -> this.method_45984((class_2248)block, (class_1935)VAItems.ROCK_SALT, (class_5658)class_44.method_32448((float)2.0f)));
            this.method_45994(VABlocks.ROCK_SALT_ORE, this::rockSaltOreDrops);
            this.method_45994(VABlocks.DEEPSLATE_ROCK_SALT_ORE, this::rockSaltOreDrops);
            this.method_46025(VABlocks.REDSTONE_BRIDGE);
            this.method_45994(VABlocks.SOULBLOOM_LEAVES, block -> this.method_45986(VABlocks.SOULBLOOM_LEAVES, VABlocks.SOULBLOOM_SAPLING, field_40605));
            this.method_45994(VABlocks.WITHERED_LEAVES, block -> this.method_45986(VABlocks.WITHERED_LEAVES, VABlocks.WITHERED_SAPLING, field_40605));
        }
    }
}

