/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.item;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9886;
import org.jetbrains.annotations.Nullable;

public class GildType {
    public static final class_2960 GILDED_TOOL_BLOCK_INTERACTION_RANGE_MODIFIER_ID = VirtualAdditions.idOf("gilded_tool_block_interaction_range");
    public static final class_2960 GILDED_TOOL_ENTITY_INTERACTION_RANGE_MODIFIER_ID = VirtualAdditions.idOf("gilded_tool_entity_interaction_range");
    private final ArrayList<Modifier> modifiers = new ArrayList();
    private final class_2960 id;
    private final int color;
    private class_6862<class_1792> tag;
    private class_6862<class_1792> axesTag;
    private class_6862<class_1792> hoesTag;
    private class_6862<class_1792> pickaxesTag;
    private class_6862<class_1792> shovelsTag;
    private class_6862<class_1792> swordsTag;
    private class_6862<class_1792> halberdsTag;

    public GildType(class_2960 id, int color, Modifier ... modifiers) {
        this.id = id;
        this.color = color;
        this.modifiers.addAll(Arrays.asList(modifiers));
    }

    public boolean isGildEffective(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_1799 tool) {
        return tool.method_7951(state);
    }

    public void emitBlockBreakingEffects(class_1937 world, class_1657 player, class_2338 pos, class_1799 tool) {
    }

    public boolean onBlockBroken(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_1799 tool) {
        return true;
    }

    public boolean hasHitEffects() {
        return false;
    }

    public void applyEffectsOnHit(class_1937 world, class_1309 target, class_1309 attacker) {
    }

    public final ModifiedToolMaterial getModifiedMaterial(class_9886 baseMaterial) {
        return new ModifiedToolMaterial(baseMaterial, this.modifiers);
    }

    public class_9285 createAttributeModifiers(class_1792 baseItem) {
        class_9285.class_9286 builder;
        class_9285.class_9286 builderCopy = builder = class_9285.method_57480();
        ((class_9285)baseItem.method_57347().method_58694(class_9334.field_49636)).comp_2393().forEach(entry -> {
            class_1322 modifier = entry.comp_2396();
            if (entry.comp_2395().equals((Object)class_5134.field_23723) || entry.comp_2395().equals((Object)class_5134.field_23721)) {
                double[] value = new double[]{modifier.comp_2449()};
                this.modifiers.forEach(gildModifier -> {
                    if (gildModifier.modifiesAttribute((class_6880<class_1320>)entry.comp_2395()) && gildModifier.shouldApplyToTool(baseItem)) {
                        value[0] = gildModifier.apply((float)value[0]);
                    }
                });
                modifier = new class_1322(entry.comp_2396().comp_2447(), value[0], modifier.comp_2450());
            }
            builderCopy.method_57487(entry.comp_2395(), modifier, entry.comp_2397());
        });
        builder = this.appendAttributeModifiers(builderCopy, baseItem);
        return builder.method_57486();
    }

    public final class_9285.class_9286 appendAttributeModifiers(class_9285.class_9286 builder, class_1792 baseItem) {
        this.modifiers.forEach(modifier -> {
            if (!modifier.shouldBeAppended() || !modifier.shouldApplyToTool(baseItem)) {
                return;
            }
            class_6880<class_1320> attribute = modifier.type.getAttributeType();
            if (attribute != null) {
                builder.method_57487(attribute, new class_1322(modifier.id, (double)modifier.value, class_1322.class_1323.field_6328), class_9274.field_49217);
            }
        });
        return builder;
    }

    public final String buildTooltipTranslationKey() {
        return "gild_type." + this.id.method_12836() + "." + this.id.method_12832();
    }

    public int getColor() {
        return this.color;
    }

    public class_2960 getId() {
        return this.id;
    }

    private boolean shouldModifyBaseMaterial() {
        for (Modifier modifier : this.modifiers) {
            if (!modifier.type.modifiesBaseMaterial) continue;
            return true;
        }
        return false;
    }

    public class_6862<class_1792> getTag() {
        if (this.tag == null) {
            class_2960 id = this.id.method_48331("_gilded_tools");
            this.tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
        }
        return this.tag;
    }

    public class_6862<class_1792> getAxesTag() {
        if (this.axesTag == null) {
            class_2960 id = this.id.method_48331("_gilded_axes");
            this.axesTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
        }
        return this.axesTag;
    }

    public class_6862<class_1792> getHoesTag() {
        if (this.hoesTag == null) {
            class_2960 id = this.id.method_48331("_gilded_hoes");
            this.hoesTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
        }
        return this.hoesTag;
    }

    public class_6862<class_1792> getPickaxesTag() {
        if (this.pickaxesTag == null) {
            class_2960 id = this.id.method_48331("_gilded_pickaxes");
            this.pickaxesTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
        }
        return this.pickaxesTag;
    }

    public class_6862<class_1792> getShovelsTag() {
        if (this.shovelsTag == null) {
            class_2960 id = this.id.method_48331("_gilded_shovels");
            this.shovelsTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
        }
        return this.shovelsTag;
    }

    public class_6862<class_1792> getSwordsTag() {
        if (this.swordsTag == null) {
            class_2960 id = this.id.method_48331("_gilded_swords");
            this.swordsTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
        }
        return this.swordsTag;
    }

    public class_6862<class_1792> getHalberdsTag() {
        if (this.halberdsTag == null) {
            class_2960 id = this.id.method_48331("_gilded_halberds");
            this.halberdsTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
        }
        return this.halberdsTag;
    }

    public final boolean equals(Object obj) {
        class_2960 identifier;
        GildType gildType;
        return obj instanceof GildType && (gildType = (GildType)obj).getId().equals((Object)this.id) || obj instanceof class_2960 && (identifier = (class_2960)obj).equals((Object)this.id);
    }

    public String toString() {
        return this.id.toString();
    }

    public static class ModifiedToolMaterial {
        private final class_9886 baseMaterial;
        private final class_6862<class_2248> inverseTag;
        private int itemDurability;
        private float miningSpeed;
        private float attackDamageBonus;
        private int enchantability;
        private float blockInteractionRange = 0.0f;
        private float entityInteractionRange = 0.0f;
        private float attackSpeed = 0.0f;
        private final class_6862<class_1792> repairItems;

        public ModifiedToolMaterial(class_9886 baseMaterial, List<Modifier> modifiers) {
            this.baseMaterial = baseMaterial;
            this.inverseTag = baseMaterial.comp_2930();
            this.itemDurability = baseMaterial.comp_2931();
            this.miningSpeed = baseMaterial.comp_2932();
            this.attackDamageBonus = baseMaterial.comp_2933();
            this.enchantability = baseMaterial.comp_2934();
            this.repairItems = baseMaterial.comp_2935();
            this.applyModifiers(modifiers);
        }

        private void applyModifiers(List<Modifier> modifiers) {
            modifiers.forEach(modifier -> {
                switch (modifier.type().ordinal()) {
                    case 0: {
                        this.itemDurability = modifier.apply(this.itemDurability);
                        break;
                    }
                    case 1: {
                        this.miningSpeed = modifier.apply(this.miningSpeed);
                        break;
                    }
                    case 2: {
                        this.attackDamageBonus = modifier.apply(this.attackDamageBonus);
                        break;
                    }
                    case 3: {
                        this.enchantability = modifier.apply(this.enchantability);
                        break;
                    }
                    case 5: {
                        this.blockInteractionRange = modifier.apply(this.blockInteractionRange);
                        break;
                    }
                    case 6: {
                        this.entityInteractionRange = modifier.apply(this.entityInteractionRange);
                        break;
                    }
                    case 4: {
                        this.attackSpeed = modifier.apply(this.attackSpeed);
                    }
                }
            });
        }

        public class_9886 asToolMaterial() {
            return new class_9886(this.inverseTag, this.itemDurability, this.miningSpeed, this.attackDamageBonus, this.enchantability, this.repairItems);
        }

        public class_9886 getBaseMaterial() {
            return this.baseMaterial;
        }

        private class_1792.class_1793 applyBaseSettings(class_1792.class_1793 settings) {
            return settings.method_7895(this.itemDurability).method_61647(this.repairItems).method_61649(this.enchantability);
        }

        public class_1792.class_1793 applyToolSettings(class_1792.class_1793 settings, class_6862<class_2248> effectiveBlocks, float attackDamage, float attackSpeed, boolean breaksShield) {
            class_7871 registryEntryLookup = class_7923.method_62715((class_2378)class_7923.field_41175);
            return this.applyBaseSettings(settings).method_57349(class_9334.field_50077, (Object)new class_9424(List.of(class_9424.class_9425.method_58427((class_6885)registryEntryLookup.method_46735(this.baseMaterial.comp_2930())), class_9424.class_9425.method_58431((class_6885)registryEntryLookup.method_46735(effectiveBlocks), (float)this.miningSpeed)), 1.0f, 1, breaksShield)).method_57348(this.createToolAttributeModifiers(attackDamage, attackSpeed));
        }

        private class_9285 createToolAttributeModifiers(float attackDamage, float attackSpeed) {
            class_9285.class_9286 builder = class_9285.method_57480();
            builder.method_57487(class_5134.field_23721, new class_1322(class_1792.field_8006, (double)(attackDamage + this.attackDamageBonus), class_1322.class_1323.field_6328), class_9274.field_49217);
            builder.method_57487(class_5134.field_23723, new class_1322(class_1792.field_8001, (double)(attackSpeed + this.attackSpeed), class_1322.class_1323.field_6328), class_9274.field_49217);
            if (this.blockInteractionRange != 0.0f) {
                builder.method_57487(class_5134.field_47758, new class_1322(GILDED_TOOL_BLOCK_INTERACTION_RANGE_MODIFIER_ID, (double)this.blockInteractionRange, class_1322.class_1323.field_6328), class_9274.field_49217);
            }
            if (this.entityInteractionRange != 0.0f) {
                builder.method_57487(class_5134.field_47759, new class_1322(GILDED_TOOL_ENTITY_INTERACTION_RANGE_MODIFIER_ID, (double)this.entityInteractionRange, class_1322.class_1323.field_6328), class_9274.field_49217);
            }
            return builder.method_57486();
        }
    }

    public record Modifier(class_2960 id, ModifierType type, float value, BiFunction<Float, Float, Float> function, ModifierType.ToolType[] appliesTo) {
        public float apply(float f) {
            return this.function.apply(Float.valueOf(f), Float.valueOf(this.value)).floatValue();
        }

        public int apply(int i) {
            return Math.round(this.function.apply(Float.valueOf(i), Float.valueOf(this.value)).floatValue());
        }

        public float apply(float f, class_1792 baseItem) {
            return this.shouldApplyToTool(baseItem) ? this.apply(f) : f;
        }

        public int apply(int i, class_1792 baseItem) {
            return this.shouldApplyToTool(baseItem) ? this.apply(i) : i;
        }

        public boolean shouldApplyToTool(class_1792 item) {
            if (this.appliesTo.length == 0) {
                return true;
            }
            for (ModifierType.ToolType type : this.appliesTo) {
                if (!type.matches(item)) continue;
                return true;
            }
            return false;
        }

        public boolean shouldBeAppended() {
            return this.type.shouldBeAppended();
        }

        public boolean modifiesAttribute(class_6880<class_1320> attribute) {
            return this.type.getAttributeType() != null && this.type.getAttributeType().equals(attribute);
        }
    }

    protected static enum ModifierType {
        DURABILITY,
        MINING_SPEED,
        ATTACK_DAMAGE,
        ENCHANTABILITY,
        ATTACK_SPEED(false),
        BLOCK_INTERACTION_RANGE(false),
        ENTITY_INTERACTION_RANGE(false);

        private final boolean modifiesBaseMaterial;

        private ModifierType(boolean modifiesBaseMaterial) {
            this.modifiesBaseMaterial = modifiesBaseMaterial;
        }

        @Nullable
        public class_6880<class_1320> getAttributeType() {
            return switch (this.ordinal()) {
                case 5 -> class_5134.field_47758;
                case 6 -> class_5134.field_47759;
                case 4 -> class_5134.field_23723;
                case 2 -> class_5134.field_23721;
                default -> null;
            };
        }

        public UUID getAttributeId() {
            return switch (this.ordinal()) {
                case 5 -> UUID.fromString("C39B0D39-EB64-45E9-A58E-52DA390DD1A2");
                case 6 -> UUID.fromString("D4786B0F-DF61-45D8-B77C-E5B55C4F4066");
                case 4 -> UUID.fromString("68701EAF-5C43-42E8-95F0-BAA0E3E2438A");
                case 2 -> UUID.fromString("F09A0E0B-32E7-407C-A4E6-17E9F5EB9C2B");
                default -> UUID.fromString("0-0-0-0-0");
            };
        }

        public boolean shouldBeAppended() {
            return !this.equals((Object)ATTACK_SPEED) && !this.equals((Object)ATTACK_DAMAGE);
        }

        private ModifierType() {
            this.modifiesBaseMaterial = true;
        }

        protected static enum ToolType {
            SWORD,
            SHOVEL,
            PICKAXE,
            AXE,
            HOE,
            HALBERD;


            public boolean matches(class_1792 item) {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> class_7923.field_41178.method_10221((Object)item).method_12832().contains("sword");
                    case 1 -> item instanceof class_1821;
                    case 2 -> class_7923.field_41178.method_10221((Object)item).method_12832().contains("pickaxe");
                    case 3 -> item instanceof class_1743;
                    case 4 -> item instanceof class_1794;
                    case 5 -> class_7923.field_41178.method_10221((Object)item).method_12832().contains("halberd");
                };
            }
        }
    }
}

