/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.item;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.block.DestructiveSculkBlock;
import com.github.suninvr.virtualadditions.item.GildType;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VAGameRules;
import com.github.suninvr.virtualadditions.registry.VAStatusEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2431;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;

public class GildTypes {
    private static final BiFunction<Float, Float, Float> ADD = Float::sum;
    private static final BiFunction<Float, Float, Float> MULTIPLY = (attribute, modifier) -> Float.valueOf(attribute.floatValue() * modifier.floatValue());
    private static final BiFunction<Float, Float, Float> MULTIPLY_ROUNDED_TENTHS = (attribute, modifier) -> Float.valueOf((float)Math.round(10.0f * (attribute.floatValue() * modifier.floatValue())) / 10.0f);
    public static final GildType AMETHYST = new GildType(VirtualAdditions.idOf("amethyst"), 10116294, GildTypes.miningSpeedModifier(1.0f, ADD, new GildType.ModifierType.ToolType[0]), GildTypes.attackSpeedModifier(0.9f, MULTIPLY_ROUNDED_TENTHS, GildType.ModifierType.ToolType.SWORD, GildType.ModifierType.ToolType.AXE), GildTypes.attackSpeedModifier(0.95f, MULTIPLY_ROUNDED_TENTHS, GildType.ModifierType.ToolType.HALBERD));
    public static final GildType COPPER = new GildType(VirtualAdditions.idOf("copper"), 11823181, GildTypes.durabilityModifier(1.5f, MULTIPLY, new GildType.ModifierType.ToolType[0]));
    public static final GildType EMERALD = new GildType(VirtualAdditions.idOf("emerald"), 1155126, new GildType.Modifier[]{GildTypes.enchantabilityModifier(1.5f, MULTIPLY, new GildType.ModifierType.ToolType[0])}){

        @Override
        public boolean isGildEffective(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_1799 tool) {
            return super.isGildEffective(world, player, pos, state, tool) && state.method_26204() instanceof class_2431;
        }
    };
    public static final GildType IOLITE = new GildType(VirtualAdditions.idOf("iolite"), 7351295, GildTypes.blockInteractionRangeModifier(3.0f, ADD, new GildType.ModifierType.ToolType[0]), GildTypes.entityInteractionRangeModifier(0.5f, ADD, new GildType.ModifierType.ToolType[0]));
    public static final GildType QUARTZ = new GildType(VirtualAdditions.idOf("quartz"), 14931140, GildTypes.attackDamageModifier(2.0f, ADD, new GildType.ModifierType.ToolType[0]));
    public static final GildType SCULK = new GildType(VirtualAdditions.idOf("sculk"), 37525, new GildType.Modifier[]{GildTypes.miningSpeedModifier(0.4f, MULTIPLY, new GildType.ModifierType.ToolType[0]), GildTypes.attackSpeedModifier(1.2f, MULTIPLY_ROUNDED_TENTHS, GildType.ModifierType.ToolType.SWORD), GildTypes.attackDamageModifier(0.5f, MULTIPLY_ROUNDED_TENTHS, new GildType.ModifierType.ToolType[0])}){

        @Override
        public boolean isGildEffective(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_1799 tool) {
            return !player.method_7357().method_7904(tool) && !state.method_27852(VABlocks.DESTRUCTIVE_SCULK) && state.method_26214((class_1922)world, pos) > 0.0f && world.method_8321(pos) == null && super.isGildEffective(world, player, pos, state, tool);
        }

        @Override
        public void emitBlockBreakingEffects(class_1937 world, class_1657 player, class_2338 pos, class_1799 tool) {
            world.method_8396(null, pos, class_3417.field_37357, class_3419.field_15245, 1.0f, 1.0f);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199((class_2394)class_2398.field_38004, false, false, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 50, 0.4, 0.4, 0.4, 0.02);
            }
        }

        @Override
        public boolean onBlockBroken(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_1799 tool) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                double miningEfficiency = player.method_45325(class_5134.field_51581);
                int potency = (int)(48.0f / state.method_26214((class_1922)world, pos));
                potency += (int)((double)potency * (miningEfficiency / 13.0));
                potency = Math.min(Math.min(tool.method_7936() - tool.method_7919(), potency) - 1, serverWorld.method_64395().method_8356(VAGameRules.SCULK_GILD_BLOCK_SELECTION_MAXIMUM));
                if (potency <= 0) {
                    return true;
                }
                List<class_2338> posList = 2.selectPositions(world, pos, state, potency);
                DestructiveSculkBlock.placeState(world, pos, state, player.method_5667(), tool, potency);
                int i = posList.size();
                tool.method_7970(i, (class_1309)player, class_1304.field_6173);
                player.method_7357().method_62835(tool, (int)((double)i / (miningEfficiency / 20.0 + 1.0)));
            }
            return false;
        }

        @Override
        public boolean hasHitEffects() {
            return true;
        }

        @Override
        public void applyEffectsOnHit(class_1937 world, class_1309 target, class_1309 attacker) {
            if (!target.method_6059(VAStatusEffects.FESTERING_WOUNDS)) {
                world.method_8396((class_1297)target, target.method_24515(), class_3417.field_37357, target.method_5634(), 1.5f, 1.0f);
            }
            target.method_37222(new class_1293(VAStatusEffects.FESTERING_WOUNDS, 400), (class_1297)attacker);
        }

        private static List<class_2338> selectPositions(class_1937 world, class_2338 pos, class_2680 state, int i) {
            ArrayList<class_2338> activeList = new ArrayList<class_2338>();
            ArrayList<class_2338> finalList = new ArrayList<class_2338>();
            activeList.add(pos);
            finalList.add(pos);
            while (i > 0 && !activeList.isEmpty()) {
                class_2338 checkAroundPos = (class_2338)activeList.getFirst();
                for (class_2350 dir : class_2350.values()) {
                    class_2338 checkAtPos = checkAroundPos.method_10093(dir);
                    if (!finalList.contains(checkAtPos) && world.method_8320(checkAtPos).method_26204().equals(state.method_26204())) {
                        --i;
                        activeList.add(checkAtPos);
                        finalList.add(checkAtPos);
                    }
                    for (class_2350 dirEdge : class_2350.values()) {
                        if (dirEdge.method_10166().equals((Object)dir.method_10166()) || finalList.contains(checkAtPos = checkAroundPos.method_10093(dir).method_10093(dirEdge)) || !world.method_8320(checkAtPos).method_26204().equals(state.method_26204())) continue;
                        --i;
                        activeList.add(checkAtPos);
                        finalList.add(checkAtPos);
                    }
                }
                activeList.removeFirst();
            }
            return finalList;
        }
    };
    public static final GildType NONE = new GildType(VirtualAdditions.idOf("none"), 0xFFFFFF, new GildType.Modifier[0]);

    public static GildType.Modifier durabilityModifier(float value, BiFunction<Float, Float, Float> function, GildType.ModifierType.ToolType ... appliesTo) {
        return new GildType.Modifier(VirtualAdditions.idOf("gild_durability_modifier"), GildType.ModifierType.DURABILITY, value, function, appliesTo);
    }

    public static GildType.Modifier miningSpeedModifier(float value, BiFunction<Float, Float, Float> function, GildType.ModifierType.ToolType ... appliesTo) {
        return new GildType.Modifier(VirtualAdditions.idOf("gild_mining_speed_modifier"), GildType.ModifierType.MINING_SPEED, value, function, appliesTo);
    }

    public static GildType.Modifier attackDamageModifier(float value, BiFunction<Float, Float, Float> function, GildType.ModifierType.ToolType ... appliesTo) {
        return new GildType.Modifier(VirtualAdditions.idOf("gild_attack_damage_modifier"), GildType.ModifierType.ATTACK_DAMAGE, value, function, appliesTo);
    }

    public static GildType.Modifier enchantabilityModifier(float value, BiFunction<Float, Float, Float> function, GildType.ModifierType.ToolType ... appliesTo) {
        return new GildType.Modifier(VirtualAdditions.idOf("gild_enchantability_modifier"), GildType.ModifierType.ENCHANTABILITY, value, function, appliesTo);
    }

    public static GildType.Modifier attackSpeedModifier(float value, BiFunction<Float, Float, Float> function, GildType.ModifierType.ToolType ... appliesTo) {
        return new GildType.Modifier(VirtualAdditions.idOf("gild_attack_speed_modifier"), GildType.ModifierType.ATTACK_SPEED, value, function, appliesTo);
    }

    public static GildType.Modifier blockInteractionRangeModifier(float value, BiFunction<Float, Float, Float> function, GildType.ModifierType.ToolType ... appliesTo) {
        return new GildType.Modifier(VirtualAdditions.idOf("gild_block_interaction_range_modifier"), GildType.ModifierType.BLOCK_INTERACTION_RANGE, value, function, appliesTo);
    }

    public static GildType.Modifier entityInteractionRangeModifier(float value, BiFunction<Float, Float, Float> function, GildType.ModifierType.ToolType ... appliesTo) {
        return new GildType.Modifier(VirtualAdditions.idOf("gild_entity_interaction_range_modifier"), GildType.ModifierType.ENTITY_INTERACTION_RANGE, value, function, appliesTo);
    }
}

