/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.item;

import com.github.suninvr.virtualadditions.component.EffectsOnHitComponent;
import com.github.suninvr.virtualadditions.item.GildType;
import com.github.suninvr.virtualadditions.item.GildTypes;
import com.github.suninvr.virtualadditions.item.GildedToolUtil;
import com.github.suninvr.virtualadditions.registry.VABlockTags;
import com.github.suninvr.virtualadditions.registry.VADataComponentTypes;
import com.github.suninvr.virtualadditions.registry.VAEnchantmentEffects;
import com.github.suninvr.virtualadditions.registry.VASoundEvents;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8168;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class HalberdItem
extends class_1792 {
    public HalberdItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            float readiness = HalberdItem.getSwingReadiness(stack, user, remainingUseTicks);
            if ((double)readiness >= 0.25) {
                this.swingAttack(stack, world, player, readiness);
            }
        }
        return false;
    }

    private void swingAttack(class_1799 stack, class_1937 world, class_1657 player, float readiness) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            boolean vertical = player.method_36455() >= 60.0f || player.method_36455() <= -60.0f;
            boolean hasAppliedPotion = stack.method_57826(VADataComponentTypes.EFFECTS_ON_HIT);
            GildType gildType = GildedToolUtil.getGildType(stack);
            List playerMounts = player.method_5668().method_5685();
            MutableInt entitiesHit = new MutableInt(0);
            class_243 playerRotation = player.method_5720();
            class_243 center = player.method_33571().method_1019(playerRotation.method_1021(2.0));
            class_238 box = !vertical ? new class_238(center.method_1031(-2.0, -1.0, -2.0), center.method_1031(2.0, 1.0, 2.0)) : new class_238(center.method_1031(-1.0, -2.0, -1.0), center.method_1031(1.0, 2.0, 1.0));
            MutableFloat lungePower = new MutableFloat(0.0f);
            class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60506(VAEnchantmentEffects.HALBERD_LUNGE_COMPONENT, player.method_59922(), level, lungePower));
            serverWorld.method_18467(class_1309.class, box).stream().filter(livingEntity -> livingEntity != player.method_5668() && !playerMounts.contains(livingEntity)).forEach(target -> {
                float startingHealth = target.method_6032();
                class_1282 source = player.method_48923().method_48802(player);
                float damage = class_1890.method_60120((class_3218)serverWorld, (class_1799)stack, (class_1297)target, (class_1282)source, (float)((float)(player.method_45325(class_5134.field_23721) * (double)readiness * 0.75)));
                target.method_64397(serverWorld, source, damage);
                float knockback = player.method_59924((class_1297)target, source) + 0.5f * readiness;
                if (knockback > 0.0f) {
                    target.method_6005((double)(knockback + lungePower.floatValue() * 1.5f), player.method_23317() - target.method_23317(), player.method_23321() - target.method_23321());
                }
                if (hasAppliedPotion) {
                    ((EffectsOnHitComponent)stack.method_58694(VADataComponentTypes.EFFECTS_ON_HIT)).forEachEffect(statusEffectInstance -> target.method_37222(statusEffectInstance, (class_1297)player));
                }
                if (gildType.hasHitEffects()) {
                    gildType.applyEffectsOnHit(world, (class_1309)target, (class_1309)player);
                }
                entitiesHit.increment();
                player.method_7339(class_3468.field_15399, Math.round((startingHealth - target.method_6032()) * 10.0f));
            });
            class_2338.method_29715((class_238)(vertical ? box.method_1009(0.0, -1.0, 0.0) : box.method_1009(-1.0, 0.0, -1.0))).forEach(pos -> {
                if (HalberdItem.tryBreakState(serverWorld, pos, player)) {
                    stack.method_71012(1, (class_1309)player, player.method_6058());
                }
            });
            if (entitiesHit.getValue() > 0) {
                if (hasAppliedPotion) {
                    stack.method_57379(VADataComponentTypes.EFFECTS_ON_HIT, (Object)((EffectsOnHitComponent)stack.method_58694(VADataComponentTypes.EFFECTS_ON_HIT)).decrementRemainingUses());
                }
                stack.method_71012(1, (class_1309)player, player.method_6058());
                if (readiness >= 1.0f) {
                    serverWorld.method_43129(null, (class_1297)player, class_3417.field_15016, class_3419.field_15248, 1.0f, 1.0f);
                } else {
                    serverWorld.method_43129(null, (class_1297)player, class_3417.field_14625, class_3419.field_15248, 1.0f, 1.0f);
                }
            }
            world.method_43275((class_1297)player, (class_6880)class_5712.field_28146, player.method_73189());
            player.method_7322(0.1f + 0.05f * (float)entitiesHit.getValue().intValue());
            serverWorld.method_43129(null, (class_1297)player, VASoundEvents.ITEM_HALBERD_SWING, class_3419.field_15248, 1.0f, 1.0f);
            class_243 vec3d = player.method_33571().method_1019(playerRotation);
            HalberdItem.applyPlayerMovement(player, stack, entitiesHit.getValue(), lungePower.floatValue());
            serverWorld.method_14199((class_2394)class_2398.field_11227, false, true, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            if (readiness >= 1.0f) {
                if (vertical) {
                    serverWorld.method_14199((class_2394)class_2398.field_11205, false, true, center.field_1352, center.field_1351, center.field_1350, 25, 0.25, 1.25, 0.25, 0.25);
                } else {
                    serverWorld.method_14199((class_2394)class_2398.field_11205, false, true, center.field_1352, center.field_1351, center.field_1350, 25, 1.25, 0.125, 1.25, 0.25);
                }
            }
        }
        player.method_7357().method_62835(stack, (int)HalberdItem.getSwingCooldown(stack, (class_1309)player));
        player.method_23667(player.method_6058(), true);
        player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        player.method_7350();
    }

    private static void applyPlayerMovement(class_1657 player, class_1799 stack, int entitiesHit, float lungePower) {
        if (player.method_5765() || player.method_6128() || player.method_31549().field_7479) {
            return;
        }
        if (lungePower > 0.0f) {
            player.method_18799(new class_243((double)class_3532.method_15374((float)((player.method_36454() + 180.0f) * ((float)Math.PI / 180))), Math.min(0.4, player.method_18798().field_1351 * 0.75 + (double)lungePower), (double)(-class_3532.method_15362((float)((player.method_36454() + 180.0f) * ((float)Math.PI / 180))))).method_1021(entitiesHit > 0 ? (double)lungePower * 0.5 : (double)lungePower));
            player.field_6037 = true;
            stack.method_71012(1, (class_1309)player, player.method_6058());
        } else if (entitiesHit > 0) {
            player.method_6005((double)0.333f, (double)class_3532.method_15374((float)((player.method_36454() - 180.0f) * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)((player.method_36454() - 180.0f) * ((float)Math.PI / 180)))));
            player.field_6037 = true;
        }
    }

    public static float getSwingReadiness(class_1799 stack, class_1309 user, int remainingUseTicks) {
        return HalberdItem.getSwingReadiness(stack, user, remainingUseTicks, 0.0f);
    }

    public static float getSwingReadiness(class_1799 stack, class_1309 user, int remainingUseTicks, float tickProgress) {
        if (!(stack.method_7909() instanceof HalberdItem)) {
            return 0.0f;
        }
        float f = HalberdItem.getMaxReadiness(stack, user);
        if (f <= 0.0f) {
            return 1.0f;
        }
        float g = Math.min((float)stack.method_7909().method_7881(stack, user) - ((float)remainingUseTicks - tickProgress), (float)((int)f));
        return g / f;
    }

    public static float getMaxReadiness(class_1799 stack, class_1309 user) {
        MutableFloat mutableFloat = new MutableFloat(30.0f);
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60506(VAEnchantmentEffects.HALBERD_READINESS_TIME_COMPONENT, user.method_59922(), level, mutableFloat));
        return mutableFloat.floatValue();
    }

    private static boolean tryBreakState(class_3218 world, class_2338 pos, class_1657 player) {
        if (player.method_21701((class_1937)world, pos, player.method_68876())) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        if (!state.method_26164(VABlockTags.HALBERD_SWING_BREAKABLES)) {
            return false;
        }
        if (state.method_26204() instanceof class_2397 && ((Boolean)state.method_11654((class_2769)class_2397.field_11200)).booleanValue()) {
            return false;
        }
        if (state.method_27852(class_2246.field_42752)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_8168.field_43237, (Comparable)Boolean.valueOf(true)), 260);
        }
        world.method_8651(pos, !player.method_66324(), (class_1297)player);
        return state.method_26214((class_1922)world, pos) > 0.0f;
    }

    private static float getSwingCooldown(class_1799 stack, class_1309 entity) {
        MutableFloat mutableFloat = new MutableFloat(40.0f);
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60506(VAEnchantmentEffects.HALBERD_SWING_COOLDOWN_COMPONENT, entity.method_59922(), level, mutableFloat));
        if (GildedToolUtil.getGildType(stack).equals(GildTypes.AMETHYST)) {
            mutableFloat.add(-10.0f);
        }
        if (mutableFloat.floatValue() <= 0.0f) {
            return 0.0f;
        }
        return mutableFloat.floatValue();
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        class_1799 stack = user.method_5998(hand);
        if (HalberdItem.getMaxReadiness(stack, (class_1309)user) <= 0.0f) {
            this.swingAttack(stack, world, user, 1.0f);
            return class_1269.field_5812;
        }
        user.method_6019(hand);
        return class_1269.field_21466;
    }
}

