/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.registry.collection;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_2248;

public class ColorfulBlockSet {
    private final Map<Tile, class_2248> blockMap;
    private final class_1769 dye;

    private ColorfulBlockSet(class_1769 dye, TileBlockPair ... entries) {
        this.blockMap = Map.ofEntries(entries);
        this.dye = dye;
    }

    public class_1769 dye() {
        return this.dye;
    }

    public class_2248 wool() {
        return this.blockMap.get((Object)Tile.WOOL);
    }

    public void ifWool(Consumer<class_2248> consumer) {
        class_2248 block = this.wool();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 carpet() {
        return this.blockMap.get((Object)Tile.CARPET);
    }

    public void ifCarpet(Consumer<class_2248> consumer) {
        class_2248 block = this.carpet();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 terracotta() {
        return this.blockMap.get((Object)Tile.TERRACOTTA);
    }

    public void ifTerracotta(Consumer<class_2248> consumer) {
        class_2248 block = this.terracotta();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 glazedTerracotta() {
        return this.blockMap.get((Object)Tile.GLAZED_TERRACOTTA);
    }

    public void ifGlazedTerracotta(Consumer<class_2248> consumer) {
        class_2248 block = this.glazedTerracotta();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 concrete() {
        return this.blockMap.get((Object)Tile.CONCRETE);
    }

    public void ifConcrete(Consumer<class_2248> consumer) {
        class_2248 block = this.concrete();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 concretePowder() {
        return this.blockMap.get((Object)Tile.CONCRETE_POWDER);
    }

    public void ifConcretePowder(Consumer<class_2248> consumer) {
        class_2248 block = this.concretePowder();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 stainedGlass() {
        return this.blockMap.get((Object)Tile.STAINED_GLASS);
    }

    public void ifStainedGlass(Consumer<class_2248> consumer) {
        class_2248 block = this.stainedGlass();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 stainedGlassPane() {
        return this.blockMap.get((Object)Tile.STAINED_GLASS_PANE);
    }

    public void ifStainedGlassPane(Consumer<class_2248> consumer) {
        class_2248 block = this.stainedGlassPane();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 candle() {
        return this.blockMap.get((Object)Tile.CANDLE);
    }

    public void ifCandle(Consumer<class_2248> consumer) {
        class_2248 block = this.candle();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 candleCake() {
        return this.blockMap.get((Object)Tile.CANDLE_CAKE);
    }

    public void ifCandleCake(Consumer<class_2248> consumer) {
        class_2248 block = this.candleCake();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 silkbulb() {
        return this.blockMap.get((Object)Tile.SILKBULB);
    }

    public void ifSilkbulb(Consumer<class_2248> consumer) {
        class_2248 block = this.silkbulb();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 bed() {
        return this.blockMap.get((Object)Tile.BED);
    }

    public void ifBed(Consumer<class_2248> consumer) {
        class_2248 block = this.bed();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 shulkerBox() {
        return this.blockMap.get((Object)Tile.SHULKER_BOX);
    }

    public void ifShulkerBox(Consumer<class_2248> consumer) {
        class_2248 block = this.shulkerBox();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 banner() {
        return this.blockMap.get((Object)Tile.BANNER);
    }

    public void ifBanner(Consumer<class_2248> consumer) {
        class_2248 block = this.banner();
        if (block != null) {
            consumer.accept(block);
        }
    }

    public class_2248 wallBanner() {
        return this.blockMap.get((Object)Tile.WALL_BANNER);
    }

    public void ifWallBanner(Consumer<class_2248> consumer) {
        class_2248 block = this.wallBanner();
        if (block != null) {
            consumer.accept(block);
        }
    }

    private static enum Tile {
        WOOL,
        CARPET,
        TERRACOTTA,
        GLAZED_TERRACOTTA,
        CONCRETE,
        CONCRETE_POWDER,
        STAINED_GLASS,
        STAINED_GLASS_PANE,
        CANDLE,
        CANDLE_CAKE,
        SILKBULB,
        BED,
        SHULKER_BOX,
        BANNER,
        WALL_BANNER;

    }

    private static class TileBlockPair
    implements Map.Entry<Tile, class_2248> {
        public final Tile tile;
        public final class_2248 block;

        protected TileBlockPair(Tile tile, class_2248 block) {
            this.tile = tile;
            this.block = block;
        }

        public static TileBlockPair of(Tile tile, class_2248 block) {
            return new TileBlockPair(tile, block);
        }

        @Override
        public Tile getKey() {
            return this.tile;
        }

        @Override
        public class_2248 getValue() {
            return this.block;
        }

        @Override
        public class_2248 setValue(class_2248 value) {
            return this.block;
        }
    }

    public static class Builder {
        private final ArrayList<TileBlockPair> entries = new ArrayList();
        private final class_1792 dye;

        private Builder(class_1792 dye) {
            this.dye = dye;
        }

        public static Builder create(class_1792 dye) {
            return new Builder(dye);
        }

        public ColorfulBlockSet build() {
            return new ColorfulBlockSet((class_1769)this.dye, this.entries.toArray(new TileBlockPair[0]));
        }

        public Builder wool(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.WOOL, block));
            return this;
        }

        public Builder carpet(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.CARPET, block));
            return this;
        }

        public Builder terracotta(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.TERRACOTTA, block));
            return this;
        }

        public Builder glazedTerracotta(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.GLAZED_TERRACOTTA, block));
            return this;
        }

        public Builder concrete(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.CONCRETE, block));
            return this;
        }

        public Builder concretePowder(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.CONCRETE_POWDER, block));
            return this;
        }

        public Builder stainedGlass(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.STAINED_GLASS, block));
            return this;
        }

        public Builder stainedGlassPane(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.STAINED_GLASS_PANE, block));
            return this;
        }

        public Builder candle(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.CANDLE, block));
            return this;
        }

        public Builder candleCake(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.CANDLE_CAKE, block));
            return this;
        }

        public Builder silkbulb(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.SILKBULB, block));
            return this;
        }

        public Builder bed(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.BED, block));
            return this;
        }

        public Builder shulkerBox(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.SHULKER_BOX, block));
            return this;
        }

        public Builder banner(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.BANNER, block));
            return this;
        }

        public Builder wallBanner(class_2248 block) {
            this.entries.add(TileBlockPair.of(Tile.WALL_BANNER, block));
            return this;
        }
    }
}

