/*
 * Decompiled with CFR 0.152.
 */
package com.github.suninvr.virtualadditions.worldgen.feature;

import com.github.suninvr.virtualadditions.block.LumwaspNestBlock;
import com.github.suninvr.virtualadditions.registry.VABlockTags;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.mojang.serialization.Codec;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class LumwaspNestFeature
extends class_3031<class_3111> {
    private static final class_2680 SILK_BLOCK = VABlocks.SILK_BLOCK.method_9564();
    private static final class_2680 NEST = VABlocks.LUMWASP_NEST.method_9564();
    private static final class_2680 NEST_LARVAE = (class_2680)VABlocks.LUMWASP_NEST.method_9564().method_11657((class_2769)LumwaspNestBlock.LARVAE, (Comparable)Boolean.valueOf(true));
    private static final class_2680 ACID = VABlocks.ACID.method_9564();
    private static final class_2680 ACID_BLOCK = VABlocks.ACID_BLOCK.method_9564();
    private static final class_2680 GLOWING_SILK = VABlocks.GLOWING_SILK.method_9564();
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    public LumwaspNestFeature(Codec<class_3111> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        boolean canPlaceLarge;
        boolean large;
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        boolean bl = large = random.method_43048(4) == 1;
        if (!this.isValidSpace(world, origin, false)) {
            return false;
        }
        boolean bl2 = canPlaceLarge = large && this.isValidSpace(world, origin, true);
        if (canPlaceLarge) {
            this.generateLarge(world, origin, random);
        } else {
            this.generateSmall(world, origin, random);
        }
        return true;
    }

    private void generateSmall(class_5281 world, class_2338 origin, class_5819 random) {
        int j;
        int i;
        this.setBlockStateIfReplaceable(world, origin, SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(1, 0, 0), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-1, 0, 0), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(0, 0, 1), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(0, 0, -1), SILK_BLOCK);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setBlockStateIfReplaceable(world, origin.method_10069(i - 1, -1, j - 1), AIR);
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                this.setAcidState(world, origin.method_10069(i - 2, -2, j - 2));
            }
        }
        for (i = 0; i < 3; ++i) {
            int k = i - 1;
            for (int j2 = 0; j2 < 3; ++j2) {
                int l = switch (j2) {
                    case 0, 2 -> 2;
                    case 1 -> 3;
                    default -> 0;
                };
                int m = -1 - j2;
                if (m != -3) {
                    this.setBlockStateIfReplaceable(world, origin.method_10069(k, m, l), SILK_BLOCK);
                    this.setBlockStateIfReplaceable(world, origin.method_10069(k, m, -l), SILK_BLOCK);
                    this.setBlockStateIfReplaceable(world, origin.method_10069(l, m, k), SILK_BLOCK);
                    this.setBlockStateIfReplaceable(world, origin.method_10069(-l, m, k), SILK_BLOCK);
                    continue;
                }
                this.setRandomNestState(world, origin.method_10069(k, m, l), random);
                this.setRandomNestState(world, origin.method_10069(k, m, -l), random);
                this.setRandomNestState(world, origin.method_10069(l, m, k), random);
                this.setRandomNestState(world, origin.method_10069(-l, m, k), random);
            }
        }
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -j, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -j, -j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(-j, -j, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(-j, -j, -j), SILK_BLOCK);
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setRandomNestState(world, origin.method_10069(i - 1, -3, j - 1), random);
            }
        }
    }

    private void generateLarge(class_5281 world, class_2338 origin, class_5819 random) {
        int j;
        int i;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setBlockStateIfReplaceable(world, origin.method_10069(i - 1, 0, j - 1), SILK_BLOCK);
            }
        }
        for (i = 0; i < 3; ++i) {
            j = i - 1;
            this.setBlockStateIfReplaceable(world, origin.method_10069(2, -1, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(-2, -1, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -1, 2), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -1, -2), SILK_BLOCK);
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setBlockStateIfReplaceable(world, origin.method_10069(i - 1, -1, j - 1), AIR);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setBlockStateIfReplaceable(world, origin.method_10069(i - 1, -2, j - 1), AIR);
            }
        }
        for (i = 0; i < 3; ++i) {
            j = i - 1;
            this.setBlockStateIfReplaceable(world, origin.method_10069(2, -2, j), AIR);
            this.setBlockStateIfReplaceable(world, origin.method_10069(-2, -2, j), AIR);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -2, 2), AIR);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -2, -2), AIR);
            this.setBlockStateIfReplaceable(world, origin.method_10069(3, -2, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(-3, -2, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -2, 3), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -2, -3), SILK_BLOCK);
        }
        this.setBlockStateIfReplaceable(world, origin.method_10069(2, -2, 2), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(2, -2, -2), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-2, -2, 2), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-2, -2, -2), SILK_BLOCK);
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                this.setBlockStateIfReplaceable(world, origin.method_10069(i - 2, -3, j - 2), AIR);
            }
        }
        for (i = 0; i < 5; ++i) {
            j = i - 2;
            this.setBlockStateIfReplaceable(world, origin.method_10069(3, -3, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(-3, -3, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -3, 3), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -3, -3), SILK_BLOCK);
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                this.setAcidState(world, origin.method_10069(i - 2, -4, j - 2));
            }
        }
        for (i = 0; i < 3; ++i) {
            j = i - 1;
            this.setAcidState(world, origin.method_10069(3, -4, j));
            this.setAcidState(world, origin.method_10069(-3, -4, j));
            this.setAcidState(world, origin.method_10069(j, -4, 3));
            this.setAcidState(world, origin.method_10069(j, -4, -3));
            this.setBlockStateIfReplaceable(world, origin.method_10069(4, -4, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(-4, -4, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -4, 4), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -4, -4), SILK_BLOCK);
        }
        this.setBlockStateIfReplaceable(world, origin.method_10069(3, -4, 2), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(3, -4, -2), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-3, -4, 2), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-3, -4, -2), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(2, -4, 3), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(2, -4, -3), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-2, -4, 3), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-2, -4, -3), SILK_BLOCK);
        for (i = 0; i < 5; ++i) {
            j = i - 2;
            this.setBlockStateIfReplaceable(world, origin.method_10069(4, -5, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(-4, -5, j), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -5, 4), SILK_BLOCK);
            this.setBlockStateIfReplaceable(world, origin.method_10069(j, -5, -4), SILK_BLOCK);
        }
        this.setBlockStateIfReplaceable(world, origin.method_10069(3, -5, 3), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(3, -5, -3), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-3, -5, 3), SILK_BLOCK);
        this.setBlockStateIfReplaceable(world, origin.method_10069(-3, -5, -3), SILK_BLOCK);
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                this.setAcidState(world, origin.method_10069(i - 3, -5, j - 3));
            }
        }
        this.setRandomNestState(world, origin.method_10069(2, -6, 2), random);
        this.setRandomNestState(world, origin.method_10069(2, -6, -2), random);
        this.setRandomNestState(world, origin.method_10069(-2, -6, 2), random);
        this.setRandomNestState(world, origin.method_10069(-2, -6, -2), random);
        for (i = 0; i < 5; ++i) {
            j = i - 2;
            this.setRandomNestState(world, origin.method_10069(3, -6, j), random);
            this.setRandomNestState(world, origin.method_10069(-3, -6, j), random);
            this.setRandomNestState(world, origin.method_10069(j, -6, 3), random);
            this.setRandomNestState(world, origin.method_10069(j, -6, -3), random);
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                this.setAcidState(world, origin.method_10069(i - 2, -6, j - 2));
            }
        }
        for (i = 0; i < 3; ++i) {
            j = i - 1;
            this.setRandomNestState(world, origin.method_10069(2, -7, j), random);
            this.setRandomNestState(world, origin.method_10069(-2, -7, j), random);
            this.setRandomNestState(world, origin.method_10069(j, -7, 2), random);
            this.setRandomNestState(world, origin.method_10069(j, -7, -2), random);
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setRandomNestState(world, origin.method_10069(i - 1, -7, j - 1), random);
            }
        }
    }

    private void setRandomNestState(class_5281 world, class_2338 pos, class_5819 random) {
        boolean bl = random.method_43048(3) >= 1;
        class_2680 state = bl ? NEST_LARVAE : NEST;
        this.setBlockStateIfReplaceable(world, pos, state);
        if (bl && random.method_43048(2) == 0) {
            this.setBlockStateIfReplaceable(world, pos.method_10074(), GLOWING_SILK);
        }
    }

    private boolean isValidSpace(class_5281 worldAccess, class_2338 origin, boolean large) {
        int height = large ? 9 : 6;
        for (int i = 0; i < height; ++i) {
            class_2680 state = worldAccess.method_8320(origin.method_10087(i));
            if (i < 2 && this.canReplace(state) || state.method_26215()) continue;
            return false;
        }
        return true;
    }

    private boolean canReplace(class_2680 state) {
        return state.method_26164(VABlockTags.LUMWASP_NEST_REPLACEABLE) || state.method_45474();
    }

    protected void setAcidState(class_5281 world, class_2338 pos) {
        class_2680 state;
        boolean bl = world.method_8409().method_43048(3) == 0;
        class_2680 class_26802 = state = bl ? ACID_BLOCK : ACID;
        if (world.method_8320(pos).method_26215()) {
            this.method_13153((class_1945)world, pos, state);
        }
    }

    protected void setBlockStateIfReplaceable(class_5281 world, class_2338 pos, class_2680 state) {
        if (this.canReplace(world.method_8320(pos))) {
            this.method_13153((class_1945)world, pos, state);
        }
    }
}

