/*
 * Decompiled with CFR 0.152.
 */
package net.domkss.keepequipped.compat;

import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import java.util.UUID;
import net.domkss.keepequipped.KeepEquipped;
import net.domkss.keepequipped.TempInventoryStorage;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class TrinketsCompat {
    public static void saveTrinkets(class_1657 player, TempInventoryStorage tempStorage) {
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(component -> {
            Map inventoryMap = component.getInventory();
            for (Map.Entry groupEntry : inventoryMap.entrySet()) {
                String group = (String)groupEntry.getKey();
                Map slotMap = (Map)groupEntry.getValue();
                for (Map.Entry slotEntry : slotMap.entrySet()) {
                    String slot = (String)slotEntry.getKey();
                    TrinketInventory inv = (TrinketInventory)slotEntry.getValue();
                    class_2371 savedSlot = class_2371.method_10211();
                    for (int i = 0; i < inv.method_5439(); ++i) {
                        class_1799 stack = inv.method_5438(i);
                        if (!stack.method_7960()) {
                            savedSlot.add((Object)stack.method_7972());
                            continue;
                        }
                        savedSlot.add((Object)class_1799.field_8037);
                    }
                    String inventoryName = "trinkets." + group + "." + slot;
                    tempStorage.addInventory(player.method_5667(), inventoryName, (class_2371<class_1799>)savedSlot);
                    if (!KeepEquipped.config.isDebug()) continue;
                    KeepEquipped.logger.info("[TrinketsCompat] Saved slot " + inventoryName + " with " + savedSlot.size() + " items");
                }
            }
        });
    }

    public static void clearTrinkets(class_1657 player) {
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(component -> {
            Map inventoryMap = component.getInventory();
            for (Map.Entry groupEntry : inventoryMap.entrySet()) {
                Map slotMap = (Map)groupEntry.getValue();
                for (TrinketInventory inv : slotMap.values()) {
                    for (int i = 0; i < inv.method_5439(); ++i) {
                        inv.method_5447(i, class_1799.field_8037);
                    }
                }
            }
            if (KeepEquipped.config.isDebug()) {
                KeepEquipped.logger.info("[TrinketsCompat] Cleared all trinket slots for " + player.method_5477().getString());
            }
        });
    }

    public static void restoreTrinkets(class_1657 player, UUID oldPlayerID, TempInventoryStorage tempStorage) {
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(component -> {
            Map inventoryMap = component.getInventory();
            for (Map.Entry groupEntry : inventoryMap.entrySet()) {
                String group = (String)groupEntry.getKey();
                Map slotMap = (Map)groupEntry.getValue();
                for (Map.Entry slotEntry : slotMap.entrySet()) {
                    String slot = (String)slotEntry.getKey();
                    TrinketInventory inv = (TrinketInventory)slotEntry.getValue();
                    String inventoryName = "trinkets." + group + "." + slot;
                    class_2371<class_1799> savedSlot = tempStorage.getInventoryById(oldPlayerID, inventoryName);
                    for (int i = 0; i < Math.min(inv.method_5439(), savedSlot.size()); ++i) {
                        class_1799 savedStack = (class_1799)savedSlot.get(i);
                        inv.method_5447(i, savedStack.method_7972());
                    }
                    if (!KeepEquipped.config.isDebug()) continue;
                    KeepEquipped.logger.info("[TrinketsCompat] Restored slot " + inventoryName + " with " + savedSlot.size() + " items");
                }
            }
        });
    }
}

