/*
 * Decompiled with CFR 0.152.
 */
package net.domkss.keepequipped.mixin;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.stream.IntStream;
import net.domkss.keepequipped.KeepEquipped;
import net.domkss.keepequipped.TempInventoryStorage;
import net.domkss.keepequipped.compat.ModCompat;
import net.domkss.keepequipped.compat.TrinketsCompat;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class PlayerRespawnMixin
extends class_1657 {
    public PlayerRespawnMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void restoreSavedItems(class_3222 oldPlayer, boolean alive, CallbackInfo info) {
        UUID oldPlayerID = oldPlayer.method_5667();
        MinecraftServer server = oldPlayer.method_5682();
        if (server == null || server.method_3767().method_8355(class_1928.field_19389) || oldPlayer.method_7325()) {
            return;
        }
        TempInventoryStorage tempStorage = TempInventoryStorage.getStorage(server);
        class_2371<class_1799> savedMain = tempStorage.getInventoryById(oldPlayerID, "main");
        class_2371<class_1799> savedArmor = tempStorage.getInventoryById(oldPlayerID, "armor");
        class_2371<class_1799> savedOffHand = tempStorage.getInventoryById(oldPlayerID, "offhand");
        ImmutableList combinedItemList = ImmutableList.of(savedMain, savedArmor, savedOffHand);
        if (KeepEquipped.config.isDegradeEquipmentOnDeath()) {
            combinedItemList.forEach(itemList -> itemList.forEach(itemStack -> {
                if (itemStack.method_7963()) {
                    int currentDurability = itemStack.method_7919();
                    int maxDurability = itemStack.method_7936();
                    int durabilityReduction = (int)((double)maxDurability * KeepEquipped.config.getDegradePercentage());
                    int newDurability = currentDurability + durabilityReduction;
                    newDurability = Math.min(newDurability, maxDurability);
                    itemStack.method_7974(newDurability);
                }
            }));
        }
        IntStream.range(0, savedMain.size()).forEach(i -> this.method_31548().field_7547.set(i, (Object)((class_1799)savedMain.get(i))));
        IntStream.range(0, savedArmor.size()).forEach(i -> this.method_31548().field_7548.set(i, (Object)((class_1799)savedArmor.get(i))));
        IntStream.range(0, savedOffHand.size()).forEach(i -> this.method_31548().field_7544.set(i, (Object)((class_1799)savedOffHand.get(i))));
        if (KeepEquipped.config.isKeepXpOnDeath()) {
            if (KeepEquipped.config.getKeptXpPercentage() < 1.0) {
                this.field_7495 = (int)((double)this.calculateTotalExperienceFromLevelAndProgress(oldPlayer.field_7520, oldPlayer.field_7510) * KeepEquipped.config.getKeptXpPercentage());
                this.method_7320(this.field_7495);
                this.setLevelAndProgress(this.field_7495);
            } else {
                this.field_7495 = oldPlayer.field_7495;
                this.method_7320(oldPlayer.method_7272());
                this.field_7520 = oldPlayer.field_7520;
                this.field_7510 = oldPlayer.field_7510;
            }
        }
        if (ModCompat.isTrinketsLoaded() && KeepEquipped.config.isSaveTrinkets()) {
            TrinketsCompat.restoreTrinkets(this, oldPlayerID, tempStorage);
        }
    }

    private int calculateTotalExperienceFromLevelAndProgress(int expLevel, float expProgress) {
        int totalXp = 0;
        totalXp = expLevel >= 30 ? (totalXp += (int)((float)(112 + (expLevel - 30) * 9) * expProgress)) : (totalXp += (int)((float)(expLevel >= 15 ? 37 + (expLevel - 15) * 5 : 7 + expLevel * 2) * expProgress));
        while (expLevel > 0) {
            if (--expLevel >= 30) {
                totalXp += 112 + (expLevel - 30) * 9;
                continue;
            }
            totalXp += expLevel >= 15 ? 37 + (expLevel - 15) * 5 : 7 + expLevel * 2;
        }
        return totalXp;
    }

    private void setLevelAndProgress(int totalXp) {
        int xpToNext;
        while (totalXp >= (xpToNext = this.method_7349())) {
            totalXp -= xpToNext;
            ++this.field_7520;
        }
        xpToNext = this.method_7349();
        this.field_7510 = xpToNext == 0 || totalXp < 0 ? 0.0f : (float)totalXp / (float)xpToNext;
    }
}

