/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.binaries;

import java.nio.file.Path;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.binaries.manager.BinaryManager;

public class WaterMediaBinaries {
    public static final String ID = "waterbinaries";
    public static final String NAME = "WaterMedia Binaries";
    public static final String FFMPEG_ID = "ffmpeg";
    public static final String LIBVLC_ID = "libvlc";
    public static final Logger LOGGER = LogManager.getLogger((String)"waterbinaries");
    private static final Marker IT = MarkerManager.getMarker((String)WaterMediaBinaries.class.getSimpleName());
    private static final ServiceLoader<BinaryManager> MANAGERS = ServiceLoader.load(BinaryManager.class);
    private static boolean initialized = false;

    public static synchronized void start(String name, Path tmp, Path cwd, boolean clientSide) {
        Path baseDir;
        LOGGER.info(IT, "Starting WaterMedia Binaries initialization");
        if (initialized) {
            LOGGER.warn(IT, "WaterMedia Binaries already initialized");
            return;
        }
        int count = 0;
        for (BinaryManager manager : MANAGERS) {
            LOGGER.debug(IT, "Registered binary manager: {}", (Object)manager.name());
            ++count;
        }
        if (count == 0) {
            LOGGER.warn(IT, "No Binary Managers found!");
        } else {
            LOGGER.info(IT, "Total Binary Managers registered: {}", (Object)count);
        }
        Path path = baseDir = tmp != null ? tmp : cwd;
        if (baseDir == null) {
            LOGGER.error(IT, "No valid base directory provided");
            return;
        }
        int successful = 0;
        int failed = 0;
        for (BinaryManager manager : MANAGERS) {
            try {
                LOGGER.info(IT, "Extracting binaries for: {}", (Object)manager.name());
                if (manager.extract(baseDir)) {
                    ++successful;
                    LOGGER.info(IT, "{} extraction completed successfully", (Object)manager.name());
                    continue;
                }
                ++failed;
                LOGGER.warn(IT, "{} extraction failed or not available", (Object)manager.name());
            }
            catch (Exception e) {
                ++failed;
                LOGGER.error(IT, "Failed to extract binaries for: {}", (Object)manager.name(), (Object)e);
            }
        }
        LOGGER.info(IT, "Binary extraction complete - Successful: {}, Failed: {}", (Object)successful, (Object)failed);
        initialized = true;
    }

    public static synchronized Path getBinaryPath(String name) {
        if (!initialized) {
            LOGGER.warn(IT, "WaterMedia Binaries not initialized. Call start() first.");
            return null;
        }
        for (BinaryManager manager : MANAGERS) {
            if (!manager.name().equalsIgnoreCase(name)) continue;
            if (manager.ready()) {
                LOGGER.debug(IT, "Binary path for {}: {}", (Object)name, (Object)manager.path().toAbsolutePath());
                return manager.path().toAbsolutePath();
            }
            LOGGER.warn(IT, "Binary manager {} is not ready", (Object)name);
            return null;
        }
        LOGGER.warn(IT, "No binary manager found for name: {}", (Object)name);
        return null;
    }

    public static synchronized void cleanup(boolean force) {
        LOGGER.info(IT, "Cleaning up all binaries (force={})", (Object)force);
        for (BinaryManager manager : MANAGERS) {
            try {
                manager.cleanup(force);
                LOGGER.debug(IT, "Cleaned up {}", (Object)manager.name());
            }
            catch (Exception e) {
                LOGGER.error(IT, "Failed to cleanup {}", (Object)manager.name(), (Object)e);
            }
        }
        if (force) {
            initialized = false;
        }
    }
}

