/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.binaries.manager;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.binaries.WaterMediaBinaries;
import org.watermedia.binaries.manager.BinaryManager;
import org.watermedia.binaries.tools.IOTools;

public class FFmpegManager
implements BinaryManager {
    private static final Marker IT = MarkerManager.getMarker((String)FFmpegManager.class.getSimpleName());
    private static final String RESOURCE_PATH = "/libs/ffmpeg-%s.zip";
    private Path extractPath;
    private boolean isReady = false;

    @Override
    public String name() {
        return "ffmpeg";
    }

    @Override
    public boolean extract(Path baseDir) throws Exception {
        WaterMediaBinaries.LOGGER.info(IT, "Starting FFmpeg extraction process");
        String platformId = IOTools.getPlatformId();
        String resource = String.format(RESOURCE_PATH, platformId);
        this.extractPath = baseDir.resolve("watermedia").resolve("ffmpeg");
        if (IOTools.shouldExtract(this.extractPath, resource, IT)) {
            WaterMediaBinaries.LOGGER.info(IT, "Extraction required for platform: {}", (Object)platformId);
            if (Files.exists(this.extractPath, new LinkOption[0])) {
                WaterMediaBinaries.LOGGER.info(IT, "Removing old version");
                IOTools.cleanup(this.extractPath, true, IT);
            }
            try (InputStream is = this.getClass().getResourceAsStream(resource);){
                if (is == null) {
                    WaterMediaBinaries.LOGGER.error(IT, "Resource not found: {}", (Object)resource);
                    boolean bl = false;
                    return bl;
                }
                if (!IOTools.extract(is, this.extractPath, IT)) {
                    WaterMediaBinaries.LOGGER.error(IT, "Extraction failed");
                    boolean bl = false;
                    return bl;
                }
            }
            WaterMediaBinaries.LOGGER.info(IT, "FFmpeg extracted successfully");
        } else {
            WaterMediaBinaries.LOGGER.info(IT, "FFmpeg already up to date, skipping extraction");
        }
        this.isReady = Files.exists(this.extractPath, new LinkOption[0]);
        if (this.isReady) {
            String version = IOTools.readVersion(this.extractPath);
            WaterMediaBinaries.LOGGER.info(IT, "FFmpeg ready - Version: {}", (Object)(version != null ? version : "unknown"));
        }
        return this.isReady;
    }

    @Override
    public Path path() {
        return this.extractPath;
    }

    @Override
    public boolean ready() {
        return this.isReady;
    }

    @Override
    public void cleanup(boolean force) {
        WaterMediaBinaries.LOGGER.debug(IT, "Cleanup requested (force={})", (Object)force);
        if (this.extractPath != null) {
            IOTools.cleanup(this.extractPath, force, IT);
            if (force) {
                this.isReady = false;
                this.extractPath = null;
            }
        }
    }
}

