/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.binaries.manager;

import com.sun.jna.Platform;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.binaries.WaterMediaBinaries;
import org.watermedia.binaries.manager.BinaryManager;
import org.watermedia.binaries.tools.IOTools;

public class LibVLCManager
implements BinaryManager {
    private static final Marker IT = MarkerManager.getMarker((String)LibVLCManager.class.getSimpleName());
    private static final String RESOURCE_PATH = "/libs/libvlc-%s.zip";
    private Path extractPath;
    private boolean isReady = false;

    @Override
    public String name() {
        return "libvlc";
    }

    @Override
    public boolean extract(Path baseDir) throws Exception {
        WaterMediaBinaries.LOGGER.info(IT, "Starting LibVLC extraction process");
        if (!Platform.isWindows() || !Platform.is64Bit()) {
            WaterMediaBinaries.LOGGER.warn(IT, "LibVLC not available for current platform: OS={}, 64bit={}", (Object)Platform.getOSType(), (Object)Platform.is64Bit());
            return false;
        }
        String resource = String.format(RESOURCE_PATH, "win-x86_64");
        this.extractPath = baseDir.resolve("watermedia").resolve("libvlc");
        if (IOTools.shouldExtract(this.extractPath, resource, IT)) {
            WaterMediaBinaries.LOGGER.info(IT, "Extraction required for Windows x64");
            if (Files.exists(this.extractPath, new LinkOption[0])) {
                WaterMediaBinaries.LOGGER.info(IT, "Removing old version");
                IOTools.cleanup(this.extractPath, true, IT);
            }
            try (InputStream is = this.getClass().getResourceAsStream(resource);){
                if (is == null) {
                    WaterMediaBinaries.LOGGER.error(IT, "Resource not found: {}", (Object)resource);
                    boolean bl = false;
                    return bl;
                }
                if (!IOTools.extract(is, this.extractPath, IT)) {
                    WaterMediaBinaries.LOGGER.error(IT, "Extraction failed");
                    boolean bl = false;
                    return bl;
                }
            }
            WaterMediaBinaries.LOGGER.info(IT, "LibVLC extracted successfully");
        } else {
            WaterMediaBinaries.LOGGER.info(IT, "LibVLC already up to date, skipping extraction");
        }
        this.isReady = Files.exists(this.extractPath, new LinkOption[0]);
        if (this.isReady) {
            String version = IOTools.readVersion(this.extractPath);
            WaterMediaBinaries.LOGGER.info(IT, "LibVLC ready - Version: {}", (Object)(version != null ? version : "unknown"));
        }
        return this.isReady;
    }

    @Override
    public Path path() {
        return this.extractPath;
    }

    @Override
    public boolean ready() {
        return this.isReady;
    }

    @Override
    public void cleanup(boolean force) {
        WaterMediaBinaries.LOGGER.debug(IT, "Cleanup requested (force={})", (Object)force);
        if (this.extractPath != null) {
            IOTools.cleanup(this.extractPath, force, IT);
            if (force) {
                this.isReady = false;
                this.extractPath = null;
            }
        }
    }
}

