/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.binaries.tools;

import com.sun.jna.Platform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.Marker;
import org.watermedia.binaries.WaterMediaBinaries;

public class IOTools {
    private static final String VERSION_FILE = "version.cfg";
    private static final int BUFFER_SIZE = 8192;

    public static String getPlatformId() {
        String arch;
        String os;
        if (Platform.isWindows()) {
            os = "win";
        } else if (Platform.isMac()) {
            os = "mac";
        } else if (Platform.isLinux()) {
            os = "linux";
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + Platform.getOSType());
        }
        if (Platform.isARM() && Platform.is64Bit()) {
            arch = "arm64";
        } else if (Platform.isIntel() && Platform.is64Bit()) {
            arch = "x86_64";
        } else {
            throw new UnsupportedOperationException("Unsupported architecture: " + Platform.ARCH);
        }
        return os + "-" + arch;
    }

    public static boolean extract(InputStream zipStream, Path target, Marker marker) {
        try {
            WaterMediaBinaries.LOGGER.info(marker, "Extracting to: {}", (Object)target);
            Files.createDirectories(target, new FileAttribute[0]);
            try (ZipInputStream zis = new ZipInputStream(zipStream);){
                ZipEntry entry;
                byte[] buffer = new byte[8192];
                while ((entry = zis.getNextEntry()) != null) {
                    Path file = target.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        Files.createDirectories(file, new FileAttribute[0]);
                    } else {
                        Files.createDirectories(file.getParent(), new FileAttribute[0]);
                        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                            int len;
                            while ((len = zis.read(buffer)) > 0) {
                                out.write(buffer, 0, len);
                            }
                        }
                        if (!entry.getName().endsWith(".cfg")) {
                            IOTools.setExecutable(file);
                        }
                    }
                    zis.closeEntry();
                }
            }
            WaterMediaBinaries.LOGGER.info(marker, "Extraction complete");
            return true;
        }
        catch (Exception e) {
            WaterMediaBinaries.LOGGER.error(marker, "Extraction failed", (Throwable)e);
            return false;
        }
    }

    public static String readVersion(Path dir) {
        Path versionFile = dir.resolve(VERSION_FILE);
        if (!Files.exists(versionFile, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readString(versionFile).trim();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean shouldExtract(Path dir, String zipResource, Marker marker) {
        if (!Files.exists(dir, new LinkOption[0])) {
            WaterMediaBinaries.LOGGER.debug(marker, "Directory does not exist, extraction needed");
            return true;
        }
        String currentVersion = IOTools.readVersion(dir);
        if (currentVersion == null) {
            WaterMediaBinaries.LOGGER.debug(marker, "No version file found, extraction needed");
            return true;
        }
        String zipVersion = IOTools.readZipVersion(zipResource);
        if (zipVersion == null) {
            WaterMediaBinaries.LOGGER.warn(marker, "Could not read version from zip");
            return true;
        }
        int comparison = IOTools.compareVersions(currentVersion, zipVersion);
        if (comparison < 0) {
            WaterMediaBinaries.LOGGER.info(marker, "Current version {} is older than zip version {}, extraction needed", (Object)currentVersion, (Object)zipVersion);
            return true;
        }
        WaterMediaBinaries.LOGGER.debug(marker, "Current version {} is up to date", (Object)currentVersion);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readZipVersion(String resource) {
        try (InputStream is = IOTools.class.getResourceAsStream(resource);){
            if (is == null) {
                String string = null;
                return string;
            }
            try (ZipInputStream zis = new ZipInputStream(is);){
                int len;
                ZipEntry entry;
                do {
                    if ((entry = zis.getNextEntry()) == null) return null;
                } while (!VERSION_FILE.equals(entry.getName()));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = zis.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                String string = baos.toString().trim();
                return string;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void deleteDir(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void cleanup(Path dir, boolean force, Marker marker) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        try {
            if (force) {
                WaterMediaBinaries.LOGGER.info(marker, "Force cleanup: {}", (Object)dir);
                IOTools.deleteDir(dir);
            } else {
                WaterMediaBinaries.LOGGER.debug(marker, "Soft cleanup skipped (force=false)");
            }
        }
        catch (IOException e) {
            WaterMediaBinaries.LOGGER.error(marker, "Cleanup failed", (Throwable)e);
        }
    }

    private static void setExecutable(Path file) {
        try {
            file.toFile().setExecutable(true, false);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? IOTools.parseVersionPart(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? IOTools.parseVersionPart(parts2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }

    private static int parseVersionPart(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

