/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.util.event;

import dev.obscuria.fragmentum.util.event.EventHandler;
import dev.obscuria.fragmentum.util.event.EventToken;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.compress.utils.Lists;

public final class Event<T> {
    private final List<Registration<T>> registrations = Lists.newArrayList();
    private boolean dirty = false;

    public EventToken register(T listener) {
        return this.register(1000, listener);
    }

    public EventToken register(int priority, T listener) {
        Token token = new Token(UUID.randomUUID(), this);
        this.registrations.add(new Registration<T>(token, priority, listener));
        this.dirty = true;
        return token;
    }

    public void unregister(EventToken token) {
        this.registrations.removeIf(it -> it.token == token);
    }

    public void broadcast(EventHandler<T> handler) {
        this.sortIfDirty();
        this.registrations.forEach(it -> handler.handle(it.listener));
    }

    private void sortIfDirty() {
        if (!this.dirty) {
            return;
        }
        Collections.sort(this.registrations);
        this.dirty = false;
    }

    private record Token(UUID uuid, Event<?> event) implements EventToken
    {
        @Override
        public void unregister() {
            this.event.unregister(this);
        }
    }

    private record Registration<T>(EventToken token, int priority, T listener) implements Comparable<Registration<T>>
    {
        @Override
        public int compareTo(Registration<T> other) {
            return Integer.compare(this.priority, other.priority);
        }
    }
}

