/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum;

import dev.obscuria.fragmentum.Fragmentum;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public record ModCompat(String modId, String modName) {
    public ModCompat(String modId) {
        this(modId, modId);
    }

    public String ModName() {
        return this.modName;
    }

    public boolean isLoaded() {
        return Fragmentum.PLATFORM.isModLoaded(this.modId);
    }

    public <T> @Nullable T getIfLoaded(Supplier<Supplier<T>> supplier) {
        if (!this.isLoaded()) {
            return null;
        }
        return supplier.get().get();
    }

    public void runIfLoaded(Supplier<Runnable> runnable) {
        if (!this.isLoaded()) {
            return;
        }
        runnable.get().run();
    }

    public void runIfMissing(Runnable runnable) {
        if (this.isLoaded()) {
            return;
        }
        runnable.run();
    }
}

