/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.world.tooltip;

import dev.obscuria.fragmentum.content.util.color.Colors;
import dev.obscuria.fragmentum.content.util.color.RGB;
import dev.obscuria.fragmentum.content.world.tooltip.ChromaPresets;
import dev.obscuria.fragmentum.content.world.tooltip.StyleFlag;
import dev.obscuria.fragmentum.content.world.tooltip.TooltipBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;

public class TooltipTags {
    private static final Map<String, Instance> REGISTRY = new HashMap<String, Instance>();
    private static final long START_TIME = System.currentTimeMillis();

    public static void register(String key, Instance instance) {
        REGISTRY.putIfAbsent(key, instance);
    }

    public static void open(TooltipBuilder builder, String key, List<String> args) {
        Instance instance = REGISTRY.get(key);
        if (instance != null) {
            instance.open(builder, args);
        }
    }

    public static void close(TooltipBuilder builder, String key) {
        Instance instance = REGISTRY.get(key);
        if (instance != null) {
            instance.close(builder);
        }
    }

    static {
        TooltipTags.register("color", Color.INSTANCE);
        TooltipTags.register("chroma", Chroma.INSTANCE);
        TooltipTags.register("br", LineBreak.INSTANCE);
        TooltipTags.register("i", new SimpleFlag(StyleFlag.ITALIC));
        TooltipTags.register("b", new SimpleFlag(StyleFlag.BOLD));
        TooltipTags.register("no-i", new SimpleFlag(StyleFlag.NON_ITALIC));
        TooltipTags.register("no-b", new SimpleFlag(StyleFlag.NON_BOLD));
    }

    public static interface Instance {
        public void open(TooltipBuilder var1, List<String> var2);

        public void close(TooltipBuilder var1);
    }

    private static enum Color implements Instance
    {
        INSTANCE;


        @Override
        public void open(TooltipBuilder builder, List<String> args) {
            try {
                if (args.isEmpty()) {
                    return;
                }
                String arg = args.get(0);
                if (arg.startsWith("#")) {
                    builder.pushColor(Colors.rgbOf(arg));
                } else {
                    Integer color = Objects.requireNonNull(class_124.method_533((String)arg)).method_532();
                    builder.pushColor(Colors.rgbOf(color == null ? 0xFFFFFF : color));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void close(TooltipBuilder builder) {
            builder.popColor();
        }
    }

    private static enum Chroma implements Instance
    {
        INSTANCE;


        @Override
        public void open(TooltipBuilder builder, List<String> args) {
            try {
                if (args.size() == 1) {
                    ChromaPresets.Instance preset = ChromaPresets.get(args.get(0));
                    if (preset == null) {
                        return;
                    }
                    this.apply(builder, preset.first(), preset.second(), preset.speed());
                } else if (args.size() >= 2) {
                    RGB first = Colors.rgbOf(args.get(0));
                    RGB second = Colors.rgbOf(args.get(1));
                    float speed = args.size() >= 3 ? Float.parseFloat(args.get(2)) : 1.0f;
                    this.apply(builder, first, second, speed);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void close(TooltipBuilder builder) {
            builder.popColor();
        }

        private void apply(TooltipBuilder builder, RGB first, RGB second, float speed) {
            float seconds = (float)(System.currentTimeMillis() - START_TIME) / 1000.0f;
            builder.pushColor(first.lerp(second, 0.5f + 0.5f * (float)Math.sin(seconds * speed)));
        }
    }

    private static enum LineBreak implements Instance
    {
        INSTANCE;


        @Override
        public void open(TooltipBuilder builder, List<String> args) {
            builder.breakLine();
        }

        @Override
        public void close(TooltipBuilder builder) {
            builder.breakLine();
        }
    }

    private record SimpleFlag(StyleFlag flag) implements Instance
    {
        @Override
        public void open(TooltipBuilder builder, List<String> args) {
            builder.pushFlag(this.flag);
        }

        @Override
        public void close(TooltipBuilder builder) {
            builder.popFlag(this.flag);
        }
    }
}

