/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.config;

import dev.obscuria.fragmentum.Fragmentum;
import dev.obscuria.fragmentum.config.ConfigLayout;
import dev.obscuria.fragmentum.config.ConfigOptions;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConfigBuilder {
    public static <T extends ConfigLayout> Instance build(T layout) {
        try {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            Layer rootLayer = ConfigBuilder.buildLayer(builder, layout, null);
            return new Instance((IConfigSpec<?>)builder.build(), rootLayer);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to build config layout: " + String.valueOf(layout), exception);
        }
    }

    private static Layer buildLayer(ForgeConfigSpec.Builder builder, Object instance, @Nullable String sectionName) {
        boolean inner;
        ArrayList<Value> values = new ArrayList<Value>();
        ArrayList<Layer> innerLayers = new ArrayList<Layer>();
        boolean bl = inner = sectionName != null && !sectionName.isEmpty();
        if (inner) {
            builder.push(sectionName);
        }
        for (Field field : instance.getClass().getDeclaredFields()) {
            String category;
            ConfigOptions.Section section = field.getAnnotation(ConfigOptions.Section.class);
            String string = category = section == null ? null : section.value();
            if (category != null) {
                try {
                    Object nestedInstance = field.get(instance);
                    if (nestedInstance == null) continue;
                    Layer nestedLayer = ConfigBuilder.buildLayer(builder, nestedInstance, category);
                    innerLayers.add(nestedLayer);
                }
                catch (Exception exception) {
                    Fragmentum.LOGGER.error("Failed to create nested config object: {}", (Object)field, (Object)exception);
                }
                continue;
            }
            if (field.getAnnotation(ConfigOptions.Value.class) == null) continue;
            ForgeConfigSpec.ConfigValue<?> configValue = ConfigBuilder.buildValue(builder, instance, field);
            values.add(new Value(field, configValue));
        }
        if (inner) {
            builder.pop();
        }
        return new Layer(instance, values, innerLayers);
    }

    private static ForgeConfigSpec.ConfigValue<?> buildValue(ForgeConfigSpec.Builder builder, Object instance, Field field) {
        Class<?> type = field.getType();
        try {
            ConfigOptions.applyComment(field, arg_0 -> ((ForgeConfigSpec.Builder)builder).comment(arg_0));
            if (type == Integer.TYPE || type == Integer.class) {
                return builder.defineInRange(ConfigOptions.getValueName(field), field.getInt(instance), (int)ConfigOptions.getRangeMin(field), (int)ConfigOptions.getRangeMax(field));
            }
            if (type == Double.TYPE || type == Double.class) {
                return builder.defineInRange(ConfigOptions.getValueName(field), field.getDouble(instance), ConfigOptions.getRangeMin(field), ConfigOptions.getRangeMax(field));
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return builder.define(ConfigOptions.getValueName(field), field.getBoolean(instance));
            }
            if (type == String.class) {
                return builder.define(ConfigOptions.getValueName(field), (Object)((String)field.get(instance)));
            }
            if (type.isEnum()) {
                return builder.defineEnum(ConfigOptions.getValueName(field), (Enum)field.get(instance));
            }
            if (type == List.class) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                Class elementType = (Class)genericType.getActualTypeArguments()[0];
                if (elementType == String.class) {
                    List defaultList = (List)field.get(instance);
                    return builder.defineList(ConfigOptions.getValueName(field), defaultList, it -> it instanceof String);
                }
                if (elementType == Integer.class) {
                    List defaultList = (List)field.get(instance);
                    return builder.defineList(ConfigOptions.getValueName(field), defaultList, it -> it instanceof Integer);
                }
                if (elementType == Double.class) {
                    List defaultList = (List)field.get(instance);
                    return builder.defineList(ConfigOptions.getValueName(field), defaultList, it -> it instanceof Double || it instanceof Float);
                }
                if (elementType == Boolean.class) {
                    List defaultList = (List)field.get(instance);
                    return builder.defineList(ConfigOptions.getValueName(field), defaultList, it -> it instanceof Boolean);
                }
                throw new IllegalArgumentException("Unsupported config list element type: " + String.valueOf(elementType));
            }
            throw new IllegalArgumentException("Unsupported config field type: " + String.valueOf(type));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to build config value: " + String.valueOf(field), exception);
        }
    }

    public record Layer(Object instance, List<Value> values, List<Layer> innerLayers) {
        public void updateAll() {
            this.values.forEach(it -> it.update(this.instance));
            this.innerLayers.forEach(Layer::updateAll);
        }
    }

    public record Instance(IConfigSpec<?> spec, Layer rootLayer) {
        public <T extends ConfigLayout> void maybeUpdate(ModConfig config, T layout, Consumer<T> listener) {
            if (config.getSpec() != this.spec) {
                return;
            }
            this.rootLayer.updateAll();
            listener.accept(layout);
        }
    }

    public record Value(Field field, ForgeConfigSpec.ConfigValue<?> value) {
        public void update(Object instance) {
            try {
                this.field.set(instance, this.value.get());
            }
            catch (Exception exception) {
                Fragmentum.LOGGER.error("Failed to set config value: {}", (Object)this.field, (Object)exception);
            }
        }
    }
}

