/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.util.signal;

import dev.obscuria.fragmentum.util.signal.Signal0;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Signal<T> {
    private static final ResourceLocation UNBOUND = new ResourceLocation("unbound");
    private final List<Connection<T>> connections = new ArrayList<Connection<T>>();

    public void connect(T listener) {
        this.connect(null, false, null, listener);
    }

    public void connect(@Nullable Object source, T listener) {
        this.connect(source, false, null, listener);
    }

    public void connect(boolean oneShot, T listener) {
        this.connect(null, oneShot, null, listener);
    }

    public void connect(@Nullable Object source, boolean oneShot, T listener) {
        this.connect(source, oneShot, null, listener);
    }

    public void connect(@Nullable Object source, boolean oneShot, @Nullable Signal0 breaker, T listener) {
        Connection<T> connection = new Connection<T>(Objects.requireNonNullElse(source, UNBOUND), oneShot, listener);
        this.connections.add(connection);
        if (breaker == null) {
            return;
        }
        breaker.connect(true, (T)((Signal0.Listener)() -> this.disconnect(connection)));
    }

    public void disconnect(Object source) {
        this.connections.removeIf(it -> it.source == source);
    }

    protected void emit(Consumer<T> consumer) {
        this.connections.removeIf(it -> {
            consumer.accept(it.listener);
            return it.oneShot;
        });
    }

    private void disconnect(Connection<T> connection) {
        this.connections.remove(connection);
    }

    private record Connection<T>(Object source, boolean oneShot, T listener) {
    }
}

