/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.blockentity;

import com.enderio.base.common.blockentity.IPaintableBlockEntity;
import com.enderio.base.common.blockentity.SinglePaintedBlockEntity;
import com.enderio.base.common.util.PaintUtils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DoublePaintedBlockEntity
extends SinglePaintedBlockEntity {
    @Nullable
    private Block paint2;
    public static final ModelProperty<Block> PAINT2 = IPaintableBlockEntity.createAndRegisterModelProperty();

    @Nullable
    public Block getPaint2() {
        return this.paint2;
    }

    @Override
    public Block[] getPaints() {
        return new Block[]{this.getPaint(), this.getPaint2()};
    }

    public DoublePaintedBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @Override
    public ModelData getModelData() {
        return ModelData.builder().with(PAINT, (Object)this.getPaint()).with(PAINT2, (Object)this.paint2).build();
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        Block oldPaint = this.getPaint2();
        super.onDataPacket(net, pkt);
        if (oldPaint != this.paint2) {
            this.requestModelDataUpdate();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7731_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), 9);
            }
        }
    }

    @Override
    protected void readPaint(CompoundTag tag) {
        super.readPaint(tag);
        if (tag.m_128441_("Paint2")) {
            this.paint2 = PaintUtils.getBlockFromRL(tag.m_128461_("Paint2"));
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @Override
    protected void writePaint(CompoundTag tag) {
        super.writePaint(tag);
        if (this.paint2 != null) {
            tag.m_128359_("Paint2", Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this.paint2)).toString());
        }
    }
}

