/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.network;

import com.enderio.base.common.lang.EIOLang;
import com.enderio.conduits.common.items.ConduitProbeItem;
import com.enderio.core.common.network.Packet;
import com.enderio.core.common.util.TooltipUtil;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class C2SSyncProbeState
implements Packet {
    private ConduitProbeItem.State state;

    public C2SSyncProbeState(ConduitProbeItem.State state) {
        this.state = state;
    }

    public C2SSyncProbeState(FriendlyByteBuf buf) {
        this.state = (ConduitProbeItem.State)buf.m_130066_(ConduitProbeItem.State.class);
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getSender() != null;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ItemStack probeStack = context.getSender().m_21205_().m_41720_() instanceof ConduitProbeItem ? context.getSender().m_21205_() : context.getSender().m_21206_();
            ConduitProbeItem.setState(probeStack, this.state, false);
            context.getSender().m_213846_((Component)TooltipUtil.withArgs(EIOLang.CONDUIT_PROBE_SWITCHED_MODE, this.state.getStateText()));
        });
        context.setPacketHandled(true);
    }

    protected void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.state);
    }

    public static class Handler
    extends Packet.PacketHandler<C2SSyncProbeState> {
        @Override
        public C2SSyncProbeState fromNetwork(FriendlyByteBuf buf) {
            return new C2SSyncProbeState(buf);
        }

        @Override
        public void toNetwork(C2SSyncProbeState packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

