/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.state.EntityState;
import org.joml.Vector3f;

public class NewComponentParticlePacket {
    private final int entityId;
    private final Component contents;
    private final Vector3f position;

    private NewComponentParticlePacket(int entityId, Component contents, Vector3f position) {
        this.entityId = entityId;
        this.contents = contents;
        this.position = position;
    }

    public NewComponentParticlePacket(LivingEntity entity, Component contents) {
        this.entityId = entity.m_19879_();
        this.contents = contents;
        this.position = new Vector3f((float)entity.m_20185_(), (float)entity.m_20188_(), (float)entity.m_20189_());
    }

    public NewComponentParticlePacket(Vector3f position, Component contents) {
        this.entityId = -1;
        this.contents = contents;
        this.position = position;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_269582_(this.position);
        buf.m_130083_(this.contents);
        buf.m_130130_(this.entityId);
    }

    public static NewComponentParticlePacket decode(FriendlyByteBuf buf) {
        Vector3f position = buf.m_269394_();
        Component contents = buf.m_130238_();
        int entityId = buf.m_130242_();
        return entityId == -1 ? new NewComponentParticlePacket(position, contents) : new NewComponentParticlePacket(entityId, contents, position);
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (this.entityId == -1) {
                TESParticleManager.addParticle(new ComponentParticle(null, this.position, this.contents));
            } else {
                EntityState entityState = TESAPI.getTESDataForEntity(this.entityId);
                if (entityState != null) {
                    TESParticleManager.addParticle(new ComponentParticle(entityState, this.position, this.contents));
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

