/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud.element;

import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.render.TextureRenderHelper;

public interface TESHudEntityIcon {
    public boolean shouldRender(LivingEntity var1);

    public void render(TESHudRenderContext var1, LivingEntity var2, float var3, float var4, float var5);

    public static void genericSpriteRender(TESHudRenderContext renderContext, ResourceLocation sprite, float x, float y, float opacity) {
        TextureRenderHelper renderer = TextureRenderHelper.ofSprite(sprite).colour(ARGB.white((float)opacity));
        if (renderContext.isInWorld()) {
            renderer.lightLevel(renderContext.getPackedLight());
        }
        renderer.render(renderContext, x, y);
    }

    public static TESHudEntityIcon makeGeneric(final ResourceLocation sprite, final Predicate<LivingEntity> shouldRender) {
        return new TESHudEntityIcon(){

            @Override
            public boolean shouldRender(LivingEntity entity) {
                return shouldRender.test(entity);
            }

            @Override
            public void render(TESHudRenderContext renderContext, LivingEntity entity, float x, float y, float opacity) {
                TESHudEntityIcon.genericSpriteRender(renderContext, sprite, x, y, opacity);
            }
        };
    }
}

