/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api;

import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.object.TESHudElement;
import net.tslat.tes.api.object.TESParticle;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.particle.TESParticleClaimant;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.TESParticleSourceHandler;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.particle.type.NumericParticle;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public final class TESAPI {
    public static void addTESParticle(TESParticle<?> particle) {
        TESParticleManager.addParticle(particle);
    }

    public static void addTESHudElement(class_2960 id, TESHudElement element) {
        TESHud.addHudElement(id.toString(), element);
    }

    public static boolean removeTESHudElement(class_2960 id) {
        return TESHud.removeHudElement(id.toString());
    }

    public static void registerParticleClaimant(class_2960 id, TESParticleClaimant claimant) {
        TESParticleManager.registerParticleClaimant(id, claimant);
    }

    public static void registerParticleSourceHandler(TESParticleSourceHandler handler) {
        TESParticleManager.registerParticleSourceHandler(handler);
    }

    @Nullable
    public static TESConfig getConfig() {
        return TESConstants.CONFIG;
    }

    @Nullable
    public static class_1309 getCurrentHUDTarget() {
        return TESHud.getTargetEntity();
    }

    @Nullable
    public static EntityState getTESDataForEntity(class_1309 entity) {
        return TESAPI.getTESDataForEntity(entity.method_5628());
    }

    @Nullable
    public static EntityState getTESDataForEntity(int entityId) {
        return TESEntityTracking.getStateForEntityId(entityId);
    }

    public static void submitParticleClaim(class_2960 id, class_1309 targetEntity, Optional<class_2487> additionalData) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticleClaim(id, targetEntity, additionalData);
        } else {
            TESParticleManager.addParticleClaim(targetEntity.method_5628(), id, additionalData);
        }
    }

    public static void addTESParticle(class_3218 level, Vector3f position, class_2561 contents) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticle(level, position, contents);
        } else {
            TESParticleManager.addParticle(new ComponentParticle(null, position, contents));
        }
    }

    public static void addTESParticle(class_1309 targetedEntity, class_2561 contents) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticle(targetedEntity, contents);
        } else {
            EntityState entityState = TESAPI.getTESDataForEntity(targetedEntity);
            if (entityState != null) {
                TESParticleManager.addParticle(new ComponentParticle(entityState, targetedEntity.method_33571().method_46409(), contents));
            }
        }
    }

    public static void sendParticle(class_3218 level, Vector3f position, double value, int colour) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticle(level, position, value, colour);
        } else {
            TESParticleManager.addParticle(new NumericParticle(null, position, value).withColour(colour));
        }
    }

    public static void sendParticle(class_1309 targetedEntity, double value, int colour) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESConstants.NETWORKING.sendParticle(targetedEntity, value, colour);
        } else {
            EntityState entityState = TESAPI.getTESDataForEntity(targetedEntity);
            if (entityState != null) {
                TESParticleManager.addParticle(new NumericParticle(entityState, targetedEntity.method_33571().method_46409(), value).withColour(colour));
            }
        }
    }
}

