/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.object;

import com.mojang.datafixers.util.Either;
import java.util.function.Consumer;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public record TESHudRenderContext(Either<InGuiArgs, InWorldArgs> args) {
    public static TESHudRenderContext guiContext(class_332 guiGraphics, float partialTick) {
        return new TESHudRenderContext((Either<InGuiArgs, InWorldArgs>)Either.left((Object)new InGuiArgs(guiGraphics, partialTick)));
    }

    public static TESHudRenderContext inWorldContext(class_4587 poseStack, class_11659 renderTasks, class_12075 cameraRenderState, float partialTick, int packedLight) {
        return new TESHudRenderContext((Either<InGuiArgs, InWorldArgs>)Either.right((Object)new InWorldArgs(poseStack, renderTasks, cameraRenderState, partialTick, packedLight)));
    }

    public boolean isInWorld() {
        return this.args.right().isPresent();
    }

    public TESHudRenderContext forGui(Consumer<InGuiArgs> guiConsumer) {
        this.args.ifLeft(guiConsumer);
        return this;
    }

    public TESHudRenderContext forInWorld(Consumer<InWorldArgs> inWorldConsumer) {
        this.args.ifRight(inWorldConsumer);
        return this;
    }

    public void pushMatrix() {
        this.args.ifLeft(inGuiArgs -> inGuiArgs.guiGraphics.method_51448().pushMatrix()).ifRight(inWorldArgs -> inWorldArgs.poseStack.method_22903());
    }

    public void popMatrix() {
        this.args.ifLeft(inGuiArgs -> inGuiArgs.guiGraphics.method_51448().popMatrix()).ifRight(inWorldArgs -> inWorldArgs.poseStack.method_22909());
    }

    public void translate(float x, float y, float z) {
        this.args.ifLeft(inGuiArgs -> inGuiArgs.guiGraphics.method_51448().translate(x, y)).ifRight(inWorldArgs -> inWorldArgs.poseStack.method_46416(x, y, z));
    }

    public void scale(float x, float y, float z) {
        this.args.ifLeft(inGuiArgs -> inGuiArgs.guiGraphics.method_51448().scale(x, y)).ifRight(inWorldArgs -> inWorldArgs.poseStack.method_22905(x, y, z));
    }

    public float getPartialTick() {
        return ((Float)this.args.map(InGuiArgs::partialTick, InWorldArgs::partialTick)).floatValue();
    }

    public class_332 getGuiGraphics() {
        if (this.isInWorld()) {
            throw new IllegalStateException("Cannot get GuiGraphics from in-world render context");
        }
        return ((InGuiArgs)this.args.left().get()).guiGraphics();
    }

    public class_4587 getPoseStack() {
        if (!this.isInWorld()) {
            throw new IllegalStateException("Cannot get PoseStack from in-world render context");
        }
        return ((InWorldArgs)this.args.right().get()).poseStack;
    }

    public int getPackedLight() {
        if (!this.isInWorld()) {
            throw new IllegalStateException("Cannot get BufferSource from in-world render context");
        }
        return ((InWorldArgs)this.args.right().get()).packedLight;
    }

    public record InGuiArgs(class_332 guiGraphics, float partialTick) {
    }

    public record InWorldArgs(class_4587 poseStack, class_11659 renderTasks, class_12075 cameraRenderState, float partialTick, int packedLight) {
    }
}

