/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import net.minecraft.class_9848;
import net.tslat.tes.api.object.TESHudRenderContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class ColouredRectRenderHelper {
    private final RenderPipeline renderPipeline;
    private float width = 16.0f;
    private float height = 16.0f;
    private int colour0 = -1;
    private int colour1 = -1;
    private int colour2 = -1;
    private int colour3 = -1;

    ColouredRectRenderHelper(RenderPipeline renderPipeline) {
        this.renderPipeline = renderPipeline;
    }

    public static ColouredRectRenderHelper of() {
        return ColouredRectRenderHelper.of(class_10799.field_56879);
    }

    public static ColouredRectRenderHelper of(RenderPipeline renderPipeline) {
        return new ColouredRectRenderHelper(renderPipeline);
    }

    public ColouredRectRenderHelper sized(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public ColouredRectRenderHelper colour(int colour) {
        this.colour0 = colour;
        if (this.colour1 == -1) {
            this.colour1 = colour;
        }
        if (this.colour2 == -1) {
            this.colour2 = colour;
        }
        if (this.colour3 == -1) {
            this.colour3 = colour;
        }
        return this;
    }

    public ColouredRectRenderHelper bottomLeftColour(int colour) {
        this.colour1 = colour;
        return this;
    }

    public ColouredRectRenderHelper bottomRightColour(int colour) {
        this.colour2 = colour;
        return this;
    }

    public ColouredRectRenderHelper topRightColour(int colour) {
        this.colour3 = colour;
        return this;
    }

    public ColouredRectRenderHelper colour(int red, int green, int blue, int alpha) {
        return this.colour(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
    }

    public ColouredRectRenderHelper colour(float red, float green, float blue, float alpha) {
        return this.colour(class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public ColouredRectRenderHelper colour(float red, float green, float blue) {
        return this.colour(red, green, blue, 1.0f);
    }

    public ColouredRectRenderHelper colour(int red, int green, int blue) {
        return this.colour(red, green, blue, 255);
    }

    public void render(TESHudRenderContext renderContext, float x, float y) {
        renderContext.forGui(args -> this.renderForHud((TESHudRenderContext.InGuiArgs)args, x, y)).forInWorld(args -> this.renderInWorld((TESHudRenderContext.InWorldArgs)args, x, y));
    }

    public void renderForHud(TESHudRenderContext.InGuiArgs args, float x, float y) {
        if (class_9848.method_61320((int)this.colour0) == 0 && class_9848.method_61320((int)this.colour1) == 0 && class_9848.method_61320((int)this.colour2) == 0 && class_9848.method_61320((int)this.colour3) == 0) {
            return;
        }
        int xMin = class_3532.method_15375((float)x);
        int yMin = class_3532.method_15375((float)y);
        int xMax = Math.round((float)xMin + this.width);
        int yMax = Math.round((float)yMin + this.height);
        class_332 guiGraphics = args.guiGraphics();
        guiGraphics.field_59826.method_70919((class_11244)new RenderState(this.renderPipeline, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), xMin, yMin, xMax, yMax, this.colour0, this.colour1, this.colour2, this.colour3, guiGraphics.field_44659.method_70863()));
    }

    public void renderInWorld(TESHudRenderContext.InWorldArgs args, float x, float y) {
        if (class_9848.method_61320((int)this.colour0) == 0 && class_9848.method_61320((int)this.colour1) == 0 && class_9848.method_61320((int)this.colour2) == 0 && class_9848.method_61320((int)this.colour3) == 0) {
            return;
        }
        int xMin = class_3532.method_15375((float)x);
        int yMin = class_3532.method_15375((float)y);
        int xMax = Math.round((float)xMin + this.width);
        int yMax = Math.round((float)yMin + this.height);
        args.renderTasks().method_73483(args.poseStack(), class_1921.method_49046(), (pose, vertexConsumer) -> {
            vertexConsumer.method_56824(pose, (float)xMin, (float)yMin, 0.0f).method_39415(this.colour0);
            vertexConsumer.method_56824(pose, (float)xMin, (float)yMax, 0.0f).method_39415(this.colour1);
            vertexConsumer.method_56824(pose, (float)xMax, (float)yMax, 0.0f).method_39415(this.colour2);
            vertexConsumer.method_56824(pose, (float)xMax, (float)yMin, 0.0f).method_39415(this.colour3);
        });
    }

    static final class RenderState
    extends Record
    implements class_11244 {
        private final RenderPipeline pipeline;
        private final class_11231 textureSetup;
        private final Matrix3x2f pose;
        private final int x0;
        private final int y0;
        private final int x1;
        private final int y1;
        private final int colour1;
        private final int colour2;
        private final int colour3;
        private final int colour4;
        @Nullable
        private final class_8030 scissorArea;
        @Nullable
        private final class_8030 bounds;

        RenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, int x0, int y0, int x1, int y1, int colour1, int colour2, int colour3, int colour4, @Nullable class_8030 scissorRegion) {
            this(pipeline, textureSetup, pose, x0, y0, x1, y1, colour1, colour2, colour3, colour4, scissorRegion, RenderState.getBounds(x0, y0, x1, y1, pose, scissorRegion));
        }

        RenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, int x0, int y0, int x1, int y1, int colour1, int colour2, int colour3, int colour4, @Nullable class_8030 scissorArea, @Nullable class_8030 bounds) {
            this.pipeline = pipeline;
            this.textureSetup = textureSetup;
            this.pose = pose;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.colour1 = colour1;
            this.colour2 = colour2;
            this.colour3 = colour3;
            this.colour4 = colour4;
            this.scissorArea = scissorArea;
            this.bounds = bounds;
        }

        public void method_70917(class_4588 vertexConsumer) {
            vertexConsumer.method_70815(this.pose(), (float)this.x0(), (float)this.y0()).method_39415(this.colour1);
            vertexConsumer.method_70815(this.pose(), (float)this.x0(), (float)this.y1()).method_39415(this.colour2);
            vertexConsumer.method_70815(this.pose(), (float)this.x1(), (float)this.y1()).method_39415(this.colour3);
            vertexConsumer.method_70815(this.pose(), (float)this.x1(), (float)this.y0()).method_39415(this.colour4);
        }

        @Nullable
        private static class_8030 getBounds(int x0, int y0, int x1, int y1, Matrix3x2f pose, @Nullable class_8030 scissorRegion) {
            class_8030 rect = new class_8030(x0, y0, x1 - x0, y1 - y0).method_71523(pose);
            return scissorRegion != null ? scissorRegion.method_49701(rect) : rect;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RenderState.class, "pipeline;textureSetup;pose;x0;y0;x1;y1;colour1;colour2;colour3;colour4;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x0", "y0", "x1", "y1", "colour1", "colour2", "colour3", "colour4", "scissorArea", "bounds"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RenderState.class, "pipeline;textureSetup;pose;x0;y0;x1;y1;colour1;colour2;colour3;colour4;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x0", "y0", "x1", "y1", "colour1", "colour2", "colour3", "colour4", "scissorArea", "bounds"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RenderState.class, "pipeline;textureSetup;pose;x0;y0;x1;y1;colour1;colour2;colour3;colour4;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x0", "y0", "x1", "y1", "colour1", "colour2", "colour3", "colour4", "scissorArea", "bounds"}, this, o);
        }

        public RenderPipeline comp_4055() {
            return this.pipeline;
        }

        public class_11231 comp_4056() {
            return this.textureSetup;
        }

        public Matrix3x2f pose() {
            return this.pose;
        }

        public int x0() {
            return this.x0;
        }

        public int y0() {
            return this.y0;
        }

        public int x1() {
            return this.x1;
        }

        public int y1() {
            return this.y1;
        }

        public int colour1() {
            return this.colour1;
        }

        public int colour2() {
            return this.colour2;
        }

        public int colour3() {
            return this.colour3;
        }

        public int colour4() {
            return this.colour4;
        }

        @Nullable
        public class_8030 comp_4069() {
            return this.scissorArea;
        }

        @Nullable
        public class_8030 comp_4274() {
            return this.bounds;
        }
    }
}

