/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3673;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_897;
import net.minecraft.class_9064;
import net.minecraft.class_9779;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESTextures;
import net.tslat.tes.api.object.TESHudElement;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESRenderUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.element.BuiltinHudElements;
import net.tslat.tes.core.hud.element.TESHudEntityIcon;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class TESHud {
    private static final Map<String, TESHudElement> ELEMENTS = (Map)class_156.method_654(Collections.synchronizedMap(new Object2ObjectArrayMap()), map -> {
        map.put("EntityName", BuiltinHudElements::renderEntityName);
        map.put("HealthBar", BuiltinHudElements::renderEntityHealth);
        map.put("Stats", BuiltinHudElements::renderEntityStats);
        map.put("Icons", BuiltinHudElements::renderEntityIcons);
        map.put("Effects", BuiltinHudElements::renderEntityEffects);
        map.put("HorseStats", BuiltinHudElements::renderHorseStats);
    });
    protected static final List<TESHudEntityIcon> ENTITY_ICONS = (List)class_156.method_654(new CopyOnWriteArrayList(), list -> list.addAll(List.of(TESHudEntityIcon.makeGeneric(TESTextures.PROPERTY_FIRE_IMMUNE, TESUtil::isFireImmune), TESHudEntityIcon.makeGeneric(TESTextures.PROPERTY_MELEE, TESUtil::isMeleeMob), TESHudEntityIcon.makeGeneric(TESTextures.PROPERTY_RANGED, TESUtil::isRangedMob), TESHudEntityIcon.makeGeneric(TESTextures.ENTITY_TYPE_AQUATIC, entity -> entity.method_5864().method_20210(class_3483.field_48288)), TESHudEntityIcon.makeGeneric(TESTextures.ENTITY_TYPE_ILLAGER, entity -> entity.method_5864().method_20210(class_3483.field_48287)), TESHudEntityIcon.makeGeneric(TESTextures.ENTITY_TYPE_ARTHROPOD, entity -> entity.method_5864().method_20210(class_3483.field_48289)), TESHudEntityIcon.makeGeneric(TESTextures.ENTITY_TYPE_UNDEAD, entity -> entity.method_5864().method_20210(class_3483.field_46232)))));
    private static TESHudElement[] INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
    private static class_1309 TARGET_ENTITY = null;
    private static long TARGET_EXPIRY_TIME = -1L;

    public static void setTargetEntity(class_1309 entity) {
        TARGET_ENTITY = entity;
        TARGET_EXPIRY_TIME = class_3532.method_15357((double)(class_3673.method_15974() * 20.0)) + 1 + TESAPI.getConfig().hudTargetGracePeriod();
    }

    public static class_1309 getTargetEntity() {
        return TARGET_ENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHudElement(String name, TESHudElement element) {
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            ELEMENTS.put(name, element);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeHudElement(String name) {
        AtomicBoolean removed = new AtomicBoolean(false);
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            removed.set(ELEMENTS.remove(name) != null);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
        return removed.get();
    }

    public static void addHudEntityIcon(TESHudEntityIcon icon) {
        ENTITY_ICONS.add(icon);
    }

    public static void submitHudRenderTasks(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker) {
        if (TARGET_ENTITY == null) {
            return;
        }
        if (TARGET_ENTITY.method_31481() || TARGET_ENTITY.method_73183() != mc.field_1687 || (long)class_3532.method_15357((double)(class_3673.method_15974() * 20.0)) > TARGET_EXPIRY_TIME) {
            TARGET_ENTITY = null;
            return;
        }
        TESConfig config = TESAPI.getConfig();
        if (!config.hudEnabled() || class_310.method_1551().field_1690.field_1842 || !config.hudBossesEnabled() && TESConstants.UTILS.isBossEntity(TARGET_ENTITY)) {
            return;
        }
        float hudOpacity = config.hudOpacity();
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        TESHudRenderContext renderContext = TESHudRenderContext.guiContext(guiGraphics, deltaTracker.method_60636());
        poseStack.pushMatrix();
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
        config.hudRenderPosition().adjustRenderForHudPosition(guiGraphics);
        if (TESAPI.getConfig().hudEntityRender()) {
            TESRenderUtil.renderEntityIcon((TESHudRenderContext.InGuiArgs)renderContext.args().left().get(), mc, TARGET_ENTITY, hudOpacity, true);
            poseStack.translate(40.0f, 0.0f);
        }
        poseStack.translate(0.0f, 2.0f);
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
        for (TESHudElement element : ELEMENTS.values()) {
            int offset = element.render(renderContext, mc, TARGET_ENTITY, hudOpacity);
            if (offset <= 0) continue;
            poseStack.translate(0.0f, (float)(2 + offset));
        }
        poseStack.popMatrix();
    }

    public static void submitWorldRenderTasks(class_4587 poseStack, class_11659 renderTasks, class_12075 cameraRenderState, class_1309 entity, class_9779 deltaTracker) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || !entityState.isValid()) {
            return;
        }
        entityState.markActive();
        class_310 mc = class_310.method_1551();
        TESConfig config = TESAPI.getConfig();
        if (!config.inWorldBarsEnabled() || entity.method_24204().anyMatch(passenger -> passenger == mc.field_1724) && !config.inWorldHudForSelf() || !config.inWorldHUDActivation().test(entityState) || !config.inWorldHudBossesEnabled() && TESConstants.UTILS.isBossEntity(TARGET_ENTITY)) {
            return;
        }
        float partialTick = deltaTracker.method_60637(!entity.method_73183().method_54719().method_54746((class_1297)entity));
        float hudOpacity = config.inWorldHudOpacity();
        class_897 renderer = mc.method_1561().method_3953((class_1297)entity);
        class_243 position = entity.method_30950(partialTick).method_1020(mc.field_1773.method_19418().method_19326()).method_1019(renderer.method_23169(renderer.method_62425((class_1297)entity, partialTick)));
        class_243 nameTagOffset = entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_61415(partialTick));
        if (nameTagOffset == null) {
            nameTagOffset = new class_243(0.0, (double)entity.method_17682(), 0.0);
        }
        nameTagOffset = nameTagOffset.method_1031(0.0, 0.5, 0.0);
        poseStack.method_22903();
        poseStack.method_22904(position.field_1352, position.field_1351, position.field_1350);
        poseStack.method_61958(nameTagOffset);
        poseStack.method_46416(0.0f, config.inWorldHudManualVerticalOffset(), 0.0f);
        TESRenderUtil.positionFacingCamera(poseStack);
        poseStack.method_22905(0.02f, 0.02f, 0.02f);
        TESHudRenderContext renderContext = TESHudRenderContext.inWorldContext(poseStack, renderTasks, cameraRenderState, partialTick, renderer.method_24088((class_1297)entity, partialTick));
        for (TESHudElement element : INVERSE_ELEMENTS) {
            int offset = element.render(renderContext, mc, entity, hudOpacity);
            if (offset <= 0) continue;
            poseStack.method_46416(0.0f, (float)(-(2 + offset)), 0.0f);
        }
        poseStack.method_22909();
    }

    public static void pickNewEntity(float partialTick, @Nullable class_1297 crosshairTarget) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1692 != null) {
            class_1309 target = TESConstants.UTILS.getLivingEntityIfPossible(mc.field_1692);
            if (target != null && TESUtil.shouldTESHandleEntity((class_1297)target, TESClientUtil.getClientPlayer())) {
                TESHud.setTargetEntity(target);
            }
        } else {
            class_238 hitBounds;
            class_243 cameraView;
            class_243 rayEnd;
            class_243 cameraPos;
            double targetingRange = TESAPI.getConfig().hudTargetDistance();
            class_1297 cameraEntity = TESClientUtil.getClientCamera();
            class_3966 hitResult = class_1675.method_18075((class_1297)cameraEntity, (class_243)(cameraPos = cameraEntity.method_5836(partialTick)), (class_243)(rayEnd = cameraPos.method_1019((cameraView = cameraEntity.method_5828(partialTick)).method_18805(targetingRange, targetingRange, targetingRange))), (class_238)(hitBounds = cameraEntity.method_5829().method_18804(cameraView.method_1021(targetingRange)).method_1009(1.0, 1.0, 1.0)), entity -> !entity.method_7325() && entity.method_5863(), (double)(targetingRange * targetingRange));
            if (hitResult == null) {
                return;
            }
            class_1309 target = TESConstants.UTILS.getLivingEntityIfPossible(hitResult.method_17782());
            if (target == null || !TESUtil.shouldTESHandleEntity((class_1297)target, TESClientUtil.getClientPlayer())) {
                return;
            }
            double entityHitClipDistanceSqr = hitResult.method_17784().method_1025(cameraPos);
            targetingRange = Math.sqrt(entityHitClipDistanceSqr);
            rayEnd = cameraPos.method_1019(cameraView.method_18805(targetingRange, targetingRange, targetingRange));
            class_3965 blockHitResult = cameraEntity.method_73183().method_17742(new class_3959(cameraPos, rayEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, cameraEntity));
            if (blockHitResult == null || blockHitResult.method_17783() == class_239.class_240.field_1333 || blockHitResult.method_17784().method_1025(cameraPos) > entityHitClipDistanceSqr) {
                TESHud.setTargetEntity(target);
            }
        }
    }

    public static List<TESHudEntityIcon> getEntityIcons() {
        return ENTITY_ICONS;
    }

    private static TESHudElement[] buildInverseElementArray(Collection<TESHudElement> elements) {
        TESHudElement[] array = new TESHudElement[elements.size()];
        int i = elements.size() - 1;
        for (TESHudElement element : elements) {
            array[i--] = element;
        }
        return array;
    }

    public static enum BarRenderType {
        NUMERIC,
        BAR,
        BAR_ICONS,
        COMBINED;

    }
}

