/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tslat.tes.TES;
import net.tslat.tes.core.networking.TESNetworking;
import net.tslat.tes.core.networking.packet.MultiloaderConfigurationPacket;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;
import net.tslat.tes.core.networking.packet.NewComponentParticlePacket;
import net.tslat.tes.core.networking.packet.NewNumericParticlePacket;
import net.tslat.tes.core.networking.packet.ParticleClaimPacket;
import net.tslat.tes.core.networking.packet.RequestEffectsPacket;
import net.tslat.tes.core.networking.packet.SyncEffectsPacket;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

public final class TESNetworking
implements net.tslat.tes.core.networking.TESNetworking {
    @Override
    @ApiStatus.Internal
    public <B extends FriendlyByteBuf, P extends MultiloaderConfigurationPacket> void registerConfigurationPacketInternal(CustomPacketPayload.Type<P> payloadType, StreamCodec<B, P> codec, TESNetworking.Direction direction) {
        switch (direction) {
            case CLIENTBOUND: {
                TES.packetRegistrar.configurationToClient(payloadType, codec, (packet, context) -> packet.handleTask(new MultiloaderConfigurationPacket.TaskHandler(arg_0 -> ((IPayloadContext)context).reply(arg_0), type -> {})));
                break;
            }
            case SERVERBOUND: {
                TES.packetRegistrar.configurationToServer(payloadType, codec, (packet, context) -> packet.handleTask(new MultiloaderConfigurationPacket.TaskHandler(reply -> {}, arg_0 -> ((IPayloadContext)context).finishCurrentTask(arg_0))));
                break;
            }
            case BIDIRECTIONAL: {
                TES.packetRegistrar.configurationBidirectional(payloadType, codec, (packet, context) -> packet.handleTask(new MultiloaderConfigurationPacket.TaskHandler(reply -> {
                    if (context.flow().isClientbound()) {
                        context.reply((CustomPacketPayload)reply);
                    }
                }, task -> {
                    if (context.flow().isServerbound()) {
                        context.finishCurrentTask(task);
                    }
                })), (packet, context) -> packet.handleTask(new MultiloaderConfigurationPacket.TaskHandler(reply -> {
                    if (context.flow().isClientbound()) {
                        context.reply((CustomPacketPayload)reply);
                    }
                }, task -> {
                    if (context.flow().isServerbound()) {
                        context.finishCurrentTask(task);
                    }
                })));
            }
        }
    }

    @Override
    public <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerPacketInternal(CustomPacketPayload.Type<P> payloadType, StreamCodec<B, P> codec, TESNetworking.Direction direction) {
        switch (direction) {
            case CLIENTBOUND: {
                TES.packetRegistrar.playToClient(payloadType, codec, (packet, context) -> packet.receiveMessage(context.player(), arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0)));
                break;
            }
            case SERVERBOUND: {
                TES.packetRegistrar.playToServer(payloadType, codec, (packet, context) -> packet.receiveMessage(context.player(), arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0)));
                break;
            }
            case BIDIRECTIONAL: {
                TES.packetRegistrar.playBidirectional(payloadType, codec, (packet, context) -> packet.receiveMessage(context.player(), arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0)), (packet, context) -> packet.receiveMessage(context.player(), arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0)));
            }
        }
    }

    @Override
    public void requestEffectsSync(int entityId) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new RequestEffectsPacket(entityId), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendEffectsSync(ServerPlayer player, int entityId, Set<Holder<MobEffect>> toAdd, Set<Holder<MobEffect>> toRemove) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncEffectsPacket(entityId, toAdd, toRemove), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendEffectsSync(LivingEntity targetedEntity, Set<Holder<MobEffect>> toAdd, Set<Holder<MobEffect>> toRemove) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)targetedEntity, (CustomPacketPayload)new SyncEffectsPacket(targetedEntity.getId(), toAdd, toRemove), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendParticle(ServerLevel level, Vector3f position, Component contents) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)position.x, (double)position.y, (double)position.z, (double)200.0, (CustomPacketPayload)new NewComponentParticlePacket(position, contents), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendParticle(LivingEntity targetedEntity, Component contents) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)targetedEntity, (CustomPacketPayload)new NewComponentParticlePacket(targetedEntity, contents), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendParticle(ServerLevel level, Vector3f position, double value, int colour) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)position.x, (double)position.y, (double)position.z, (double)200.0, (CustomPacketPayload)new NewNumericParticlePacket(value, position, colour), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendParticle(LivingEntity targetedEntity, double value, int colour) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)targetedEntity, (CustomPacketPayload)new NewNumericParticlePacket(value, new Vector3f((float)targetedEntity.getX(), (float)targetedEntity.getEyeY(), (float)targetedEntity.getZ()), colour), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendParticleClaim(ResourceLocation claimantId, LivingEntity targetedEntity, Optional<CompoundTag> additionalData) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)targetedEntity, (CustomPacketPayload)new ParticleClaimPacket(targetedEntity.getId(), claimantId, additionalData), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

