/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.payload.PayloadFlow;
import net.minecraftforge.network.payload.PayloadProtocol;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;
import net.tslat.tes.core.networking.packet.NewComponentParticlePacket;
import net.tslat.tes.core.networking.packet.NewNumericParticlePacket;
import net.tslat.tes.core.networking.packet.ParticleClaimPacket;
import net.tslat.tes.core.networking.packet.RequestEffectsPacket;
import net.tslat.tes.core.networking.packet.SyncEffectsPacket;
import org.joml.Vector3f;

public final class TESNetworking
implements net.tslat.tes.core.networking.TESNetworking {
    public static PayloadProtocol<RegistryFriendlyByteBuf, CustomPacketPayload> NETWORK_CHANNEL_BUILDER = ChannelBuilder.named((ResourceLocation)TESConstants.id("tes_packets")).networkProtocolVersion(0).optional().payloadChannel().play();
    public static Channel<CustomPacketPayload> CHANNEL;

    public static void init() {
        net.tslat.tes.core.networking.TESNetworking.init();
        CHANNEL = ((PayloadFlow)NETWORK_CHANNEL_BUILDER.bidirectional()).build();
    }

    @Override
    public <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerPacketInternal(CustomPacketPayload.Type<P> packetType, StreamCodec<B, P> codec, boolean isClientBound) {
        if (isClientBound) {
            ((PayloadFlow)NETWORK_CHANNEL_BUILDER.clientbound()).add(packetType, codec, (packet, context) -> {
                packet.receiveMessage((Player)(context.getSender() != null ? context.getSender() : TESClientUtil.getClientPlayer()), arg_0 -> ((CustomPayloadEvent.Context)context).enqueueWork(arg_0));
                context.setPacketHandled(true);
            });
        } else {
            ((PayloadFlow)NETWORK_CHANNEL_BUILDER.serverbound()).add(packetType, codec, (packet, context) -> {
                packet.receiveMessage((Player)(context.getSender() != null ? context.getSender() : TESClientUtil.getClientPlayer()), arg_0 -> ((CustomPayloadEvent.Context)context).enqueueWork(arg_0));
                context.setPacketHandled(true);
            });
        }
    }

    @Override
    public void requestEffectsSync(int entityId) {
        CHANNEL.send((Object)new RequestEffectsPacket(entityId), PacketDistributor.SERVER.noArg());
    }

    @Override
    public void sendEffectsSync(ServerPlayer player, int entityId, Set<Holder<MobEffect>> toAdd, Set<Holder<MobEffect>> toRemove) {
        CHANNEL.send((Object)new SyncEffectsPacket(entityId, toAdd, toRemove), PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public void sendEffectsSync(LivingEntity targetedEntity, Set<Holder<MobEffect>> toAdd, Set<Holder<MobEffect>> toRemove) {
        CHANNEL.send((Object)new SyncEffectsPacket(targetedEntity.getId(), toAdd, toRemove), PacketDistributor.TRACKING_ENTITY.with((Object)targetedEntity));
    }

    @Override
    public void sendParticle(ServerLevel level, Vector3f position, Component contents) {
        CHANNEL.send((Object)new NewComponentParticlePacket(position, contents), PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint((double)position.x, (double)position.y, (double)position.z, 200.0, level.dimension())));
    }

    @Override
    public void sendParticle(LivingEntity targetedEntity, Component contents) {
        CHANNEL.send((Object)new NewComponentParticlePacket(targetedEntity, contents), PacketDistributor.TRACKING_ENTITY.with((Object)targetedEntity));
    }

    @Override
    public void sendParticle(ServerLevel level, Vector3f position, double value, int colour) {
        CHANNEL.send((Object)new NewNumericParticlePacket(value, position, colour), PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint((double)position.x, (double)position.y, (double)position.z, 200.0, level.dimension())));
    }

    @Override
    public void sendParticle(LivingEntity targetedEntity, double value, int colour) {
        CHANNEL.send((Object)new NewNumericParticlePacket(value, new Vector3f((float)targetedEntity.getX(), (float)targetedEntity.getEyeY(), (float)targetedEntity.getZ()), colour), PacketDistributor.TRACKING_ENTITY.with((Object)targetedEntity));
    }

    @Override
    public void sendParticleClaim(ResourceLocation claimantId, LivingEntity targetedEntity, Optional<CompoundTag> additionalData) {
        CHANNEL.send((Object)new ParticleClaimPacket(targetedEntity.getId(), claimantId, additionalData), PacketDistributor.TRACKING_ENTITY.with((Object)targetedEntity));
    }
}

