/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.util.TESClientUtil;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface TESParticle<D> {
    public void updateData(D var1);

    public void render(class_332 var1, class_310 var2, class_327 var3, float var4);

    public void tick(class_310 var1);

    public boolean isValid();

    default public void defaultedTextRender(class_310 mc, class_4587 poseStack, Vector3f prevPos, Vector3f pos, float partialTick, Runnable renderCallback) {
        float scale = 0.035f * TESAPI.getConfig().getParticleScale();
        class_4184 camera = mc.field_1773.method_19418();
        Vector3f renderPos = prevPos.lerp((Vector3fc)pos, partialTick, new Vector3f()).sub((Vector3fc)camera.method_19326().method_46409());
        poseStack.method_22903();
        poseStack.method_46416(renderPos.x, renderPos.y, renderPos.z);
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22905(scale, scale, scale);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        renderCallback.run();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    public static abstract class Animation {
        public static final Animation POP_OFF = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                return new Vector3f((float)random.nextGaussian() * 0.03f + 0.025f, random.nextFloat() * 0.035f + 0.37f, (float)random.nextGaussian() * 0.03f + 0.025f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.sub(0.0f, 0.05f, 0.0f);
                pos.add((Vector3fc)velocity);
            }
        };
        public static final Animation RISE = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                position.add((float)random.nextGaussian() * 0.05f, 0.4f, (float)random.nextGaussian() * 0.05f);
                return new Vector3f(0.0f, 0.2f, 0.0f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.sub(0.0f, 0.02f, 0.0f);
                if (velocity.y() < 0.0f) {
                    velocity.mul(1.0f, 0.5f, 1.0f);
                }
                pos.add((Vector3fc)velocity);
            }
        };

        public abstract Vector3f getInitialVelocity(TESParticle<?> var1, Vector3f var2, Random var3);

        public abstract void perTickModifier(TESParticle<?> var1, int var2, Vector3f var3, Vector3f var4, Vector3f var5, Random var6);
    }
}

